/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.rei;

import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.integration.rei.SextupleDisplay;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SextupleCategory
implements DisplayCategory<SextupleDisplay> {
    public static final ResourceLocation GUI = new ResourceLocation("runecraftory", "textures/gui/crafting.png");
    private final EnumCrafting type;
    private final CategoryIdentifier<SextupleDisplay> identifier;
    private static final int X_SIZE = 119;
    private static final int Y_SIZE = 42;

    public SextupleCategory(EnumCrafting type, CategoryIdentifier<SextupleDisplay> identifier) {
        this.type = type;
        this.identifier = identifier;
    }

    public Renderer getIcon() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case EnumCrafting.FORGE -> EntryStacks.of((ItemLike)((ItemLike)ModItems.ITEM_BLOCK_FORGE.get()));
            case EnumCrafting.ARMOR -> EntryStacks.of((ItemLike)((ItemLike)ModItems.ITEM_BLOCK_ACCESS.get()));
            case EnumCrafting.CHEM -> EntryStacks.of((ItemLike)((ItemLike)ModItems.ITEM_BLOCK_CHEM.get()));
            case EnumCrafting.COOKING -> EntryStacks.of((ItemLike)((ItemLike)ModItems.ITEM_BLOCK_COOKING.get()));
        };
    }

    public Component getTitle() {
        return new TranslatableComponent("runecraftory.container.crafting." + this.type.getId());
    }

    public List<Widget> setupDisplay(SextupleDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createTexturedWidget((ResourceLocation)GUI, (int)bounds.getX(), (int)bounds.getY(), (float)19.0f, (float)20.0f, (int)119, (int)42));
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (display.recipe() != null && Platform.INSTANCE.getPlayerData((Player)player).map(cap -> cap.getRecipeKeeper().isUnlocked(display.recipe())).orElse(false).booleanValue()) {
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 3; ++x) {
                    int ind = x + y * 3;
                    if (ind >= display.getInputEntries().size()) continue;
                    widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getX() + 1 + x * 18, bounds.getY() + 6 + y * 18)).entries((Collection)display.getInputEntries().get(ind)));
                }
            }
            TranslatableComponent level = new TranslatableComponent("runecraftory.recipe_integration.crafting_level", new Object[]{display.recipe().getCraftingLevel()});
            widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.getX() + bounds.getWidth(), bounds.getY()), (Component)level).noShadow().rightAligned().color(-12566464, -4473925));
        } else {
            widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getX() + 64, bounds.getY() + 14)).entry(EntryStacks.of((ItemStack)new ItemStack((ItemLike)ModItems.UNKNOWN.get())).tooltip(new Component[]{new TranslatableComponent("runecraftory.recipe_integration.locked")})));
        }
        widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getX() + 97, bounds.getY() + 15)).backgroundEnabled(false).entries((Collection)display.getOutputEntries().get(0)));
        return widgets;
    }

    public int getDisplayHeight() {
        return 42;
    }

    public int getDisplayWidth(SextupleDisplay display) {
        return 119;
    }

    public CategoryIdentifier<? extends SextupleDisplay> getCategoryIdentifier() {
        return this.identifier;
    }
}

