/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixin;

import io.github.flemmli97.runecraftory.common.entities.GateEntity;
import io.github.flemmli97.runecraftory.mixinhelper.MixinUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Unique
    private double runecraftoryMoveTracker;

    @Inject(method={"canCollideWith"}, at={@At(value="HEAD")}, cancellable=true)
    private void collideCheckEntitySensitive(Entity other, CallbackInfoReturnable<Boolean> info) {
        GateEntity gate;
        if (other instanceof GateEntity && !(gate = (GateEntity)other).canBeCollidedWith((Entity)this)) {
            info.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getMovementEmission()Lnet/minecraft/world/entity/Entity$MovementEmission;"), ordinal=1)
    private Vec3 onStepLiving(Vec3 orig, MoverType type, Vec3 pos) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entityMixin;
            this.runecraftoryMoveTracker += orig.m_82556_();
            float pre = living.f_19788_;
            living.f_19788_ = 0.0f;
            float next = this.m_6059_();
            living.f_19788_ = pre;
            if (this.runecraftoryMoveTracker > 0.25) {
                this.runecraftoryMoveTracker = 0.0;
                MixinUtils.triggerArmorStepEffect(living);
            }
        }
        return orig;
    }

    @Shadow
    protected abstract float m_6059_();
}

