/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientCalls;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Final
    @Shadow
    private Minecraft f_109461_;
    @Shadow
    private ClientLevel f_109465_;
    @Unique
    private Biome runecraftoryCacheBiome;

    @ModifyVariable(method={"renderSnowAndRain"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;warmEnoughToRain(Lnet/minecraft/core/BlockPos;)Z"))
    private Biome cacheBiomeSnowRain(Biome biome) {
        this.runecraftoryCacheBiome = biome;
        return biome;
    }

    @ModifyVariable(method={"renderSnowAndRain"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;warmEnoughToRain(Lnet/minecraft/core/BlockPos;)Z"))
    private BlockPos.MutableBlockPos snowRainCheck(BlockPos.MutableBlockPos pos) {
        if (WorldUtils.coldEnoughForSnow((Level)this.f_109461_.f_91073_, (BlockPos)pos, this.runecraftoryCacheBiome)) {
            pos.m_122178_(pos.m_123341_(), 1000, pos.m_123343_());
        }
        return pos;
    }

    @ModifyVariable(method={"tickRain"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;getY()I", ordinal=0, shift=At.Shift.BEFORE))
    private Biome cacheBiomeTickRain(Biome biome) {
        this.runecraftoryCacheBiome = biome;
        return biome;
    }

    @ModifyVariable(method={"tickRain"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;getY()I", ordinal=0, shift=At.Shift.BEFORE), ordinal=2)
    private BlockPos rainTickCheck(BlockPos pos) {
        if (WorldUtils.coldEnoughForSnow((Level)this.f_109461_.f_91073_, pos, this.runecraftoryCacheBiome)) {
            return new BlockPos(pos.m_123341_(), this.f_109461_.f_91073_.m_141937_() - 1, pos.m_123343_());
        }
        return pos;
    }

    @Inject(method={"renderHitOutline"}, at={@At(value="RETURN")})
    private void onBlockOutline(PoseStack poseStack, VertexConsumer consumer, Entity entity, double camX, double camY, double camZ, BlockPos pos, BlockState state, CallbackInfo info) {
        ClientCalls.onBlockHighlightRender((Level)this.f_109465_, poseStack, consumer, entity, camX, camY, camZ, pos, state);
    }
}

