/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixin;

import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.events.EntityCalls;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Map;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    private boolean runecraftoryStopKnockback;

    @Inject(method={"setSprinting"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSprint(boolean sprinting, CallbackInfo info) {
        if (sprinting && Platform.INSTANCE.getEntityData((LivingEntity)this).map(EntityData::isParalysed).orElse(false).booleanValue()) {
            info.cancel();
        }
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;dropEquipment()V", shift=At.Shift.AFTER)})
    private void doDeathLootDrop(DamageSource source, CallbackInfo info) {
        EntityCalls.dropInventoryDeath((LivingEntity)this);
    }

    @Inject(method={"collectEquipmentChanges"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onChange(CallbackInfoReturnable<Map<EquipmentSlot, ItemStack>> info, Map<EquipmentSlot, ItemStack> map) {
        if (map != null) {
            EntityCalls.updateEquipment((LivingEntity)this, map, this.m_21244_(EquipmentSlot.MAINHAND), this::m_21198_);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V")})
    private void onHurtKnockback(DamageSource source, float amount, CallbackInfoReturnable<Boolean> info) {
        if (source instanceof CustomDamage) {
            this.runecraftoryStopKnockback = true;
        }
    }

    @Inject(method={"knockback"}, at={@At(value="HEAD")}, cancellable=true)
    private void knockbackCheck(double strength, double x, double z, CallbackInfo info) {
        if (this.runecraftoryStopKnockback) {
            info.cancel();
        }
        this.runecraftoryStopKnockback = false;
    }

    @Shadow
    protected abstract ItemStack m_21244_(EquipmentSlot var1);

    @Shadow
    protected abstract ItemStack m_21198_(EquipmentSlot var1);
}

