/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixin;

import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.events.EntityCalls;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.mixinhelper.MixinUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin {
    @Unique
    private Biome runecraftoryBiomeCache;

    @ModifyVariable(method={"tickChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;shouldSnow(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z"))
    private Biome cacheBiome(Biome biome) {
        this.runecraftoryBiomeCache = biome;
        return biome;
    }

    @ModifyArg(method={"tickChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;handlePrecipitation(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/biome/Biome$Precipitation;)V"))
    private Biome.Precipitation withSeason(BlockState state, Level level, BlockPos pos, Biome.Precipitation old) {
        if (GeneralConfig.seasonedSnow && WorldUtils.coldEnoughForSnow(level, pos, this.runecraftoryBiomeCache) && this.runecraftoryBiomeCache.m_47530_() != Biome.Precipitation.NONE) {
            BlockPos above = pos.m_7494_();
            if (WorldUtils.canPlaceSnowAt(level, above)) {
                level.m_46597_(above, ((Block)ModBlocks.SNOW.get()).m_49966_());
            }
            if (old == Biome.Precipitation.RAIN) {
                return Biome.Precipitation.SNOW;
            }
        }
        return old;
    }

    @Inject(method={"onBlockStateChange"}, at={@At(value="RETURN")})
    private void stateChangeInject(BlockPos pos, BlockState blockState, BlockState newState, CallbackInfo info) {
        MixinUtils.onBlockStateChange((ServerLevel)this, pos, blockState, newState);
    }

    @Inject(method={"tickNonPassenger"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTickEntity(Entity entity, CallbackInfo info) {
        LivingEntity living;
        if (entity instanceof LivingEntity && EntityCalls.rootTick(living = (LivingEntity)entity)) {
            info.cancel();
            for (Entity passengers : entity.m_20197_()) {
                LivingEntity livingPass;
                if (entity instanceof LivingEntity && EntityCalls.rootTick(livingPass = (LivingEntity)entity)) continue;
                this.m_8662_(entity, passengers);
            }
        }
    }

    @Shadow
    protected abstract void m_8662_(Entity var1, Entity var2);
}

