/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixin;

import io.github.flemmli97.runecraftory.common.blocks.tile.TreeBlockEntity;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={TreeFeature.class})
public abstract class TreeFeatureMixin {
    @Unique
    private TreeBlockEntity runecraftory_placingFruitTree;

    @ModifyVariable(method={"place"}, at=@At(value="TAIL"), ordinal=0)
    private Set<BlockPos> handleLogSet(Set<BlockPos> logs, FeaturePlaceContext<TreeConfiguration> context) {
        BlockEntity entity = context.m_159774_().m_7702_(context.m_159777_());
        if (entity instanceof TreeBlockEntity) {
            TreeBlockEntity tree;
            this.runecraftory_placingFruitTree = tree = (TreeBlockEntity)entity;
            tree.updateTreeLogs(logs);
        }
        return logs;
    }

    @ModifyVariable(method={"place"}, at=@At(value="TAIL"), ordinal=1)
    private Set<BlockPos> handleLeaveSet(Set<BlockPos> leaves) {
        if (this.runecraftory_placingFruitTree != null) {
            this.runecraftory_placingFruitTree.updateTreeLeaves(leaves);
        }
        return leaves;
    }

    @ModifyVariable(method={"place"}, at=@At(value="TAIL"), ordinal=2)
    private Set<BlockPos> handleDecoratorSet(Set<BlockPos> decorators) {
        if (this.runecraftory_placingFruitTree != null) {
            this.runecraftory_placingFruitTree.updateTreeFruits(decorators);
        }
        return decorators;
    }
}

