/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixinhelper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.runecraftory.client.ArmorModels;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.ItemModelProps;
import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerWeaponHandler;
import io.github.flemmli97.runecraftory.common.items.BigWeapon;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemDualBladeBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemGloveBase;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.CalendarImpl;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;

public class ClientMixinUtils {
    public static final int LEAVE_SPRING = 870913;
    public static final int LEAVE_FALL = 0xFF4646;
    private static final Map<SeasonedTint, Integer> LEAVE_TINTS = new ConcurrentHashMap<SeasonedTint, Integer>();
    private static final Map<SeasonedTint, Integer> GRASS_TINTS = new ConcurrentHashMap<SeasonedTint, Integer>();
    private static boolean ItemRenderContext;

    public static int modifyColoredTint(BlockAndTintGetter getter, int old) {
        CalendarImpl calendar = ClientHandlers.CLIENT_CALENDAR;
        if (calendar.currentSeason() == EnumSeason.SUMMER) {
            return old;
        }
        return LEAVE_TINTS.computeIfAbsent(new SeasonedTint(old, calendar.currentSeason()), ClientMixinUtils::getLeaveTint);
    }

    public static int modifyColoredTintGrass(BlockAndTintGetter getter, int old) {
        CalendarImpl calendar = ClientHandlers.CLIENT_CALENDAR;
        if (calendar.currentSeason() == EnumSeason.SUMMER) {
            return old;
        }
        return GRASS_TINTS.computeIfAbsent(new SeasonedTint(old, calendar.currentSeason()), ClientMixinUtils::getGrassTint);
    }

    private static int getLeaveTint(SeasonedTint tint) {
        return switch (tint.season) {
            default -> throw new IncompatibleClassChangeError();
            case EnumSeason.SPRING -> ClientMixinUtils.desaturate(ClientMixinUtils.add(tint.origin, 870913), 0.1f);
            case EnumSeason.SUMMER -> tint.origin;
            case EnumSeason.FALL -> ClientMixinUtils.desaturate(ClientMixinUtils.add(FastColor.ARGB32.m_13657_((int)tint.origin, (int)0xFF4646), 3939840), 0.2f);
            case EnumSeason.WINTER -> ClientMixinUtils.desaturate(ClientMixinUtils.add(FastColor.ARGB32.m_13657_((int)tint.origin, (int)0xFF4646), 3939840), 0.6f);
        };
    }

    private static int getGrassTint(SeasonedTint tint) {
        return switch (tint.season) {
            default -> throw new IncompatibleClassChangeError();
            case EnumSeason.SPRING -> ClientMixinUtils.desaturate(ClientMixinUtils.add(tint.origin, 870913), 0.1f);
            case EnumSeason.SUMMER -> tint.origin;
            case EnumSeason.FALL -> ClientMixinUtils.desaturate(tint.origin, 0.25f);
            case EnumSeason.WINTER -> ClientMixinUtils.desaturate(tint.origin, 0.7f);
        };
    }

    private static int desaturate(int color, float perc) {
        int r = FastColor.ARGB32.m_13665_((int)color);
        int g = FastColor.ARGB32.m_13667_((int)color);
        int b = FastColor.ARGB32.m_13669_((int)color);
        int gray = Math.max(b, Math.max(r, g));
        return FastColor.ARGB32.m_13660_((int)FastColor.ARGB32.m_13655_((int)color), (int)((int)((float)r + (float)(gray - r) * perc)), (int)((int)((float)g + (float)(gray - g) * perc)), (int)((int)((float)b + (float)(gray - b) * perc)));
    }

    private static int add(int packedColourOne, int packedColorTwo) {
        return FastColor.ARGB32.m_13660_((int)Math.min(255, FastColor.ARGB32.m_13655_((int)packedColourOne) + FastColor.ARGB32.m_13655_((int)packedColorTwo)), (int)Math.min(255, FastColor.ARGB32.m_13665_((int)packedColourOne) + FastColor.ARGB32.m_13665_((int)packedColorTwo)), (int)Math.min(255, FastColor.ARGB32.m_13667_((int)packedColourOne) + FastColor.ARGB32.m_13667_((int)packedColorTwo)), (int)Math.min(255, FastColor.ARGB32.m_13669_((int)packedColourOne) + FastColor.ARGB32.m_13669_((int)packedColorTwo)));
    }

    public static void translateSleepingEntity(LivingEntity entity, PoseStack poseStack, float flipDegrees) {
        if (EntityData.getSleepStateFrom(entity) == EntityData.SleepState.VANILLA && flipDegrees != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(flipDegrees));
            float standOffset = entity.m_20236_(Pose.STANDING) * 0.6f;
            poseStack.m_85837_(0.0, (double)(-standOffset), 0.0);
        }
    }

    public static boolean shouldAnimate(LivingEntity entity) {
        return ClientHandlers.getAnimatedPlayerModel() != null && (entity instanceof Player || entity instanceof IAnimated);
    }

    public static void transformHumanoidModel(LivingEntity entity, HumanoidModel<?> model) {
        InteractionHand off;
        InteractionHand main = entity.m_5737_() == HumanoidArm.RIGHT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        InteractionHand interactionHand = off = entity.m_5737_() == HumanoidArm.RIGHT ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        if (model.f_102816_ == HumanoidModel.ArmPose.ITEM && entity.m_21120_(main).m_150930_((Item)ModItems.UMBRELLA.get())) {
            model.f_102811_.f_104203_ -= 1.2217305f;
        }
        if (model.f_102815_ == HumanoidModel.ArmPose.ITEM && entity.m_21120_(off).m_150930_((Item)ModItems.UMBRELLA.get())) {
            model.f_102812_.f_104203_ -= 1.2217305f;
        }
        if (ClientHandlers.getAnimatedPlayerModel() != null) {
            PlayerWeaponHandler weaponHandler;
            float partialTicks = ClientHandlers.getPartialTicks();
            if (entity instanceof IAnimated) {
                boolean result = ClientHandlers.getAnimatedPlayerModel().setUpModel(entity, model, null, partialTicks);
                if (result) {
                    ClientHandlers.getAnimatedPlayerModel().copyTo(model);
                }
                return;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                v1 = Platform.INSTANCE.getPlayerData(player).map(PlayerData::getWeaponHandler).orElse(null);
            } else {
                v1 = weaponHandler = null;
            }
            if (weaponHandler == null) {
                return;
            }
            boolean ignoreRiding = weaponHandler.getCurrentAction() == ModAttackActions.DUAL_USE.get();
            boolean result = ClientHandlers.getAnimatedPlayerModel().setUpModel(entity, model, weaponHandler, partialTicks);
            if (result) {
                ClientHandlers.getAnimatedPlayerModel().copyTo(model);
                if (ItemRenderContext) {
                    model.m_8009_(false);
                    model.f_102812_.f_104207_ = true;
                    model.f_102811_.f_104207_ = true;
                    if (model instanceof PlayerModel) {
                        PlayerModel playerModel = (PlayerModel)model;
                        playerModel.f_103374_.m_104315_(model.f_102812_);
                        playerModel.f_103375_.m_104315_(model.f_102811_);
                    }
                }
            }
        }
    }

    public static void onRenderHand(PoseStack poseStack, AbstractClientPlayer player, boolean rightArm, PlayerModel<AbstractClientPlayer> arm, MultiBufferSource buffer, int combinedLight) {
        for (ItemStack stack : player.m_6168_()) {
            ArmorModels.FirstPersonArmorRenderer r;
            if (stack.m_41619_() || (r = ArmorModels.getFirstPersonRenderer(stack)) == null) continue;
            r.render(player, stack, rightArm, arm, poseStack, buffer, combinedLight);
        }
    }

    public static void adjustForHeldModel(ItemStack itemStack, ItemTransforms.TransformType transformType) {
        if (itemStack.m_41720_() instanceof ItemGloveBase || itemStack.m_41720_() instanceof BigWeapon) {
            ItemModelProps.HELD_TYPE = switch (transformType) {
                case ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND -> 1;
                case ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND -> 2;
                default -> 0;
            };
        } else if (itemStack.m_41720_() instanceof ItemDualBladeBase) {
            ItemModelProps.HELD_TYPE = switch (transformType) {
                case ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND -> 1;
                default -> 0;
            };
        }
    }

    public static void resetHeldModel() {
        ItemModelProps.HELD_TYPE = 0;
    }

    public static boolean onRenderHeldItem(LivingEntity livingEntity, ItemStack itemStack, ItemTransforms.TransformType transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight) {
        if (livingEntity instanceof AbstractClientPlayer) {
            PlayerData data;
            AbstractClientPlayer player = (AbstractClientPlayer)livingEntity;
            if (transformType.m_111841_() && (data = (PlayerData)Platform.INSTANCE.getPlayerData((Player)player).orElse(null)) != null) {
                PlayerRenderer playerRenderer = (PlayerRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)player);
                float partialTicks = ClientHandlers.getPartialTicks();
                boolean animated = ClientHandlers.getAnimatedPlayerModel().setUpModel((LivingEntity)player, (HumanoidModel)playerRenderer.m_7200_(), data.getWeaponHandler(), partialTicks);
                if (!animated) {
                    return false;
                }
                if (leftHand == (livingEntity.m_5737_() == HumanoidArm.RIGHT)) {
                    return true;
                }
                player.m_36334_();
                poseStack = new PoseStack();
                poseStack.m_85836_();
                Vec3 camPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
                double camX = camPos.m_7096_();
                double camY = camPos.m_7098_();
                double camZ = camPos.m_7094_();
                Vec3 vec3 = playerRenderer.m_7860_(player, partialTicks);
                double x = Mth.m_14139_((double)partialTicks, (double)player.f_19790_, (double)player.m_20185_());
                double y = Mth.m_14139_((double)partialTicks, (double)player.f_19791_, (double)player.m_20186_());
                double z = Mth.m_14139_((double)partialTicks, (double)player.f_19792_, (double)player.m_20189_());
                poseStack.m_85837_(x += vec3.m_7096_() - camX, y += vec3.m_7098_() - camY, z += vec3.m_7094_() - camZ);
                poseStack.m_85837_(0.0, 0.1, 0.1);
                float rot = Mth.m_14179_((float)partialTicks, (float)player.f_19859_, (float)player.m_146908_());
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(rot + 180.0f));
                ItemRenderContext = true;
                playerRenderer.m_7392_(player, 0.0f, partialTicks, poseStack, buffer, combinedLight);
                ItemRenderContext = false;
                poseStack.m_85849_();
                return true;
            }
        }
        return ItemNBT.isInvis(itemStack);
    }

    public static ModelPartHandler.ModelPartExtended createPlayerItemPart(boolean left) {
        ModelPart item = new ModelPart(List.of(), Map.of());
        item.m_171322_(PartPose.m_171419_((float)(left ? -1.0f : 1.0f), (float)-8.0f, (float)0.0f));
        ModelPart root = new ModelPart(List.of(), Map.of(left ? "LeftItem" : "RightItem", item));
        root.m_171322_(PartPose.m_171419_((float)(left ? 1.0f : -1.0f), (float)8.0f, (float)0.0f));
        return new ModelPartHandler.ModelPartExtended(root);
    }

    record SeasonedTint(int origin, EnumSeason season) {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof SeasonedTint) {
                SeasonedTint tint = (SeasonedTint)obj;
                return tint.origin == this.origin && tint.season == this.season;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (String.valueOf((Object)this.season) + ";" + this.origin).hashCode();
        }
    }
}

