/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixinhelper;

import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.ModArmorEffects;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixinhelper.PrevEntityPosition;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class MixinUtils {
    public static boolean stop(Player player, ItemStack stack, HitResult hitResult) {
        Item item = stack.m_41720_();
        return hitResult.m_6662_() != HitResult.Type.BLOCK && item instanceof IItemUsable && player.m_36335_().m_41519_(item);
    }

    public static boolean playerPose(Player player) {
        if (Platform.INSTANCE.getEntityData((LivingEntity)player).map(EntityData::isSleeping).orElse(false).booleanValue()) {
            if (player.m_20089_() != Pose.SLEEPING) {
                player.m_20124_(Pose.SLEEPING);
            }
            return true;
        }
        Pose pose = Platform.INSTANCE.getPlayerData(player).map(d -> d.getWeaponHandler().getCurrentAction().getPose((LivingEntity)player, d.getWeaponHandler())).orElse(null);
        if (pose != null) {
            if (player.m_20089_() != pose) {
                player.m_20124_(pose);
            }
            return true;
        }
        return false;
    }

    public static void onPlayerThrowItem(Player player, ItemEntity entity) {
        if (!player.m_21224_()) {
            entity.m_32052_(player.m_142081_());
            PrevEntityPosition pos = (PrevEntityPosition)player;
            double dX = player.m_20185_() - pos.runecraftory$getOldPlayerX();
            double dZ = player.m_20189_() - pos.runecraftory$getOldPlayerZ();
            double spd = dX * dX + dZ * dZ;
            if (spd > 0.01) {
                double scale = ArmorEffect.hasArmorEffect((LivingEntity)player, (ArmorEffect)((Object)ModArmorEffects.THROWING_RING.get())) ? 2.5 : 1.7;
                entity.m_20256_(entity.m_20184_().m_82490_(scale));
            }
        }
    }

    public static boolean handleEntityCollision(ItemEntity entity) {
        if (entity.m_20069_() || entity.m_20077_() || entity.m_32057_() == null || entity.f_19853_.f_46443_) {
            return true;
        }
        HitResult hitResult = ProjectileUtil.m_37294_((Entity)entity, t -> MixinUtils.canHitEntity(entity, t));
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            return true;
        }
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult result = (EntityHitResult)hitResult;
            Entity entity2 = result.m_82443_();
            if (entity2 instanceof IBaseMob) {
                Player thrower;
                IBaseMob mob = (IBaseMob)entity2;
                ItemStack stack = entity.m_32055_();
                Entity e = ((ServerLevel)entity.f_19853_).m_8791_(entity.m_32057_());
                if (e instanceof Player && mob.onGivingItem(thrower = (Player)e, stack) && stack.m_41619_()) {
                    entity.m_146870_();
                }
            }
            return true;
        }
        return false;
    }

    protected static boolean canHitEntity(ItemEntity entity, Entity target) {
        if (target.m_5833_() || !target.m_6084_() || !target.m_6087_()) {
            return false;
        }
        return !target.m_142081_().equals(entity.m_32057_());
    }

    public static void onBlockStateChange(ServerLevel level, BlockPos pos, BlockState blockState, BlockState newState) {
        if (FarmlandHandler.isFarmBlock(newState)) {
            if (!FarmlandHandler.isFarmBlock(blockState) || FarmlandHandler.get(level.m_142572_()).getData(level, pos).isEmpty()) {
                FarmlandHandler.get(level.m_142572_()).onFarmlandPlace(level, pos);
            }
        } else if (FarmlandHandler.isFarmBlock(blockState)) {
            FarmlandHandler.get(level.m_142572_()).onFarmlandRemove(level, pos);
        } else {
            Block block = blockState.m_60734_();
            if (block instanceof CropBlock) {
                CropBlock pre = (CropBlock)block;
                Block block2 = newState.m_60734_();
                if (!(block2 instanceof CropBlock)) {
                    FarmlandHandler.get(level.m_142572_()).getData(level, pos.m_7495_()).ifPresent(d -> d.onCropRemove(level, pos, newState));
                } else {
                    CropBlock post = (CropBlock)block2;
                    if ((Integer)blockState.m_61143_((Property)pre.m_7959_()) > (Integer)newState.m_61143_((Property)post.m_7959_())) {
                        FarmlandHandler.get(level.m_142572_()).getData(level, pos.m_7495_()).ifPresent(d -> d.onRegrowableHarvest(level, pos, newState));
                    }
                }
            }
        }
    }

    public static void recheckFarmland(ServerLevel level, BlockState state, BlockPos pos) {
        if (FarmlandHandler.get(level.m_142572_()).getData(level, pos).map(d -> !d.isFarmBlock()).orElse(true).booleanValue()) {
            FarmlandHandler.get(level.m_142572_()).onFarmlandPlace(level, pos);
        }
    }

    public static void triggerArmorStepEffect(LivingEntity living) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (stack = living.m_6844_(slot)).m_41619_()) continue;
            Platform.INSTANCE.getArmorEffects(stack).ifPresent(d -> d.triggerEvent(stack, e -> e.onStep(living, stack)));
        }
    }
}

