/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.platform;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.attachment.ArmorEffectData;
import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.attachment.StaffData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.items.equipment.ItemArmorBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.network.Packet;
import io.github.flemmli97.tenshilib.platform.InitUtil;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import org.apache.commons.lang3.function.TriFunction;

public interface Platform {
    public static final Platform INSTANCE = (Platform)InitUtil.getPlatformInstance(Platform.class, (String[])new String[]{"io.github.flemmli97.runecraftory.fabric.platform.PlatformImpl", "io.github.flemmli97.runecraftory.forge.platform.PlatformImpl"});

    public boolean isDatagen();

    public Optional<PlayerData> getPlayerData(Player var1);

    public Optional<EntityData> getEntityData(LivingEntity var1);

    public Optional<StaffData> getStaffData(Object var1);

    public Optional<ArmorEffectData> getArmorEffects(Object var1);

    public void openGuiMenu(ServerPlayer var1, MenuProvider var2);

    public void openGuiMenu(ServerPlayer var1, MenuProvider var2, BlockPos var3);

    public void openGuiMenu(ServerPlayer var1, MenuProvider var2, Consumer<FriendlyByteBuf> var3);

    public void sendToClient(Packet var1, ServerPlayer var2);

    public void sendToServer(Packet var1);

    public void sendToAll(Packet var1, MinecraftServer var2);

    public void sendToTrackingAndSelf(Packet var1, Entity var2);

    public void sendToTracking(Packet var1, ServerLevel var2, ChunkPos var3);

    public boolean isShield(ItemStack var1, Player var2);

    public boolean canEquip(ItemStack var1, EquipmentSlot var2, LivingEntity var3);

    public ItemStaffBase staff(EnumElement var1, int var2, Item.Properties var3);

    public ItemArmorBase armor(EquipmentSlot var1, Item.Properties var2, ResourceLocation var3, boolean var4);

    public SoundType getSoundType(BlockState var1, Level var2, BlockPos var3, Entity var4);

    public DamageSource createDamageSource(String var1, boolean var2, boolean var3, boolean var4);

    public SimpleParticleType simple(boolean var1);

    public <T extends BlockEntity> BlockEntityType<T> blockEntityType(BiFunction<BlockPos, BlockState, T> var1, Block ... var2);

    public <T extends BlockEntity> BlockEntityType<T> blockEntityType(BiFunction<BlockPos, BlockState, T> var1, Set<Block> var2);

    public <T extends AbstractContainerMenu> MenuType<T> menuType(BiFunction<Integer, Inventory, T> var1);

    public <T extends AbstractContainerMenu> MenuType<T> menuType(TriFunction<Integer, Inventory, FriendlyByteBuf, T> var1);

    public Activity activity(String var1);

    public CreativeModeTab tab(String var1, Supplier<ItemStack> var2);

    public boolean matchingInventory(BlockEntity var1, Predicate<ItemStack> var2);

    public ItemStack findMatchingItem(BlockEntity var1, Predicate<ItemStack> var2, int var3);

    public ItemStack insertInto(BlockEntity var1, ItemStack var2);

    public void cropGrowEvent(Level var1, BlockPos var2, BlockState var3);

    public void craftingEvent(Player var1, ItemStack var2, Container var3);

    public void destroyItem(Player var1, ItemStack var2, InteractionHand var3);

    public boolean onLivingUpdate(LivingEntity var1);

    public boolean canEntitySpawnSpawner(Mob var1, LevelAccessor var2, double var3, double var5, double var7, BaseSpawner var9, MobSpawnType var10);

    public float onLivingHurt(LivingEntity var1, DamageSource var2, float var3);

    public int getLootingFromCtx(LootContext var1);

    public int getLootingFromEntity(Entity var1, Entity var2, DamageSource var3);

    public Supplier<Item> registerRecord(int var1, RegistryEntrySupplier<SoundEvent> var2, Item.Properties var3);
}

