/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.platform;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SaveItemContainer
implements Container,
StackedContentsCompatible {
    protected final NonNullList<ItemStack> stacks;
    private final BlockEntity blockEntity;

    public SaveItemContainer(int size) {
        this(null, size);
    }

    public SaveItemContainer(BlockEntity blockEntity, int size) {
        this.stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        this.blockEntity = blockEntity;
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        this.validateSlotIndex(index);
        return (ItemStack)this.stacks.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        this.validateSlotIndex(index);
        ItemStack stack = (ItemStack)this.stacks.get(index);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        return stack.m_41620_(count);
    }

    public ItemStack m_8016_(int index) {
        this.validateSlotIndex(index);
        ItemStack stack = (ItemStack)this.stacks.get(index);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.stacks.set(index, (Object)ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.validateSlotIndex(index);
        if (!stack.m_41619_() && !this.m_7013_(index, stack)) {
            return;
        }
        int max = this.getMaxStackSize(index);
        if (stack.m_41613_() < max) {
            this.stacks.set(index, (Object)stack);
        } else {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(max);
            this.stacks.set(index, (Object)copy);
            stack.m_41774_(max);
        }
        this.m_6596_();
    }

    public void m_6596_() {
        if (this.blockEntity != null && !this.blockEntity.m_58901_()) {
            this.blockEntity.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.stacks.clear();
        this.m_6596_();
    }

    public void m_5809_(StackedContents helper) {
        for (ItemStack stack : this.stacks) {
            helper.m_36466_(stack);
        }
    }

    protected void validateSlotIndex(int index) {
        if (index < 0 || index >= this.stacks.size()) {
            throw new RuntimeException("Slot " + index + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    public int getMaxStackSize(int index) {
        return 64;
    }

    public void load(CompoundTag compound) {
        ContainerHelper.m_18980_((CompoundTag)compound, this.stacks);
    }

    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)compound, this.stacks);
        return compound;
    }
}

