/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.api.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.flemmli97.tenshilib.api.config.SimpleItemStackWrapper;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ItemTagWrapper
extends SimpleItemStackWrapper {
    private List<Item> list = new ArrayList<Item>();
    private TagKey<Item> tag;

    public ItemTagWrapper(String item, int count) {
        super(item, count);
    }

    public ItemTagWrapper(TagKey<Item> tag) {
        this(tag, 1);
    }

    public ItemTagWrapper(TagKey<Item> tag, int count) {
        super("", count);
        this.tag = tag;
    }

    @Override
    public Item getItem() {
        if (this.item == null) {
            if (!this.reg.isEmpty()) {
                return super.getItem();
            }
            if (this.tag == null) {
                this.item = Items.f_41852_;
                return this.item;
            }
            Optional t = Registry.f_122827_.m_203431_(this.tag);
            t.ifPresent(set -> set.forEach(holder -> this.list.add((Item)holder.m_203334_())));
            this.item = !this.list.isEmpty() ? this.list.get(0) : Items.f_41852_;
        }
        return this.item;
    }

    @Override
    public List<Item> getItemList() {
        this.getItem();
        return this.list;
    }

    @Override
    public boolean hasList() {
        return true;
    }

    @Override
    public boolean match(ItemStack stack) {
        if (this.tag == null) {
            return super.match(stack);
        }
        return stack.m_204117_(this.tag);
    }

    @Override
    public ItemTagWrapper readFromString(String s) {
        String[] parts = s.split(",");
        if (parts[0].startsWith("#")) {
            this.tag = PlatformUtils.INSTANCE.itemTag(new ResourceLocation(parts[0].substring(1)));
        } else {
            this.reg = parts[0];
        }
        this.count = parts.length < 2 ? 1 : Integer.parseInt(parts[1]);
        return this;
    }

    @Override
    public String writeToString() {
        if (this.tag != null) {
            return "#" + String.valueOf(this.tag.f_203868_()) + (String)(this.count != 1 ? "," + this.count : "");
        }
        return super.writeToString();
    }

    public static String usage() {
        return "Usage: <#item-tag|item>,<amount>";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ItemTagWrapper) {
            ItemTagWrapper prop = (ItemTagWrapper)obj;
            return prop.writeToString().equals(this.toString());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.writeToString().hashCode();
    }

    public static class Serializer
    implements JsonDeserializer<ItemTagWrapper>,
    JsonSerializer<ItemTagWrapper> {
        public JsonElement serialize(ItemTagWrapper src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            if (src.tag != null) {
                obj.add("tag", (JsonElement)new JsonPrimitive(src.tag.f_203868_().toString()));
            } else {
                obj.add("item", (JsonElement)new JsonPrimitive(src.reg));
            }
            if (src.count != 1) {
                obj.add("count", (JsonElement)new JsonPrimitive((Number)src.count));
            }
            return obj;
        }

        public ItemTagWrapper deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int count = GsonHelper.m_13824_((JsonObject)obj, (String)"count", (int)1);
            if (obj.has("tag")) {
                return new ItemTagWrapper(PlatformUtils.INSTANCE.itemTag(new ResourceLocation(obj.get("tag").getAsString())), count);
            }
            return new ItemTagWrapper(obj.get("item").getAsString(), count);
        }
    }
}

