/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.client.gui.widget.SuggestionEditBox;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.common.network.C2SAnimationDebuggerUpdate;
import io.github.flemmli97.tenshilib.common.network.NetworkCrossPlat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;

public class AnimationScreen<T extends LivingEntity>
extends Screen {
    protected final T entity;
    private final InteractionHand hand;
    private final String[] animations;
    private int leftPos;
    private int topPos;
    private final int sizeX = 240;
    private final int sizeY = 160;
    private SuggestionEditBox box;
    private int index;

    public AnimationScreen(T entity, InteractionHand hand, int index) {
        super((Component)new TranslatableComponent("tenshilib.gui.animation"));
        this.entity = entity;
        this.animations = (String[])Arrays.stream(((IAnimated)entity).getAnimationHandler().getAnimations()).map(AnimatedAction::getID).toArray(String[]::new);
        this.hand = hand;
        this.index = Mth.m_14045_((int)index, (int)0, (int)(this.animations.length - 1));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
        this.leftPos = this.f_96543_ / 2 - this.sizeX / 2;
        this.topPos = this.f_96544_ / 2 - this.sizeY / 2;
        this.buttons();
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTick) {
        this.m_93179_(stack, this.leftPos, this.topPos, this.leftPos + this.sizeX, this.topPos + this.sizeY, -1072689136, -1072689136);
        int padding = 16;
        RenderUtils.renderScaledEntityGui(this.leftPos + this.sizeX - padding - 96, this.topPos + padding, 32, 3.0f, 3.0f, mouseX, mouseY, this.entity);
        this.f_96541_.f_91062_.m_92889_(stack, this.m_96636_(), (float)(this.leftPos + 16), (float)(this.topPos + 16), 0xFFFFFF);
        super.m_6305_(stack, mouseX, mouseY, partialTick);
    }

    protected void buttons() {
        int padding = 16;
        int yOff = padding + 12 + 80;
        this.box = new SuggestionEditBox(this.f_96541_.f_91062_, this.leftPos + this.sizeX / 2 - 70, this.topPos + yOff, 140, 20, (Component)new TranslatableComponent("fateubw.gui.animation"), 5, true, SuggestionEditBox.ofString(List.of(this.animations)));
        this.box.m_94144_(this.index >= 0 ? this.animations[this.index] : "");
        this.box.m_94151_(s -> {
            s = s.trim();
            this.box.m_94202_(0xFF0000);
            for (int i = 0; i < this.animations.length; ++i) {
                String str = this.animations[i];
                if (!s.equals(str)) continue;
                this.box.m_94202_(0xE0E0E0);
                this.index = i;
                break;
            }
        });
        this.m_142416_((GuiEventListener)new Button(this.leftPos + this.sizeX / 2 - 50, this.topPos + (yOff += 24), 100, 20, (Component)new TranslatableComponent("tenshilib.gui.save"), b -> {
            NetworkCrossPlat.INSTANCE.sendToServer(new C2SAnimationDebuggerUpdate(this.hand, this.index));
            this.f_96541_.m_91152_(null);
        }));
        this.m_142416_((GuiEventListener)this.box);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.box.m_94204_() && this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

