/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.gui.widget.list;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.tenshilib.client.gui.widget.TextureLocation;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableEntry;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableListWidget;
import java.util.function.BooleanSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;

public class SelectableText
implements SelectableEntry {
    private final Component text;
    private int paddingX = 4;
    private SelectButton[] button;
    private Pair<TextureLocation, TextureLocation> entryTexture;
    private boolean selectable = true;
    private FormattedCharSequence sequence;
    private FormattedCharSequence blankSequence;
    private int lastWidth;
    private int width;
    private int height;

    public SelectableText(String text, ChatFormatting ... chatFormattings) {
        this((Component)new TextComponent(text).m_130944_(chatFormattings));
    }

    public SelectableText(Component text) {
        this.text = text;
    }

    public SelectableText padding(int padding) {
        this.paddingX = padding;
        return this;
    }

    public SelectableText with(SelectButton ... clickHandler) {
        return this.with(false, clickHandler);
    }

    public SelectableText with(boolean canSelect, SelectButton ... clickHandler) {
        this.selectable = canSelect;
        this.button = clickHandler;
        return this;
    }

    public SelectableText withTexture(ResourceLocation background, Pair<TextureLocation, TextureLocation> entryTexture) {
        this.entryTexture = entryTexture;
        return this;
    }

    public SelectableText noSelect() {
        this.selectable = false;
        return this;
    }

    @Override
    public void updateDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void render(SelectableListWidget widget, PoseStack poseStack, int mouseX, int mouseY, float partialTick, int x, int y, boolean selected, boolean hovered) {
        if (this.entryTexture != null) {
            TextureLocation location = hovered ? (TextureLocation)this.entryTexture.getSecond() : (TextureLocation)this.entryTexture.getFirst();
            RenderSystem.m_157456_((int)0, (ResourceLocation)location.texture());
            widget.m_93228_(poseStack, x, y, location.uOffset(), location.vOffset(), this.width, this.height);
        } else if (selected || hovered) {
            GuiComponent.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + this.width), (int)(y + this.height), (int)-1609560048);
        }
        int textWidth = this.width - this.paddingX;
        if (this.getButtons() != null && this.getButtons().length > 0) {
            int skipped = 0;
            for (int idx = 0; idx < this.getButtons().length; ++idx) {
                SelectButton btn = this.getButtons()[this.getButtons().length - 1 - idx];
                if (!btn.shouldRender().getAsBoolean()) {
                    ++skipped;
                    continue;
                }
                int[] xY = this.getButtonStart(idx - skipped);
                int bX = xY[0] + x;
                int bY = xY[1] + y;
                textWidth = xY[0] - 2;
                RenderSystem.m_157456_((int)0, (ResourceLocation)btn.texture());
                boolean over = mouseX >= bX && mouseY >= bY && mouseX < bX + 12 && mouseY < bY + 12;
                widget.m_93228_(poseStack, bX, bY, btn.uOffset(), btn.vOffset() + (over ? 12 : 0), 12, 12);
            }
        }
        widget.getFont().m_92877_(poseStack, this.getText(widget.getFont(), textWidth - this.paddingX, selected || hovered), (float)(x + this.paddingX), (float)(y + (int)(0.5 * (double)this.height - 3.5)), selected ? ChatFormatting.LIGHT_PURPLE.m_126665_() : (hovered ? ChatFormatting.YELLOW.m_126665_() : 0xFFFFFF));
    }

    @Override
    public boolean onClick(double relativeMouseX, double relativeMouseY, boolean selected) {
        if (this.getButtons() != null && this.getButtons().length > 0) {
            int skipped = 0;
            for (int idx = 0; idx < this.getButtons().length; ++idx) {
                int[] xY;
                boolean over;
                SelectButton btn = this.getButtons()[this.getButtons().length - 1 - idx];
                if (!btn.shouldRender().getAsBoolean()) {
                    ++skipped;
                }
                boolean bl = over = relativeMouseX >= (double)(xY = this.getButtonStart(idx - skipped))[0] && relativeMouseY >= (double)xY[1] && relativeMouseX < (double)(xY[0] + 12) && relativeMouseY < (double)(xY[1] + 12);
                if (!over) continue;
                btn.onClick().run();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                return false;
            }
        }
        return this.selectable;
    }

    public FormattedCharSequence getText(Font font, int width, boolean highlight) {
        if (this.sequence == null || this.lastWidth != width) {
            this.sequence = SelectableEntry.dottedWith(font, this.text, width, false);
            this.blankSequence = SelectableEntry.dottedWith(font, this.text, width, true);
            this.lastWidth = width;
        }
        return highlight ? this.blankSequence : this.sequence;
    }

    public SelectButton[] getButtons() {
        return this.button;
    }

    private int[] getButtonStart(int position) {
        int btnX = this.width - this.paddingX - 12 - position * 14;
        int btnY = (int)(0.5 * (double)this.height) - 6;
        return new int[]{btnX, btnY};
    }

    public record SelectButton(ResourceLocation texture, int uOffset, int vOffset, Runnable onClick, BooleanSupplier shouldRender) {
        private static final BooleanSupplier ALWAYS = () -> true;

        public SelectButton(ResourceLocation texture, int uOffset, int vOffset, Runnable onClick) {
            this(texture, uOffset, vOffset, onClick, ALWAYS);
        }
    }
}

