/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import io.github.flemmli97.tenshilib.client.model.PoseExtended;
import io.github.flemmli97.tenshilib.mixin.ModelPartAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;

public class ModelPartHandler {
    private final ModelPartExtended mainPart;
    private final Map<String, ModelPartExtended> childrenToName = new HashMap<String, ModelPartExtended>();

    public ModelPartHandler(ModelPart main, String mainID) {
        this.mainPart = new ModelPartExtended(main);
        this.childrenToName.put(mainID, this.mainPart);
        this.mainPart.getMappedParts(this.childrenToName);
    }

    public ModelPartHandler(ModelPart root) {
        this.mainPart = new ModelPartExtended(root);
        this.childrenToName.put("root", this.mainPart);
        this.mainPart.getMappedParts(this.childrenToName);
    }

    public ModelPartExtended getPart(String name) {
        ModelPartExtended modelPart = this.childrenToName.get(name);
        if (modelPart == null) {
            throw new NoSuchElementException("Can't find part " + name);
        }
        return modelPart;
    }

    protected ModelPartExtended getPartNullable(String name) {
        return this.childrenToName.get(name);
    }

    public void resetPoses() {
        this.mainPart.resetAll();
    }

    public ModelPartExtended getMainPart() {
        return this.mainPart;
    }

    public static class ModelPartExtended {
        public float x;
        public float y;
        public float z;
        public float xRot;
        public float yRot;
        public float zRot;
        public float xScale = 1.0f;
        public float yScale = 1.0f;
        public float zScale = 1.0f;
        public boolean visible = true;
        private final List<ModelPart.Cube> cubes;
        private final Map<String, ModelPartExtended> children;
        private PoseExtended defaultPose;

        public ModelPartExtended(ModelPart orig) {
            this.cubes = ((ModelPartAccessor)orig).getCubes();
            this.children = ((ModelPartAccessor)orig).getChildren().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ModelPartExtended((ModelPart)e.getValue())));
            this.updateDefaultPose(new PoseExtended(orig.m_171308_()));
        }

        public PartPose storePose() {
            return PartPose.m_171423_((float)this.x, (float)this.y, (float)this.z, (float)this.xRot, (float)this.yRot, (float)this.zRot);
        }

        public void loadPose(PartPose partPose) {
            this.setPos(partPose.f_171405_, partPose.f_171406_, partPose.f_171407_);
            this.setRotation(partPose.f_171408_, partPose.f_171409_, partPose.f_171410_);
        }

        public void loadPose(PoseExtended pose) {
            this.setPos(pose.x, pose.y, pose.z);
            this.setRotation(pose.xRot, pose.yRot, pose.zRot);
            this.setScale(pose.xScale, pose.yScale, pose.zScale);
        }

        public void loadPoseRecursive(PoseExtended pose) {
            this.setPos(pose.x, pose.y, pose.z);
            this.setRotation(pose.xRot, pose.yRot, pose.zRot);
            this.setScale(pose.xScale, pose.yScale, pose.zScale);
            this.children.values().forEach(m -> m.loadPoseRecursive(pose));
        }

        public ModelPartExtended getChild(String string) {
            ModelPartExtended modelPart = this.children.get(string);
            if (modelPart == null) {
                throw new NoSuchElementException("Can't find part " + string);
            }
            return modelPart;
        }

        public void setPos(float f, float g, float h) {
            this.x = f;
            this.y = g;
            this.z = h;
        }

        public void setRotation(float f, float g, float h) {
            this.xRot = f;
            this.yRot = g;
            this.zRot = h;
        }

        public void setScale(float x, float y, float z) {
            this.xScale = x;
            this.yScale = y;
            this.zScale = z;
        }

        public void reset() {
            this.loadPose(this.getDefaultPose());
        }

        public void resetAll() {
            this.reset();
            this.children.values().forEach(ModelPartExtended::resetAll);
        }

        public void setAllVisible(boolean visible) {
            this.visible = visible;
            this.children.values().forEach(m -> m.setAllVisible(visible));
        }

        public void render(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j) {
            this.render(poseStack, vertexConsumer, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
        }

        public void render(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, float f, float g, float h, float k) {
            if (!(!this.visible || this.xScale == 0.0f || this.yScale == 0.0f || this.zScale == 0.0f || this.cubes.isEmpty() && this.children.isEmpty())) {
                poseStack.m_85836_();
                this.translateAndRotate(poseStack);
                this.compile(poseStack.m_85850_(), vertexConsumer, i, j, f, g, h, k);
                for (ModelPartExtended modelPart : this.children.values()) {
                    modelPart.render(poseStack, vertexConsumer, i, j, f, g, h, k);
                }
                poseStack.m_85849_();
            }
        }

        public void visit(PoseStack poseStack, ModelPart.Visitor visitor) {
            this.visit(poseStack, visitor, "");
        }

        private void visit(PoseStack poseStack, ModelPart.Visitor visitor, String string) {
            if (!this.cubes.isEmpty() || !this.children.isEmpty()) {
                poseStack.m_85836_();
                this.translateAndRotate(poseStack);
                PoseStack.Pose pose = poseStack.m_85850_();
                for (int i = 0; i < this.cubes.size(); ++i) {
                    visitor.m_171341_(pose, string, i, this.cubes.get(i));
                }
                String string2 = string + "/";
                this.children.forEach((string2x, modelPart) -> modelPart.visit(poseStack, visitor, string2 + string2x));
                poseStack.m_85849_();
            }
        }

        public void translateAndRotate(PoseStack poseStack) {
            poseStack.m_85837_((double)(this.x / 16.0f), (double)(this.y / 16.0f), (double)(this.z / 16.0f));
            if (this.zRot != 0.0f) {
                poseStack.m_85845_(Vector3f.f_122227_.m_122270_(this.zRot));
            }
            if (this.yRot != 0.0f) {
                poseStack.m_85845_(Vector3f.f_122225_.m_122270_(this.yRot));
            }
            if (this.xRot != 0.0f) {
                poseStack.m_85845_(Vector3f.f_122223_.m_122270_(this.xRot));
            }
            if (this.xScale != 1.0f || this.yScale != 1.0f || this.zScale != 1.0f) {
                poseStack.m_85841_(this.xScale, this.yScale, this.zScale);
            }
        }

        private void compile(PoseStack.Pose pose, VertexConsumer vertexConsumer, int i, int j, float f, float g, float h, float k) {
            for (ModelPart.Cube cube : this.cubes) {
                cube.m_171332_(pose, vertexConsumer, i, j, f, g, h, k);
            }
        }

        public ModelPart.Cube getRandomCube(Random random) {
            return this.cubes.get(random.nextInt(this.cubes.size()));
        }

        public boolean isEmpty() {
            return this.cubes.isEmpty();
        }

        public void getMappedParts(Map<String, ModelPartExtended> map) {
            this.children.forEach((key, value) -> {
                map.put((String)key, (ModelPartExtended)value);
                value.getMappedParts(map);
            });
        }

        public PoseExtended getDefaultPose() {
            return this.defaultPose;
        }

        public void updateDefaultPose(PoseExtended defaultPose) {
            this.defaultPose = defaultPose;
        }
    }
}

