/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity;

import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import io.github.flemmli97.tenshilib.platform.EventCalls;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class EntityProjectile
extends Projectile {
    protected static final EntityDataAccessor<Optional<UUID>> SHOOTER_UUID = SynchedEntityData.m_135353_(EntityProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private Entity shooter;
    protected boolean inGround;
    protected int ticksInGround;
    protected int livingTicks;
    public final List<UUID> attackedEntities = new ArrayList<UUID>();
    public final List<UUID> checkedEntities = new ArrayList<UUID>();
    protected BlockState groundState;
    protected BlockPos groundPos;

    public EntityProjectile(EntityType<? extends EntityProjectile> type, Level world) {
        super(type, world);
    }

    public EntityProjectile(EntityType<? extends EntityProjectile> type, Level world, double x, double y, double z) {
        this(type, world);
        this.m_6034_(x, y, z);
    }

    public EntityProjectile(EntityType<? extends EntityProjectile> type, Level world, LivingEntity shooter) {
        this(type, world, shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_() - 0.1, shooter.m_20189_());
        this.shooter = shooter;
        this.f_19804_.m_135381_(SHOOTER_UUID, Optional.of(shooter.m_142081_()));
        this.m_19915_(shooter.m_146908_(), shooter.m_146909_());
        this.onUpdateOwner();
    }

    public static double getGravityOffset(EntityProjectile projectile, Vec3 dir, Vec3 motion) {
        if (projectile.getGravityVelocity() == 0.0f) {
            return 0.0;
        }
        double gravityOffset = dir.m_82553_() / motion.m_82553_() * 0.5 * (double)projectile.getGravityVelocity();
        return gravityOffset * 0.99;
    }

    public boolean isPiercing() {
        return false;
    }

    public int maxPierceAmount() {
        return -1;
    }

    public float radius() {
        return 0.0f;
    }

    public int livingTicks() {
        return this.livingTicks;
    }

    public int livingTickMax() {
        return 6000;
    }

    public boolean canHitShooter() {
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SHOOTER_UUID, Optional.empty());
    }

    public boolean m_6783_(double distance) {
        double d0 = this.m_142469_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.m_14031_((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, velocity, inaccuracy);
        Vec3 throwerMotion = entityThrower.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(throwerMotion.f_82479_, entityThrower.m_20096_() ? 0.0 : throwerMotion.f_82480_, throwerMotion.f_82481_));
        this.m_20184_().m_82520_(throwerMotion.f_82479_, 0.0, throwerMotion.f_82481_);
    }

    public void shootAtEntity(Entity target, float velocity, float inaccuracy) {
        this.shootAtEntity(target, velocity, inaccuracy, false);
    }

    public void shootAtEntity(Entity target, float velocity, float inaccuracy, boolean ignoreGravity) {
        Vec3 targetPos = EntityUtil.getStraightProjectileTarget(this.m_20182_(), target);
        this.shootAtPosition(targetPos.m_7096_(), targetPos.m_7098_(), targetPos.m_7094_(), velocity, inaccuracy, ignoreGravity);
    }

    public void shootAtPosition(double x, double y, double z, float velocity, float inaccuracy) {
        this.shootAtPosition(x, y, z, velocity, inaccuracy, false);
    }

    public void shootAtPosition(double x, double y, double z, float velocity, float inaccuracy, boolean ignoreGravity) {
        Vec3 dir = new Vec3(x - this.m_20185_(), y - this.m_20186_(), z - this.m_20189_());
        if (this.getGravityVelocity() == 0.0f || ignoreGravity) {
            this.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, velocity, inaccuracy);
        } else {
            Vec3 motion = dir.m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
            motion = motion.m_82520_(0.0, EntityProjectile.getGravityOffset(this, dir, motion), 0.0);
            this.setMotionWithRotation(motion);
        }
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 motion = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        this.setMotionWithRotation(motion);
    }

    private void setMotionWithRotation(Vec3 motion) {
        this.m_20256_(motion);
        double f = Math.sqrt(EntityProjectile.horizontalMag(motion));
        this.m_146922_((float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)motion.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        this.ticksInGround = 0;
    }

    public void m_6001_(double x, double y, double z) {
        this.m_20334_(x, y, z);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double f = Math.sqrt(x * x + z * z);
            this.m_146926_((float)(Mth.m_14136_((double)y, (double)f) * 57.2957763671875));
            this.m_146922_((float)(Mth.m_14136_((double)x, (double)z) * 57.2957763671875));
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
            this.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
        }
    }

    public void setInGround(BlockPos pos) {
        BlockState state = this.f_19853_.m_8055_(pos);
        if (!state.m_60767_().m_76333_()) {
            this.inGround = false;
            this.groundPos = null;
            this.groundState = null;
            return;
        }
        this.inGround = true;
        this.groundPos = pos;
        this.groundState = state;
    }

    public void m_8119_() {
        BlockState groundState;
        super.m_8119_();
        ++this.livingTicks;
        if (!this.f_19853_.f_46443_ && this.livingTicks > this.livingTickMax()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return;
        }
        Vec3 motion = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double f = Math.sqrt(EntityProjectile.horizontalMag(motion));
            this.m_146926_((float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.2957763671875));
            this.m_146922_((float)(Mth.m_14136_((double)motion.f_82480_, (double)f) * 57.2957763671875));
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
        }
        BlockState blockState = groundState = this.groundPos != null ? this.f_19853_.m_8055_(this.groundPos) : null;
        if (this.inGround) {
            if (groundState != this.groundState && this.noGround()) {
                this.resetInGround();
            }
            this.tickInGround();
            return;
        }
        if (!this.f_19853_.f_46443_) {
            this.doCollision();
        }
        this.moveEntity();
    }

    protected void tickInGround() {
        ++this.ticksInGround;
        if (!this.f_19853_.f_46443_ && this.ticksInGround == 1200) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void moveEntity() {
        Vec3 motion = this.m_20184_();
        double newX = this.m_20185_() + motion.f_82479_;
        double newY = this.m_20186_() + motion.f_82480_;
        double newZ = this.m_20189_() + motion.f_82481_;
        double f = Math.sqrt(EntityProjectile.horizontalMag(motion));
        this.m_146922_(this.updateRotation(this.f_19859_, (float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.29577951308232)));
        this.m_146926_(this.updateRotation(this.f_19860_, (float)(Mth.m_14136_((double)motion.f_82480_, (double)f) * 57.2957763671875)));
        boolean water = this.m_20069_();
        if (water) {
            for (int i = 0; i < 4; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() * 0.25, this.m_20186_() * 0.25, this.m_20189_() * 0.25, motion.f_82479_, motion.f_82480_, motion.f_82481_);
            }
        }
        float friction = this.motionReduction(water);
        this.m_20256_(motion.m_82490_((double)friction));
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82492_(0.0, (double)this.getGravityVelocity(), 0.0));
        }
        this.m_6034_(newX, newY, newZ);
    }

    public static double horizontalMag(Vec3 vec) {
        return vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_;
    }

    private float updateRotation(float prev, float current) {
        while (current - prev < -180.0f) {
            prev -= 360.0f;
        }
        while (current - prev >= 180.0f) {
            prev += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)prev, (float)current);
    }

    protected void doCollision() {
        block5: {
            EntityHitResult res;
            Vec3 to;
            Vec3 pos;
            block3: {
                BlockHitResult raytraceresult;
                block6: {
                    BlockState blockstate;
                    BlockPos blockpos;
                    block4: {
                        pos = this.m_20182_();
                        raytraceresult = this.f_19853_.m_45547_(new ClipContext(pos, to = pos.m_82549_(this.m_20184_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
                            to = raytraceresult.m_82450_();
                        }
                        if (raytraceresult.m_6662_() != HitResult.Type.BLOCK) break block3;
                        blockpos = raytraceresult.m_82425_();
                        blockstate = this.f_19853_.m_8055_(blockpos);
                        if (!blockstate.m_60713_(Blocks.f_50142_)) break block4;
                        this.m_20221_(blockpos);
                        break block5;
                    }
                    if (!blockstate.m_60713_(Blocks.f_50446_)) break block6;
                    BlockEntity tileentity = this.f_19853_.m_7702_(blockpos);
                    if (tileentity instanceof TheEndGatewayBlockEntity && TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                        TheEndGatewayBlockEntity.m_155828_((Level)this.f_19853_, (BlockPos)blockpos, (BlockState)blockstate, (Entity)this, (TheEndGatewayBlockEntity)((TheEndGatewayBlockEntity)tileentity));
                    }
                    break block5;
                }
                if (EventCalls.INSTANCE.projectileHitCall(this, (HitResult)raytraceresult)) break block5;
                this.onBlockHit(raytraceresult);
                break block5;
            }
            while ((res = this.getEntityHit(pos, to)) != null && this.m_6084_()) {
                this.checkedEntities.add(res.m_82443_().m_142081_());
                if (EventCalls.INSTANCE.projectileHitCall(this, (HitResult)res) || this.attackedEntities.contains(res.m_82443_().m_142081_()) || !this.entityRayTraceHit(res)) continue;
                this.attackedEntities.add(res.m_82443_().m_142081_());
                if (this.maxPierceAmount() == -1 || this.attackedEntities.size() <= this.maxPierceAmount()) continue;
                this.onReachMaxPierce();
            }
        }
    }

    protected boolean noGround() {
        return this.inGround && this.f_19853_.m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
    }

    protected void resetInGround() {
        this.inGround = false;
        this.groundPos = null;
        this.groundState = null;
        this.m_20256_(this.m_20184_().m_82542_((double)(this.f_19796_.nextFloat() * 0.2f), (double)(this.f_19796_.nextFloat() * 0.2f), (double)(this.f_19796_.nextFloat() * 0.2f)));
        this.ticksInGround = 0;
    }

    public void m_6478_(MoverType type, Vec3 to) {
        super.m_6478_(type, to);
        if (type != MoverType.SELF && this.noGround()) {
            this.resetInGround();
        }
    }

    protected boolean canHit(Entity target) {
        if (target.m_5833_() || !target.m_6084_() || !target.m_6087_()) {
            return false;
        }
        Entity entity = this.m_37282_();
        if (entity == null) {
            return true;
        }
        if (entity.m_20365_(target) || EntityUtil.isSameMultipart(target, this.m_37282_())) {
            return false;
        }
        if (target.equals((Object)this.m_37282_()) && (!this.canHitShooter() || this.f_19797_ < 5)) {
            return false;
        }
        return !this.checkedEntities.contains(target.m_142081_());
    }

    protected EntityHitResult getEntityHit(Vec3 from, Vec3 to) {
        if (!this.m_6084_()) {
            return null;
        }
        double amount = 1.0;
        if (this.isPiercing()) {
            amount = this.maxPierceAmount();
        }
        if (amount == -1.0 || (double)this.attackedEntities.size() < amount) {
            if (this.radius() != 0.0f) {
                double dist = to.m_82546_(from).m_82553_();
                OrientedBoundingBox obb = new OrientedBoundingBox(OrientedBoundingBox.baseBox(this.radius() * 2.0f, this.radius() * 2.0f, dist), -this.m_146908_(), this.m_146909_(), this.m_20182_());
                List list = this.f_19853_.m_45933_((Entity)this, obb.getEncompassingBox());
                for (Entity e : list) {
                    if (!this.canHit(e) || !obb.intersects(e.m_142469_())) continue;
                    AABB outer = obb.getEncompassingBox();
                    Vec3 hit = new Vec3(Mth.m_14008_((double)e.m_20182_().f_82479_, (double)outer.f_82288_, (double)outer.f_82291_), Mth.m_14008_((double)e.m_20182_().f_82480_, (double)outer.f_82289_, (double)outer.f_82292_), Mth.m_14008_((double)e.m_20182_().f_82481_, (double)outer.f_82290_, (double)outer.f_82293_));
                    return new EntityHitResult(e, hit);
                }
                return null;
            }
            return RayTraceUtils.rayTraceEntities((Entity)this, from, to, this::canHit);
        }
        return null;
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    protected float motionReduction(boolean inWater) {
        return inWater ? 0.8f : 0.99f;
    }

    protected abstract boolean entityRayTraceHit(EntityHitResult var1);

    protected abstract void onBlockHit(BlockHitResult var1);

    protected void onReachMaxPierce() {
    }

    protected void m_7378_(CompoundTag compound) {
        this.inGround = compound.m_128471_("InGround");
        if (compound.m_128441_("GroundPos")) {
            this.setInGround(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("GroundPos")));
        }
        if (compound.m_128403_("Shooter")) {
            this.f_19804_.m_135381_(SHOOTER_UUID, Optional.of(compound.m_128342_("Shooter")));
        }
        this.shooter = this.m_37282_();
        this.livingTicks = compound.m_128451_("LivingTicks");
        ListTag list = compound.m_128437_("AttackedEntities", 8);
        list.forEach(tag -> this.attackedEntities.add(UUID.fromString(tag.m_7916_())));
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.groundPos != null) {
            compound.m_128365_("GroundPos", (Tag)NbtUtils.m_129224_((BlockPos)this.groundPos));
        }
        compound.m_128379_("InGround", this.inGround);
        ((Optional)this.f_19804_.m_135370_(SHOOTER_UUID)).ifPresent(uuid -> compound.m_128362_("Shooter", uuid));
        compound.m_128405_("LivingTicks", this.livingTicks);
        ListTag list = new ListTag();
        this.attackedEntities.forEach(uuid -> list.add((Object)StringTag.m_129297_((String)uuid.toString())));
        compound.m_128365_("AttackedEntities", (Tag)list);
    }

    @Nullable
    public Entity m_37282_() {
        if (this.shooter != null && !this.shooter.m_146910_()) {
            return this.shooter;
        }
        ((Optional)this.f_19804_.m_135370_(SHOOTER_UUID)).ifPresent(uuid -> {
            this.shooter = EntityUtil.findFromUUID(Entity.class, this.f_19853_, uuid);
            this.onUpdateOwner();
        });
        return this.shooter;
    }

    public void onUpdateOwner() {
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(SHOOTER_UUID)).orElse(null);
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected final void m_5790_(EntityHitResult result) {
        this.entityRayTraceHit(result);
    }

    protected final void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.onBlockHit(result);
    }

    public final void m_5602_(@Nullable Entity entity) {
        if (entity == null) {
            this.shooter = null;
            this.f_19804_.m_135381_(SHOOTER_UUID, Optional.empty());
        } else {
            this.shooter = entity;
            this.f_19804_.m_135381_(SHOOTER_UUID, Optional.of(entity.m_142081_()));
        }
        this.onUpdateOwner();
    }
}

