/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.animated.impl;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;

public class JumpEvadeAction<T extends PathfinderMob>
implements ActionRun<T> {
    private final double minDistSqr;
    private final double power;
    private final double powerSide;
    private final float chance;
    private final float sideChance;
    private final ActionRun<T> other;
    private boolean start;

    public JumpEvadeAction(double minDist, double power, double powerSide, float chance, float sideChance, ActionRun<T> other) {
        this.minDistSqr = minDist * minDist;
        this.power = power;
        this.powerSide = powerSide;
        this.chance = chance;
        this.sideChance = sideChance;
        this.other = other;
    }

    @Override
    public boolean run(AnimatedAttackGoal<T> goal, LivingEntity target, AnimatedAction anim) {
        if (!this.start || goal.attacker.m_21187_().nextFloat() < this.chance) {
            this.start = true;
            if (goal.distanceToTargetSq < this.minDistSqr) {
                Vec3 dir = target.m_20182_().m_82546_(goal.attacker.m_20182_());
                dir = new Vec3(dir.m_7096_(), 0.0, dir.m_7094_()).m_82541_().m_82490_(this.power);
                goal.attacker.m_20334_(-dir.m_7096_(), 0.2, -dir.m_7094_());
            } else if (goal.attacker.m_21187_().nextFloat() < this.sideChance) {
                Vec3 dir = target.m_20182_().m_82546_(goal.attacker.m_20182_());
                dir = new Vec3(dir.m_7096_(), 0.0, dir.m_7094_()).m_82541_().m_82490_(this.powerSide);
                dir = MathUtils.rotate(new Vec3(0.0, 1.0, 0.0), dir, goal.attacker.m_21187_().nextBoolean() ? 90.0f : -90.0f);
                goal.attacker.m_20334_(-dir.m_7096_(), 0.2, -dir.m_7094_());
            }
        }
        return this.other.run(goal, target, anim);
    }
}

