/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.animated.impl;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.ActionUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class MoveAwayRunner<T extends PathfinderMob>
implements ActionRun<T> {
    private final double minDistSqr;
    private final double speed;
    private final int dist;
    private final boolean needsLoS;
    private boolean start;
    private ActionUtils.PathDistance pathDist;

    public MoveAwayRunner(double minDist, double speed, int dist) {
        this(minDist, speed, dist, false);
    }

    public MoveAwayRunner(double minDist, double speed, int dist, boolean needsLoS) {
        this.minDistSqr = minDist * minDist;
        this.speed = speed;
        this.dist = dist;
        this.needsLoS = needsLoS;
    }

    @Override
    public boolean run(AnimatedAttackGoal<T> goal, LivingEntity target, AnimatedAction anim) {
        boolean done;
        if (!this.start) {
            this.start = true;
            if (goal.distanceToTargetSq < this.minDistSqr) {
                for (int i = 0; i < 10; ++i) {
                    Vec3 posAway = DefaultRandomPos.m_148407_(goal.attacker, (int)this.dist, (int)4, (Vec3)target.m_20182_());
                    if (posAway == null) continue;
                    goal.moveToTargetPosition(posAway.m_7096_(), posAway.m_7098_(), posAway.m_7094_(), this.speed);
                    break;
                }
            }
        }
        if (((PathfinderMob)goal.attacker).f_19797_ % 3 == 0) {
            ActionUtils.PathDistance lastCheck = this.pathDist;
            this.pathDist = ActionUtils.distanceToNavTargetSqr(goal.attacker);
            if (lastCheck != null && this.pathDist != null && lastCheck.index() == this.pathDist.index() && lastCheck.dist() + 2.0 <= this.pathDist.dist()) {
                this.start = false;
                return false;
            }
        }
        if ((done = goal.attacker.m_21573_().m_26571_()) && !this.canSee(goal)) {
            this.start = false;
            return false;
        }
        return done;
    }

    private boolean canSee(AnimatedAttackGoal<T> goal) {
        return !this.needsLoS || goal.canSee;
    }
}

