/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.animated.impl;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;

public class MoveToTargetRunner<T extends PathfinderMob>
implements ActionRun<T> {
    private final double speed;
    private final double distance;
    private final boolean accountWidth;
    private final boolean requireSight;
    private final boolean stopOnReach;

    public MoveToTargetRunner(double speed, double distance) {
        this(speed, distance, true, false, true);
    }

    public MoveToTargetRunner(double speed, double distance, boolean accountWidth, boolean requireSight, boolean stopOnReach) {
        this.speed = speed;
        this.distance = distance;
        this.accountWidth = accountWidth;
        this.requireSight = requireSight;
        this.stopOnReach = stopOnReach;
    }

    @Override
    public boolean run(AnimatedAttackGoal<T> goal, LivingEntity target, AnimatedAction anim) {
        double dist = this.accountWidth ? (double)goal.attacker.m_20205_() * 0.5 + (double)target.m_20205_() * 0.5 : 0.0;
        double distSq = (dist += this.distance) * dist;
        goal.attacker.m_21391_((Entity)target, 30.0f, 30.0f);
        if (goal.distanceToTargetSq < distSq && (!this.requireSight || goal.canSee)) {
            goal.attacker.m_21563_().m_24960_((Entity)target, 360.0f, 90.0f);
            if (this.stopOnReach) {
                goal.attacker.m_21573_().m_26573_();
            }
            return true;
        }
        goal.moveToTarget(this.speed);
        return false;
    }
}

