/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.animated.impl;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.ActionUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class RandomMoveAroundRunner<T extends PathfinderMob>
implements ActionRun<T> {
    private final double maxDistSqr;
    private final int distance;
    private final boolean needsLoS;
    private boolean start;
    private ActionUtils.PathDistance pathDist;

    public RandomMoveAroundRunner(double maxDist, int distance) {
        this(maxDist, distance, true);
    }

    public RandomMoveAroundRunner(double maxDist, int distance, boolean needsLoS) {
        this.maxDistSqr = maxDist * maxDist;
        this.distance = distance;
        this.needsLoS = needsLoS;
    }

    @Override
    public boolean run(AnimatedAttackGoal<T> goal, LivingEntity target, AnimatedAction anim) {
        boolean done;
        if (!this.start) {
            this.start = true;
            goal.attacker.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (goal.distanceToTargetSq <= this.maxDistSqr) {
                if (goal.attacker.m_21573_().m_26571_()) {
                    for (int i = 0; i < 10; ++i) {
                        Path path;
                        Vec3 rand = DefaultRandomPos.m_148403_(goal.attacker, (int)this.distance, (int)4);
                        if (rand == null || !(rand.m_82557_(target.m_20182_()) < this.maxDistSqr) || (path = goal.attacker.m_21573_().m_26524_(rand.f_82479_, rand.f_82480_, rand.f_82481_, 0)) == null) continue;
                        goal.attacker.m_21573_().m_26536_(path, 1.0);
                        break;
                    }
                }
            } else {
                goal.moveToTarget(1.0);
            }
        }
        if (((PathfinderMob)goal.attacker).f_19797_ % 3 == 0) {
            ActionUtils.PathDistance lastCheck = this.pathDist;
            this.pathDist = ActionUtils.distanceToNavTargetSqr(goal.attacker);
            if (lastCheck != null && this.pathDist != null && lastCheck.index() == this.pathDist.index() && lastCheck.dist() + 2.0 <= this.pathDist.dist()) {
                this.start = false;
                return false;
            }
        }
        if ((done = goal.attacker.m_21573_().m_26571_()) && !this.canSee(goal)) {
            this.start = false;
            return false;
        }
        return done;
    }

    private boolean canSee(AnimatedAttackGoal<T> goal) {
        return !this.needsLoS || goal.canSee;
    }
}

