/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.animated.impl;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;

public class StrafingRunner<T extends PathfinderMob>
implements ActionRun<T> {
    private final float radiusSq;
    private final float minRadiusSq;
    private final float speed;
    private final float directionSwitchChance;
    private boolean start;
    private boolean clockWise;
    private int strafingTime;
    private int seeTime = 10;
    private boolean strafingBackwards;

    public StrafingRunner(float radius, float speed) {
        this(radius, speed, 0.3f);
    }

    public StrafingRunner(float radius, float speed, float directionSwitchChance) {
        this(radius, radius * 0.5f, speed, directionSwitchChance);
    }

    public StrafingRunner(float radius, float minRadius, float speed, float directionSwitchChance) {
        this.radiusSq = radius * radius;
        this.minRadiusSq = minRadius * minRadius;
        this.speed = speed;
        this.directionSwitchChance = directionSwitchChance;
    }

    @Override
    public boolean run(AnimatedAttackGoal<T> goal, LivingEntity target, AnimatedAction anim) {
        boolean saw;
        if (!this.start) {
            this.start = true;
            this.clockWise = goal.attacker.m_21187_().nextBoolean();
        }
        boolean bl = saw = this.seeTime > 0;
        if (goal.canSee != saw) {
            this.seeTime = 0;
        }
        this.seeTime = goal.canSee ? ++this.seeTime : --this.seeTime;
        if (goal.distanceToTargetSq <= (double)(this.radiusSq * this.radiusSq) && this.seeTime >= 20) {
            goal.attacker.m_21573_().m_26573_();
            ++this.strafingTime;
        } else {
            goal.moveToTarget(this.speed);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 20) {
            if (goal.attacker.m_21187_().nextFloat() < this.directionSwitchChance) {
                this.clockWise = !this.clockWise;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (goal.distanceToTargetSq > (double)this.radiusSq * 0.75) {
                this.strafingBackwards = false;
            } else if (goal.distanceToTargetSq < (double)this.minRadiusSq) {
                this.strafingBackwards = true;
            }
            goal.attacker.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.clockWise ? this.speed : -this.speed);
        }
        goal.attacker.m_21391_((Entity)target, 30.0f, 30.0f);
        return false;
    }
}

