/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class MathUtils {
    public static final Vec3 NORMAL_X = new Vec3(1.0, 0.0, 0.0);
    public static final Vec3 NORMAL_Y = new Vec3(0.0, 1.0, 0.0);
    public static final Vec3 NORMAL_Z = new Vec3(0.0, 0.0, 1.0);

    public static float degToRad(float degree) {
        return degree * ((float)Math.PI / 180);
    }

    public static float radToDeg(float rad) {
        return rad * 57.295776f;
    }

    public static double[] closestOnCircle(double centerX, double centerY, double pointX, double pointY, double radius) {
        double x = pointX - centerX;
        double y = pointY - centerY;
        double d0 = Math.sqrt(x * x + y * y);
        return new double[]{x / d0 * radius + centerX, y / d0 * radius + centerY};
    }

    public static double phiFromPoint(double centerX, double centerY, double pointX, double pointY) {
        return Math.atan2(pointY - centerY, pointX - centerX);
    }

    public static List<float[]> pointsOfCircle(float radius, int density) {
        float rad = MathUtils.degToRad(density);
        float i = -rad;
        ArrayList<float[]> list = new ArrayList<float[]>();
        while ((double)i < Math.PI * 2) {
            list.add(new float[]{radius * Mth.m_14089_((float)(i += rad)), radius * Mth.m_14031_((float)i)});
        }
        return list;
    }

    public static Vec3 rotate(Vec3 rotAxis, Vec3 vec, float angle) {
        double[] res = MathUtils.rotate(rotAxis.f_82479_, rotAxis.f_82480_, rotAxis.f_82481_, vec.f_82479_, vec.f_82480_, vec.f_82481_, angle);
        return new Vec3(res[0], res[1], res[2]);
    }

    public static double[] rotate(double axisX, double axisY, double axisZ, double vecX, double vecY, double vecZ, float angle) {
        double rot = axisX * vecX + axisY * vecY + axisZ * vecZ;
        double x = axisX * rot * (double)(1.0f - Mth.m_14089_((float)angle)) + vecX * (double)Mth.m_14089_((float)angle) + (-axisZ * vecY + axisY * vecZ) * (double)Mth.m_14031_((float)angle);
        double y = axisY * rot * (double)(1.0f - Mth.m_14089_((float)angle)) + vecY * (double)Mth.m_14089_((float)angle) + (axisZ * vecX - axisX * vecZ) * (double)Mth.m_14031_((float)angle);
        double z = axisZ * rot * (double)(1.0f - Mth.m_14089_((float)angle)) + vecZ * (double)Mth.m_14089_((float)angle) + (-axisY * vecX + axisX * vecY) * (double)Mth.m_14031_((float)angle);
        return new double[]{x, y, z};
    }

    public static float[] rotate(float axisX, float axisY, float axisZ, float vecX, float vecY, float vecZ, float angle) {
        float rot = axisX * vecX + axisY * vecY + axisZ * vecZ;
        float x = axisX * rot * (1.0f - Mth.m_14089_((float)angle)) + vecX * Mth.m_14089_((float)angle) + (-axisZ * vecY + axisY * vecZ) * Mth.m_14031_((float)angle);
        float y = axisY * rot * (1.0f - Mth.m_14089_((float)angle)) + vecY * Mth.m_14089_((float)angle) + (axisZ * vecX - axisX * vecZ) * Mth.m_14031_((float)angle);
        float z = axisZ * rot * (1.0f - Mth.m_14089_((float)angle)) + vecZ * Mth.m_14089_((float)angle) + (-axisY * vecX + axisX * vecY) * Mth.m_14031_((float)angle);
        return new float[]{x, y, z};
    }

    public static Vec3 closestPointToLine(Vec3 point, Vec3 from, Vec3 dir) {
        if (dir.equals((Object)Vec3.f_82478_)) {
            return from;
        }
        double lengthSq = dir.m_82556_();
        double x = Math.max(0.0, Math.min(1.0, point.m_82546_(from).m_82526_(dir) / lengthSq));
        return from.m_82549_(dir.m_82490_(x));
    }

    public static double[] rotate2d(double x, double y, double angle) {
        return new double[]{x * Math.cos(angle) - y * Math.sin(angle), y * Math.cos(angle) + x * Math.sin(angle)};
    }

    public static double[][] createRegularPolygonPoints(int shape, float width) {
        if (shape <= 2) {
            throw new IllegalArgumentException("Can't create a polygon with 2 or less corners!");
        }
        double[][] res = new double[shape][];
        Vec3 base = new Vec3((double)width, 0.0, 0.0);
        float rotatePer = 360.0f / (float)shape;
        Vec3 axis = new Vec3(0.0, 0.0, 1.0);
        if (shape % 2 == 0) {
            base = MathUtils.rotate(axis, base, MathUtils.degToRad(rotatePer * 0.5f));
        }
        res[0] = new double[]{base.f_82479_, base.f_82480_};
        float angle = rotatePer;
        for (int i = 1; i < shape; ++i) {
            Vec3 rotated = MathUtils.rotate(axis, base, MathUtils.degToRad(angle));
            angle += rotatePer;
            res[i] = new double[]{rotated.f_82479_, rotated.f_82480_, rotated.f_82481_};
        }
        return res;
    }

    public static float[][] createRegularPolygonPointsF(int shape, float width) {
        if (shape <= 2) {
            throw new IllegalArgumentException("Can't create a polygon with 2 or less corners!");
        }
        float[][] res = new float[shape][];
        Vec3 base = new Vec3((double)width, 0.0, 0.0);
        float rotatePer = 360.0f / (float)shape;
        Vec3 axis = new Vec3(0.0, 0.0, 1.0);
        if (shape % 2 == 0) {
            base = MathUtils.rotate(axis, base, MathUtils.degToRad(rotatePer * 0.5f));
        }
        res[0] = new float[]{(float)base.f_82479_, (float)base.f_82480_};
        float angle = rotatePer;
        for (int i = 1; i < shape; ++i) {
            Vec3 rotated = MathUtils.rotate(axis, base, MathUtils.degToRad(angle));
            angle += rotatePer;
            res[i] = new float[]{(float)rotated.f_82479_, (float)rotated.f_82480_};
        }
        return res;
    }

    public static boolean isInFront(Vec3 pos, Vec3 from, Vec3 dir) {
        return from.m_82549_(dir).m_82557_(pos) < from.m_82546_(dir).m_82557_(pos);
    }

    public static Pair<Vec3, Vec3> closestPointsAABB(AABB axisalignedbb, AABB axisalignedbb2) {
        Vec3 first = new Vec3(axisalignedbb.f_82288_ <= axisalignedbb2.f_82288_ ? axisalignedbb2.f_82288_ : (axisalignedbb.f_82291_ >= axisalignedbb2.f_82291_ ? axisalignedbb2.f_82291_ : axisalignedbb.f_82288_), axisalignedbb.f_82289_ <= axisalignedbb2.f_82289_ ? axisalignedbb2.f_82289_ : (axisalignedbb.f_82292_ >= axisalignedbb2.f_82292_ ? axisalignedbb2.f_82292_ : axisalignedbb.f_82289_), axisalignedbb.f_82290_ <= axisalignedbb2.f_82290_ ? axisalignedbb2.f_82290_ : (axisalignedbb.f_82293_ >= axisalignedbb2.f_82293_ ? axisalignedbb2.f_82293_ : axisalignedbb.f_82290_));
        Vec3 second = new Vec3(axisalignedbb2.f_82288_ <= axisalignedbb.f_82288_ ? axisalignedbb.f_82288_ : (axisalignedbb2.f_82291_ >= axisalignedbb.f_82291_ ? axisalignedbb.f_82291_ : axisalignedbb2.f_82288_), axisalignedbb2.f_82289_ <= axisalignedbb.f_82289_ ? axisalignedbb.f_82289_ : (axisalignedbb2.f_82292_ >= axisalignedbb.f_82292_ ? axisalignedbb.f_82292_ : axisalignedbb2.f_82289_), axisalignedbb2.f_82290_ <= axisalignedbb.f_82290_ ? axisalignedbb.f_82290_ : (axisalignedbb2.f_82293_ >= axisalignedbb.f_82293_ ? axisalignedbb.f_82293_ : axisalignedbb2.f_82290_));
        return Pair.of((Object)first, (Object)second);
    }

    public static double distTo(Entity e, Vec3 from, Vec3 to) {
        double d = Double.MAX_VALUE;
        Vec3 dir = to.m_82546_(from);
        for (double height = 0.0; height <= (double)e.m_20206_(); height += (double)e.m_20206_() * 0.1) {
            Vec3 point = e.m_20182_().m_82520_(0.0, height, 0.0);
            double nD = MathUtils.closestPointToLine(point, from, dir).m_82557_(point);
            if (!(nD < d)) continue;
            d = nD;
        }
        return d;
    }

    public static Vec3 farestPointToLine(Vec3 point, Vec3 l1, Vec3 dir) {
        return new Vec3(Math.abs(l1.f_82479_ - point.f_82479_) > Math.abs(dir.f_82479_ - point.f_82479_) ? l1.f_82479_ : dir.f_82479_, Math.abs(l1.f_82480_ - point.f_82480_) > Math.abs(dir.f_82480_ - point.f_82480_) ? l1.f_82480_ : dir.f_82480_, Math.abs(l1.f_82481_ - point.f_82481_) > Math.abs(dir.f_82481_ - point.f_82481_) ? l1.f_82481_ : dir.f_82481_);
    }

    public static double roundTo(double val, double step) {
        return (double)Math.round(val / (double)((float)step)) * step;
    }
}

