/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.patreon.effects;

import com.mojang.math.Vector3f;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import io.github.flemmli97.tenshilib.patreon.RenderLocation;
import io.github.flemmli97.tenshilib.patreon.effects.GuiElement;
import io.github.flemmli97.tenshilib.patreon.effects.PatreonEffectConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class ParticleEffect
extends PatreonEffectConfig {
    private static final Set<GuiElement> NONE = Set.of();
    private final Particle[] particles;

    public ParticleEffect(String id, int tier, Particle ... particles) {
        super(id, tier);
        this.particles = particles;
    }

    @Override
    public void tick(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        for (int i = 0; i < this.particles.length; ++i) {
            Particle particle = this.particles[i];
            if (particle.chance < 1.0f && player.m_21187_().nextFloat() < particle.chance) continue;
            Vector3f off = RayTraceUtils.rotatedAround(particle.position, Vector3f.f_122225_, -player.m_6080_());
            Vec3 pos = player.m_20182_().m_82520_((double)off.m_122239_(), (double)off.m_122260_(), (double)off.m_122269_());
            if (particle.container.positionMod.isPresent()) {
                pos = pos.m_82549_(particle.container.positionMod.get().apply(player, i));
            }
            Vec3 delta = Vec3.f_82478_;
            if (particle.container.delta.isPresent()) {
                delta = particle.container.delta.get().apply(player, i);
            }
            serverPlayer.m_183503_().m_8767_(particle.container.particle, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 0, delta.f_82479_, delta.f_82480_, delta.f_82481_, 1.0);
        }
    }

    @Override
    public boolean locationAllowed(RenderLocation loc) {
        return false;
    }

    @Override
    public RenderLocation defaultLoc() {
        return RenderLocation.HAT;
    }

    @Override
    public Set<GuiElement> guiElements() {
        return NONE;
    }

    public record Particle(Vec3 position, float chance, ParticleContainer container) {
    }

    private record ParticleContainer(ParticleOptions particle, Optional<ParticleVector> positionMod, Optional<ParticleVector> delta) {
    }

    public static interface ParticleVector {
        public Vec3 apply(Player var1, int var2);
    }

    public static class Pattern {
        private final Direction.Axis axis;
        private final Vec3 initialOffset;
        private double spacing = 0.5;
        private final Map<Character, ParticleContainer> particles = new HashMap<Character, ParticleContainer>();
        private final List<String> patterns = new ArrayList<String>();

        public static Function<Player, Vec3> randomAll(double scale) {
            return player -> new Vec3(player.m_21187_().nextGaussian() * scale, player.m_21187_().nextGaussian() * scale, player.m_21187_().nextGaussian() * scale);
        }

        public Pattern(Direction.Axis axis, Vec3 initialOffset) {
            this.axis = axis;
            this.initialOffset = initialOffset;
        }

        public Pattern setSpacing(double spacing) {
            this.spacing = spacing;
            return this;
        }

        public Pattern addParticle(char key, ParticleOptions particle) {
            return this.addParticle(key, particle, null, null);
        }

        public Pattern addParticleDelta(char key, ParticleOptions particle, ParticleVector delta) {
            return this.addParticle(key, particle, null, delta);
        }

        public Pattern addParticlePos(char key, ParticleOptions particle, ParticleVector position) {
            return this.addParticle(key, particle, position, null);
        }

        public Pattern addParticle(char key, ParticleOptions particle, ParticleVector position, ParticleVector delta) {
            this.particles.put(Character.valueOf(key), new ParticleContainer(particle, Optional.ofNullable(position), Optional.ofNullable(delta)));
            return this;
        }

        public Pattern addPattern(String ... pattern) {
            this.patterns.addAll(List.of(pattern));
            return this;
        }

        public List<Particle> compile() {
            ArrayList<Particle> result = new ArrayList<Particle>();
            double planeX = 0.0;
            double planeY = 0.0;
            for (String pattern : this.patterns) {
                for (char c : pattern.toCharArray()) {
                    ParticleContainer particle = this.particles.get(Character.valueOf(c));
                    if (particle != null) {
                        Vec3 pos = switch (this.axis) {
                            default -> throw new IncompatibleClassChangeError();
                            case Direction.Axis.X -> this.initialOffset.m_82520_(planeX, planeY, 0.0);
                            case Direction.Axis.Y -> this.initialOffset.m_82520_(planeX, 0.0, planeY);
                            case Direction.Axis.Z -> this.initialOffset.m_82520_(0.0, planeY, planeX);
                        };
                        result.add(new Particle(pos, 1.0f, particle));
                    }
                    planeX += this.spacing;
                }
                planeY += this.spacing;
                planeX = 0.0;
            }
            return result;
        }
    }

    public static class Builder {
        private final List<Particle> particles = new ArrayList<Particle>();

        public static Builder of() {
            return new Builder();
        }

        public Builder add(Pattern pattern) {
            this.particles.addAll(pattern.compile());
            return this;
        }

        public ParticleEffect build(String id, int tier) {
            return new ParticleEffect(id, tier, this.particles.toArray(new Particle[0]));
        }
    }
}

