/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.GroupBehaviour;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.object.BrainBehaviourConsumer;
import net.tslat.smartbrainlib.object.BrainBehaviourPredicate;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class SmartBrain<E extends LivingEntity>
extends Brain<E> {
    private final List<MemoryModuleType<?>> expirableMemories = new ObjectArrayList();
    private final List<ActivityBehaviours<E>> behaviours = new ObjectArrayList();
    private final List<Pair<SensorType<ExtendedSensor<? super E>>, ExtendedSensor<? super E>>> sensors = new ObjectArrayList();
    private SmartBrainSchedule schedule = null;
    private boolean sortBehaviours = false;

    public SmartBrain(List<MemoryModuleType<?>> memories, List<? extends ExtendedSensor<E>> sensors, @Nullable List<BrainActivityGroup<E>> taskList, boolean saveMemories) {
        super(memories, (Collection)ImmutableList.of(), ImmutableList.of(), saveMemories ? () -> Brain.m_21946_((Collection)memories, SmartBrain.convertSensorsToTypes(sensors)) : SmartBrain::emptyBrainCodec);
        for (ExtendedSensor<E> extendedSensor : sensors) {
            this.sensors.add(Pair.of(extendedSensor.type(), extendedSensor));
        }
        if (taskList != null) {
            for (BrainActivityGroup brainActivityGroup : taskList) {
                this.addActivity(brainActivityGroup);
            }
        }
    }

    public void m_21865_(ServerLevel level, E entity) {
        ((LivingEntity)entity).f_19853_.m_46473_().m_6180_("SmartBrain");
        if (this.sortBehaviours) {
            this.behaviours.sort(Comparator.comparingInt(ActivityBehaviours::priority));
        }
        this.m_21976_();
        this.tickSensors(level, entity);
        this.checkForNewBehaviours(level, entity);
        this.tickRunningBehaviours(level, entity);
        this.findAndSetActiveActivity(entity);
        ((LivingEntity)entity).f_19853_.m_46473_().m_7238_();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21561_(BrainUtils.hasMemory((LivingEntity)mob, MemoryModuleType.f_26372_));
        }
    }

    private void findAndSetActiveActivity(E entity) {
        Activity scheduledActivity;
        if (this.schedule != null && (scheduledActivity = this.schedule.tick((LivingEntity)entity)) != null && !this.m_147340_().contains(scheduledActivity) && this.m_21969_(scheduledActivity)) {
            this.m_21960_(scheduledActivity);
            return;
        }
        this.m_21926_(((SmartBrainOwner)entity).getActivityPriorities());
    }

    private void tickSensors(ServerLevel level, E entity) {
        for (Pair<SensorType<ExtendedSensor<? super E>>, ExtendedSensor<? super E>> pair : this.sensors) {
            ((ExtendedSensor)((Object)pair.getSecond())).m_26806_(level, entity);
        }
    }

    private void checkForNewBehaviours(ServerLevel level, E entity) {
        long gameTime = level.m_46467_();
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            for (Pair pair : behaviourGroup.behaviours) {
                if (!this.m_147340_().contains(pair.getFirst())) continue;
                for (Behavior behaviour : (List)pair.getSecond()) {
                    if (behaviour.m_22536_() != Behavior.Status.STOPPED) continue;
                    behaviour.m_22554_(level, entity, gameTime);
                }
            }
        }
    }

    private void tickRunningBehaviours(ServerLevel level, E entity) {
        long gameTime = level.m_46467_();
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            for (Pair pair : behaviourGroup.behaviours) {
                for (Behavior behaviour : (List)pair.getSecond()) {
                    if (behaviour.m_22536_() != Behavior.Status.RUNNING) continue;
                    behaviour.m_22558_(level, entity, gameTime);
                }
            }
        }
    }

    public void m_21976_() {
        Iterator<MemoryModuleType<?>> expirable = this.expirableMemories.iterator();
        while (expirable.hasNext()) {
            MemoryModuleType<?> memoryType = expirable.next();
            Optional memory = (Optional)this.f_21843_.get(memoryType);
            if (memory.isEmpty()) {
                expirable.remove();
                continue;
            }
            ExpirableValue value = (ExpirableValue)memory.get();
            if (!value.m_26321_()) {
                expirable.remove();
                continue;
            }
            if (value.m_26320_()) {
                expirable.remove();
                this.m_21936_(memoryType);
                continue;
            }
            value.m_26301_();
        }
    }

    public void m_21933_(ServerLevel level, E entity) {
        long gameTime = level.m_46467_();
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            for (Pair pair : behaviourGroup.behaviours) {
                for (Behavior behaviour : (List)pair.getSecond()) {
                    if (behaviour.m_22536_() != Behavior.Status.RUNNING) continue;
                    behaviour.m_22562_(level, entity, gameTime);
                }
            }
        }
    }

    public <U> Optional<U> m_21952_(MemoryModuleType<U> type) {
        return this.f_21843_.computeIfAbsent(type, key -> Optional.empty()).map(ExpirableValue::m_26319_);
    }

    public <U> void m_21941_(MemoryModuleType<U> memoryType, Optional<? extends ExpirableValue<?>> memory) {
        Collection collection;
        Object object;
        if (memory.isPresent() && (object = memory.get().m_26319_()) instanceof Collection && (collection = (Collection)object).isEmpty()) {
            memory = Optional.empty();
        }
        this.f_21843_.put(memoryType, memory);
        if (memory.isPresent() && memory.get().m_26321_()) {
            this.expirableMemories.add(memoryType);
        }
    }

    public <U> boolean m_21938_(MemoryModuleType<U> memoryType, U memory) {
        Optional<U> value = this.m_21952_(memoryType);
        return value.isPresent() && value.get().equals(memory);
    }

    private static <E extends LivingEntity> Codec<Brain<E>> emptyBrainCodec() {
        MutableObject brainCodec = new MutableObject();
        brainCodec.setValue((Object)Codec.unit(() -> new Brain((Collection)ImmutableList.of(), (Collection)ImmutableList.of(), ImmutableList.of(), () -> ((MutableObject)brainCodec).getValue())));
        return (Codec)brainCodec.getValue();
    }

    private static <E extends LivingEntity> List<? extends SensorType<? extends Sensor<? super E>>> convertSensorsToTypes(List<? extends ExtendedSensor<E>> sensors) {
        ObjectArrayList types = new ObjectArrayList(sensors.size());
        for (ExtendedSensor<E> sensor : sensors) {
            types.add(sensor.type());
        }
        return types;
    }

    public Brain<E> m_21973_() {
        SmartBrain<E> brain = new SmartBrain<E>(this.f_21843_.keySet().stream().toList(), this.sensors.stream().map(pair -> (ExtendedSensor)((Object)((Object)pair.getSecond()))).toList(), null, false);
        for (Map.Entry entry : this.f_21843_.entrySet()) {
            MemoryModuleType memoryType = (MemoryModuleType)entry.getKey();
            if (!((Optional)entry.getValue()).isPresent()) continue;
            brain.f_21843_.put(memoryType, (Optional)entry.getValue());
        }
        return brain;
    }

    public List<Behavior<? super E>> m_21956_() {
        ObjectArrayList runningBehaviours = new ObjectArrayList();
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            for (Pair pair : behaviourGroup.behaviours) {
                for (Behavior behaviour : (List)pair.getSecond()) {
                    if (behaviour.m_22536_() != Behavior.Status.RUNNING) continue;
                    runningBehaviours.add(behaviour);
                }
            }
        }
        return runningBehaviours;
    }

    public Stream<Behavior<? super E>> getBehaviours() {
        return this.behaviours.stream().map(ActivityBehaviours::behaviours).flatMap(list -> list.stream().map(Pair::getSecond).flatMap(Collection::stream));
    }

    public void m_147343_() {
        this.behaviours.clear();
    }

    public void m_21907_(Activity activity, ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> tasks, Set<Pair<MemoryModuleType<?>, MemoryStatus>> memorieStatuses, Set<MemoryModuleType<?>> memoryTypes) {
        this.f_21847_.put(activity, memorieStatuses);
        if (!memoryTypes.isEmpty()) {
            this.f_21848_.put(activity, memoryTypes);
        }
        for (Pair pair : tasks) {
            this.addBehaviour((Integer)pair.getFirst(), activity, (Behavior)pair.getSecond());
        }
    }

    public void addActivity(BrainActivityGroup<E> activityGroup) {
        this.m_21907_(activityGroup.getActivity(), activityGroup.pairBehaviourPriorities(), activityGroup.getActivityStartMemoryConditions(), activityGroup.getWipedMemoriesOnFinish());
    }

    public void addBehaviour(int priority, Activity activity, Behavior<? super E> behaviour) {
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            if (behaviourGroup.priority != priority) continue;
            for (Pair pair : behaviourGroup.behaviours) {
                if (pair.getFirst() != activity) continue;
                ((List)pair.getSecond()).add(behaviour);
                return;
            }
            behaviourGroup.behaviours.add(Pair.of((Object)activity, (Object)ObjectArrayList.of((Object[])new Behavior[]{behaviour})));
            return;
        }
        this.behaviours.add(new ActivityBehaviours(priority, ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)activity, (Object)ObjectArrayList.of((Object[])new Behavior[]{behaviour}))})));
        this.sortBehaviours = true;
    }

    public void removeBehaviour(E entity, BrainBehaviourPredicate predicate) {
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            int priority = behaviourGroup.priority;
            for (Pair pair : behaviourGroup.behaviours) {
                Activity activity = (Activity)pair.getFirst();
                Iterator iterator = ((List)pair.getSecond()).iterator();
                while (iterator.hasNext()) {
                    Behavior behaviour = (Behavior)iterator.next();
                    SmartBrain.checkBehaviour(priority, activity, behaviour, null, predicate, () -> {
                        if (behaviour.m_22536_() == Behavior.Status.RUNNING) {
                            behaviour.m_22562_((ServerLevel)entity.m_183503_(), entity, entity.f_19853_.m_46467_());
                        }
                        iterator.remove();
                    });
                }
            }
        }
    }

    public SmartBrain<E> setSchedule(SmartBrainSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public SmartBrainSchedule getSchedule() {
        return this.schedule;
    }

    public void scheduleTask(E brainOwner, int delay, Runnable task) {
        if (this.schedule == null) {
            this.schedule = new SmartBrainSchedule();
        }
        this.schedule.scheduleTask((LivingEntity)brainOwner, delay, task);
    }

    private static <E extends LivingEntity> void checkBehaviour(int priority, Activity activity, Behavior<E> behaviour, @Nullable Behavior<E> parentBehaviour, BrainBehaviourPredicate predicate, Runnable callback) {
        if (predicate.isBehaviour(priority, activity, behaviour, parentBehaviour)) {
            callback.run();
        } else if (behaviour instanceof GateBehavior) {
            GateBehavior groupBehaviour = (GateBehavior)behaviour;
            Iterator childBehaviourIterator = groupBehaviour.f_22871_.m_147932_().iterator();
            while (childBehaviourIterator.hasNext()) {
                SmartBrain.checkBehaviour(priority, activity, (Behavior)childBehaviourIterator.next(), groupBehaviour, predicate, childBehaviourIterator::remove);
            }
            if (!groupBehaviour.f_22871_.m_147932_().iterator().hasNext()) {
                callback.run();
            }
        } else if (behaviour instanceof GroupBehaviour) {
            GroupBehaviour groupBehaviour = (GroupBehaviour)behaviour;
            Iterator childBehaviourIterator = groupBehaviour.getBehaviours();
            while (childBehaviourIterator.hasNext()) {
                SmartBrain.checkBehaviour(priority, activity, childBehaviourIterator.next(), groupBehaviour, predicate, childBehaviourIterator::remove);
            }
            if (!groupBehaviour.getBehaviours().hasNext()) {
                callback.run();
            }
        }
    }

    public void forEachBehaviour(BrainBehaviourConsumer consumer) {
        for (ActivityBehaviours<E> behavioursGroup : this.behaviours) {
            int priority = behavioursGroup.priority();
            for (Pair<Activity, List<Behavior<E>>> behaviourList : behavioursGroup.behaviours()) {
                Activity activity = (Activity)behaviourList.getFirst();
                for (Behavior behaviour : (List)behaviourList.getSecond()) {
                    SmartBrain.consumeBehaviour(priority, activity, behaviour, null, consumer);
                }
            }
        }
    }

    private static <E extends LivingEntity> void consumeBehaviour(int priority, Activity activity, Behavior<E> behaviour, @Nullable Behavior<E> parentBehaviour, BrainBehaviourConsumer consumer) {
        consumer.consume(priority, activity, behaviour, parentBehaviour);
        if (behaviour instanceof GateBehavior) {
            GateBehavior groupBehaviour = (GateBehavior)behaviour;
            groupBehaviour.f_22871_.m_147932_().forEach(childBehaviour -> SmartBrain.consumeBehaviour(priority, activity, childBehaviour, groupBehaviour, consumer));
        } else if (behaviour instanceof GroupBehaviour) {
            GroupBehaviour groupBehaviour = (GroupBehaviour)behaviour;
            groupBehaviour.getBehaviours().forEachRemaining(childBehaviour -> SmartBrain.consumeBehaviour(priority, activity, childBehaviour, groupBehaviour, consumer));
        }
    }

    public void addSensor(ExtendedSensor<E> sensor) {
        SensorType<ExtendedSensor<?>> sensorType = sensor.type();
        this.sensors.add(Pair.of(sensorType, sensor));
    }

    @Deprecated(forRemoval=true)
    public final void m_21912_(Schedule schedule) {
    }

    private record ActivityBehaviours<E extends LivingEntity>(int priority, List<Pair<Activity, List<Behavior<? super E>>>> behaviours) {
    }
}

