/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.target;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.FreePositionTracker;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetRandomLookTarget<E extends Mob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORIES = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT)});
    protected FloatProvider runChance = ConstantFloat.m_146458_((float)0.02f);
    protected Function<E, Integer> lookTime = entity -> entity.m_21187_().nextInt(20) + 20;

    public SetRandomLookTarget<E> lookChance(FloatProvider chance) {
        this.runChance = chance;
        return this;
    }

    public SetRandomLookTarget<E> lookTime(Function<E, Integer> function) {
        this.lookTime = function;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        return entity.m_21187_().nextFloat() < this.runChance.m_142269_(entity.m_21187_());
    }

    @Override
    protected void start(E entity) {
        double angle = 6.2831854820251465 * entity.m_21187_().nextDouble();
        BrainUtils.setForgettableMemory(entity, MemoryModuleType.f_26371_, new FreePositionTracker(entity.m_146892_().m_82520_(Math.cos(angle), 0.0, Math.sin(angle))), (int)this.lookTime.apply(entity));
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }
}

