/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class CropProperties {
    public static final Codec<CropProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("growth").forGetter(d -> d.growth), (App)Codec.INT.fieldOf("max_drops").forGetter(d -> d.maxDrops), (App)Codec.BOOL.fieldOf("regrowable").forGetter(d -> d.regrowable), (App)class_2378.field_11146.method_39673().optionalFieldOf("giant_crop").forGetter(d -> d.giantVersion == class_2246.field_10124 ? Optional.empty() : Optional.of(d.giantVersion)), (App)Codec.list((Codec)CodecUtils.stringEnumCodec(EnumSeason.class, (Enum)EnumSeason.SPRING)).fieldOf("best_season").forGetter(d -> List.copyOf(d.bestSeason)), (App)Codec.list((Codec)CodecUtils.stringEnumCodec(EnumSeason.class, (Enum)EnumSeason.SPRING)).fieldOf("bad_season").forGetter(d -> List.copyOf(d.badSeason))).apply((Applicative)instance, (growth, drops, regrowable, giant, best, bad) -> new CropProperties((int)growth, (int)drops, (boolean)regrowable, giant.orElse(class_2246.field_10124), (Collection<EnumSeason>)best, (Collection<EnumSeason>)bad)));
    public static final CropProperties DEFAULT_PROP = new CropProperties();
    private final EnumSet<EnumSeason> bestSeason = EnumSet.noneOf(EnumSeason.class);
    private final EnumSet<EnumSeason> badSeason = EnumSet.noneOf(EnumSeason.class);
    private int growth = 3;
    private int maxDrops = 2;
    private boolean regrowable;
    private class_2248 giantVersion = class_2246.field_10124;
    private transient List<class_2561> translationTexts;
    private transient class_2960 id;

    private CropProperties() {
    }

    public CropProperties(int growth, int maxDrops, boolean regrowable, class_2248 giantVersion, Collection<EnumSeason> bestSeason, Collection<EnumSeason> badSeason) {
        this.growth = growth;
        this.maxDrops = maxDrops;
        this.giantVersion = giantVersion;
        this.regrowable = regrowable;
        this.bestSeason.addAll(bestSeason);
        this.badSeason.addAll(badSeason);
    }

    public static CropProperties fromPacket(class_2540 buffer) {
        int i;
        CropProperties prop = new CropProperties();
        prop.id = buffer.method_10810();
        prop.growth = buffer.readInt();
        prop.maxDrops = buffer.readInt();
        prop.regrowable = buffer.readBoolean();
        int size = buffer.readInt();
        for (i = 0; i < size; ++i) {
            prop.bestSeason.add((EnumSeason)buffer.method_10818(EnumSeason.class));
        }
        size = buffer.readInt();
        for (i = 0; i < size; ++i) {
            prop.badSeason.add((EnumSeason)buffer.method_10818(EnumSeason.class));
        }
        return prop;
    }

    public void setID(class_2960 id) {
        if (this.id == null) {
            this.id = id;
        }
    }

    public class_2960 getId() {
        return this.id;
    }

    public Set<EnumSeason> bestSeasons() {
        return this.bestSeason;
    }

    public Set<EnumSeason> badSeasons() {
        return this.badSeason;
    }

    public int growth() {
        return this.growth;
    }

    public int maxDrops() {
        return this.maxDrops;
    }

    public boolean regrowable() {
        return this.regrowable;
    }

    public class_2248 getGiantVersion() {
        return this.giantVersion;
    }

    public float seasonMultiplier(EnumSeason season) {
        if (this.bestSeason.contains((Object)season)) {
            return 1.5f;
        }
        if (this.badSeason.contains((Object)season)) {
            return 0.6666667f;
        }
        return 1.0f;
    }

    public void toPacket(class_2540 buffer) {
        buffer.method_10812(this.id);
        buffer.writeInt(this.growth);
        buffer.writeInt(this.maxDrops);
        buffer.writeBoolean(this.regrowable);
        buffer.writeInt(this.bestSeason.size());
        this.bestSeason.forEach(arg_0 -> ((class_2540)buffer).method_10817(arg_0));
        buffer.writeInt(this.badSeason.size());
        this.badSeason.forEach(arg_0 -> ((class_2540)buffer).method_10817(arg_0));
    }

    public List<class_2561> texts() {
        if (this.translationTexts == null) {
            this.translationTexts = new ArrayList<class_2561>();
            if (!this.bestSeason.isEmpty()) {
                class_5250 season = new class_2588("runecraftory.tooltip.season.best").method_27693(": ");
                int i = 0;
                for (EnumSeason seas : this.bestSeasons()) {
                    season.method_27693(i != 0 ? "/" : "").method_27692(class_124.field_1080).method_10852((class_2561)new class_2588(seas.translationKey()).method_27692(seas.getColor()));
                    ++i;
                }
                this.translationTexts.add((class_2561)season);
            }
            EnumSet<EnumSeason> badSeasons = EnumSet.copyOf(this.badSeason);
            badSeasons.removeAll(this.bestSeasons());
            if (!badSeasons.isEmpty()) {
                class_5250 season = new class_2588("runecraftory.tooltip.season.bad").method_27693(": ");
                int i = 0;
                for (EnumSeason seas : badSeasons) {
                    season.method_27693(i != 0 ? "/" : "").method_27692(class_124.field_1080).method_10852((class_2561)new class_2588(seas.translationKey()).method_27692(seas.getColor()));
                    ++i;
                }
                this.translationTexts.add((class_2561)season);
            }
            class_5250 growth = new class_2588("runecraftory.tooltip.growth", new Object[]{this.growth()}).method_27692(class_124.field_1065);
            class_5250 harvest = new class_2588("runecraftory.tooltip.harvested", new Object[]{this.maxDrops()}).method_27692(class_124.field_1065);
            this.translationTexts.add((class_2561)growth.method_27693("  ").method_10852((class_2561)harvest));
        }
        return this.translationTexts;
    }

    public String toString() {
        String s = "[BestSeasons:" + String.valueOf(this.bestSeason) + ";BadSeasons:" + String.valueOf(this.badSeason) + ";Growth:" + this.growth + ";Drops:" + this.maxDrops + ";Regrowable:" + this.regrowable + "]";
        if (this.id != null) {
            s = String.valueOf(this.id) + ":" + s;
        }
        return s;
    }

    public static class Builder {
        private final EnumSet<EnumSeason> bestSeason = EnumSet.noneOf(EnumSeason.class);
        private final EnumSet<EnumSeason> badSeason = EnumSet.noneOf(EnumSeason.class);
        private final int growth;
        private final int maxDrops;
        private final boolean regrowable;
        private class_2248 giantVersion = class_2246.field_10124;

        public Builder(int growth, int maxDrops, boolean regrowable) {
            this.growth = growth;
            this.maxDrops = maxDrops;
            this.regrowable = regrowable;
        }

        public Builder addGoodSeason(EnumSeason season) {
            this.bestSeason.add(season);
            return this;
        }

        public Builder addBadSeason(EnumSeason season) {
            this.badSeason.add(season);
            return this;
        }

        public Builder withGiantVersion(class_2248 giantVersion) {
            this.giantVersion = giantVersion;
            return this;
        }

        public CropProperties build() {
            return new CropProperties(this.growth, this.maxDrops, this.regrowable, this.giantVersion, this.bestSeason, this.badSeason);
        }
    }
}

