/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.datapack.EntityRideActionCosts;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import io.github.flemmli97.tenshilib.common.utils.SearchUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1320;
import net.minecraft.class_2048;
import net.minecraft.class_2378;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_5699;
import org.jetbrains.annotations.NotNull;

public class EntityProperties {
    public static final EntityProperties DEFAULT_PROP = new Builder().putAttributes(() -> class_5134.field_23716, 20.0).putAttributes(() -> class_5134.field_23721, 1.0).xp(5).money(5).tamingChance(0.3f).build();
    public static final Codec<EntityProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_2378.field_23781.method_39673(), (Codec)Codec.DOUBLE).fieldOf("base_values").forGetter(d -> d.baseValues), (App)Codec.unboundedMap((Codec)class_2378.field_23781.method_39673(), (Codec)Codec.DOUBLE).fieldOf("level_gains").forGetter(d -> d.levelGains), (App)CodecHelper.ENTITY_PREDICATE_CODEC.optionalFieldOf("spawner_predicate").forGetter(d -> Optional.ofNullable(d.spawnerPredicate == class_2048.field_9599 ? null : d.spawnerPredicate)), (App)Codec.BOOL.fieldOf("needs_roof").forGetter(d -> d.needsRoof), (App)OnKilledIncrease.CODEC.listOf().optionalFieldOf("level_increase_on_kill").forGetter(d -> d.levelIncreaseOnKill.isEmpty() ? Optional.empty() : Optional.of(d.levelIncreaseOnKill)), (App)EntityRideActionCosts.CODEC.fieldOf("ride_action_costs").forGetter(d -> d.rideActionCosts), (App)Codec.BOOL.fieldOf("rideable").forGetter(d -> d.rideable), (App)Codec.BOOL.fieldOf("flying").forGetter(d -> d.flying), (App)class_5699.field_33442.fieldOf("size").forGetter(d -> d.size), (App)class_5699.field_33442.fieldOf("min_level").forGetter(d -> d.minLevel), (App)class_5699.field_33441.fieldOf("xp").forGetter(d -> d.xp), (App)class_5699.field_33441.fieldOf("money").forGetter(d -> d.money), (App)Codec.FLOAT.fieldOf("taming_chance").forGetter(d -> Float.valueOf(d.tamingChance))).apply((Applicative)instance, (baseValues, levelGains, spawnerPredicate, needsRoof, levelIncreaseOnKill, rideActionCosts, rideable, flying, size, minLevel, xp, money, tamingChance) -> new EntityProperties((int)minLevel, (int)xp, (int)money, tamingChance.floatValue(), (boolean)rideable, (boolean)flying, (int)size, (boolean)needsRoof, (EntityRideActionCosts)rideActionCosts, (Map<class_1320, Double>)baseValues, (Map<class_1320, Double>)levelGains, levelIncreaseOnKill.orElse(List.of()), spawnerPredicate.orElse(class_2048.field_9599))));
    public final int minLevel;
    public final int xp;
    public final int money;
    public final float tamingChance;
    public final boolean rideable;
    public final boolean flying;
    public final int size;
    public final boolean needsRoof;
    public final EntityRideActionCosts rideActionCosts;
    private final Map<class_1320, Double> baseValues;
    private final Map<class_1320, Double> levelGains;
    private final List<OnKilledIncrease> levelIncreaseOnKill;
    public final class_2048 spawnerPredicate;

    private EntityProperties(int minLevel, int xp, int money, float tamingChance, boolean rideable, boolean flying, int size, boolean needsRoof, EntityRideActionCosts rideActionCosts, Map<class_1320, Double> baseValues, Map<class_1320, Double> levelGains, List<OnKilledIncrease> levelIncreaseOnKill, class_2048 spawnerPredicate) {
        this.minLevel = Math.max(1, minLevel);
        this.xp = xp;
        this.money = money;
        this.tamingChance = tamingChance;
        this.rideable = rideable;
        this.flying = flying;
        this.size = size;
        this.needsRoof = needsRoof;
        this.rideActionCosts = rideActionCosts;
        this.baseValues = baseValues;
        this.levelGains = levelGains;
        this.levelIncreaseOnKill = levelIncreaseOnKill.stream().sorted().toList();
        this.spawnerPredicate = spawnerPredicate;
    }

    public Map<class_1320, Double> getBaseValues() {
        return ImmutableMap.copyOf(this.baseValues);
    }

    public Map<class_1320, Double> getAttributeGains() {
        return ImmutableMap.copyOf(this.levelGains);
    }

    public int levelIncreaseFromKill(int killed, class_3222 player) {
        return ((OnKilledIncrease)SearchUtils.searchInfFunc(this.levelIncreaseOnKill.stream().filter(c -> c.condition.method_8914(player, (class_1297)player)).toList(), p -> Integer.compare(p.minKilled(), killed), (Object)OnKilledIncrease.DEFAULT)).increase();
    }

    private record OnKilledIncrease(int minKilled, int increase, class_2048 condition) implements Comparable<OnKilledIncrease>
    {
        private static final OnKilledIncrease DEFAULT = new OnKilledIncrease(0, 0, null);
        public static final Codec<OnKilledIncrease> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("min_killed").forGetter(d -> d.minKilled), (App)Codec.INT.fieldOf("increase").forGetter(d -> d.increase), (App)CodecHelper.ENTITY_PREDICATE_CODEC.optionalFieldOf("predicate").forGetter(d -> Optional.ofNullable(d.condition == class_2048.field_9599 ? null : d.condition))).apply((Applicative)inst, (minKilled, increase, predicate) -> new OnKilledIncrease((int)minKilled, (int)increase, predicate.orElse(class_2048.field_9599))));

        @Override
        public int compareTo(@NotNull OnKilledIncrease o) {
            return Integer.compare(this.minKilled, o.minKilled);
        }
    }

    public static class Builder {
        private final Map<Supplier<class_1320>, Double> baseValues = new LinkedHashMap<Supplier<class_1320>, Double>();
        private final Map<Supplier<class_1320>, Double> gains = new LinkedHashMap<Supplier<class_1320>, Double>();
        private int xp;
        private int money;
        private float taming;
        private boolean rideable;
        private boolean flying;
        private int size = 1;
        private boolean needsRoof = true;
        private int minLevel = 1;
        private EntityRideActionCosts rideActionCosts = EntityRideActionCosts.DEFAULT;
        private final List<OnKilledIncrease> levelIncreaseOnKill = new ArrayList<OnKilledIncrease>();
        private class_2048 spawnerPredicate = class_2048.field_9599;

        public Builder putAttributes(Supplier<class_1320> att, double val) {
            this.baseValues.put(att, val);
            return this;
        }

        public Builder putLevelGains(Supplier<class_1320> att, double val) {
            this.gains.put(att, val);
            return this;
        }

        public Builder xp(int xp) {
            this.xp = xp;
            return this;
        }

        public Builder money(int money) {
            this.money = money;
            return this;
        }

        public Builder tamingChance(float chance) {
            this.taming = chance;
            return this;
        }

        public Builder setRideable() {
            this.rideable = true;
            return this;
        }

        public Builder setFlying() {
            this.flying = true;
            return this;
        }

        public Builder setBarnOccupancy(int size) {
            this.size = Math.max(1, size);
            return this;
        }

        public Builder doesntNeedBarnRoof() {
            this.needsRoof = false;
            return this;
        }

        public Builder setMinLevel(int minLevel) {
            this.minLevel = minLevel;
            return this;
        }

        public Builder withLevelIncrease(int minKilled, int increase) {
            this.levelIncreaseOnKill.add(new OnKilledIncrease(minKilled, increase, class_2048.field_9599));
            return this;
        }

        public Builder withLevelIncrease(int minKilled, int increase, class_2048.class_2049 pred) {
            this.levelIncreaseOnKill.add(new OnKilledIncrease(minKilled, increase, pred.method_8920()));
            return this;
        }

        public Builder withRideActionCosts(EntityRideActionCosts.Builder costs) {
            this.rideActionCosts = costs.build();
            return this;
        }

        public Builder withSpawnerPredicate(class_2048.class_2049 builder) {
            this.spawnerPredicate = builder.method_8920();
            return this;
        }

        public EntityProperties build() {
            return new EntityProperties(this.minLevel, this.xp, this.money, this.taming, this.rideable, this.flying, this.size, this.needsRoof, this.rideActionCosts, this.baseValues.entrySet().stream().collect(Collectors.toMap(e -> (class_1320)((Supplier)e.getKey()).get(), Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)), this.gains.entrySet().stream().collect(Collectors.toMap(e -> (class_1320)((Supplier)e.getKey()).get(), Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)), this.levelIncreaseOnKill, this.spawnerPredicate);
        }
    }
}

