/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.datapack.SimpleEffect;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.common.utils.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5250;

public class FoodProperties {
    public static final Codec<FoodProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_2378.field_23781.method_39673(), (Codec)Codec.DOUBLE).fieldOf("cooking_bonus_percent").forGetter(d -> d.cookingBonusPercent), (App)SimpleEffect.CODEC.listOf().fieldOf("potion_apply").forGetter(d -> Arrays.asList(d.potionApply)), (App)class_2378.field_11159.method_39673().listOf().fieldOf("potion_remove").forGetter(d -> Arrays.asList(d.potionRemove)), (App)Codec.INT.fieldOf("duration").forGetter(d -> d.duration), (App)Codec.unboundedMap((Codec)class_2378.field_23781.method_39673(), (Codec)Codec.DOUBLE).fieldOf("effects").forGetter(d -> d.effects), (App)Codec.unboundedMap((Codec)class_2378.field_23781.method_39673(), (Codec)Codec.DOUBLE).fieldOf("effects_percentage").forGetter(d -> d.effectsPercentage), (App)Codec.unboundedMap((Codec)class_2378.field_23781.method_39673(), (Codec)Codec.DOUBLE).fieldOf("cooking_bonus").forGetter(d -> d.cookingBonus)).apply((Applicative)instance, (cookingPercent, potion, remove, duration, effects, effPercent, cooking) -> new FoodProperties((int)duration, (Map<class_1320, Double>)effects, (Map<class_1320, Double>)effPercent, (Map<class_1320, Double>)cooking, (Map<class_1320, Double>)cookingPercent, (List<SimpleEffect>)potion, (List<class_1291>)remove)));
    private final Map<class_1320, Double> effects = new TreeMap<class_1320, Double>(ModAttributes.SORTED);
    private final Map<class_1320, Double> effectsPercentage = new TreeMap<class_1320, Double>(ModAttributes.SORTED);
    private final Map<class_1320, Double> cookingBonus = new TreeMap<class_1320, Double>(ModAttributes.SORTED);
    private final Map<class_1320, Double> cookingBonusPercent = new TreeMap<class_1320, Double>(ModAttributes.SORTED);
    private int duration;
    private SimpleEffect[] potionApply = new SimpleEffect[0];
    private class_1291[] potionRemove = new class_1291[0];
    private class_2960 id;

    private FoodProperties() {
    }

    public FoodProperties(int duration, Map<class_1320, Double> effects, Map<class_1320, Double> effectsPercentage, Map<class_1320, Double> cookingBonus, Map<class_1320, Double> cookingBonusPercent, List<SimpleEffect> potionApply, List<class_1291> potionRemove) {
        this.duration = duration;
        this.effects.putAll(effects);
        this.effectsPercentage.putAll(effectsPercentage);
        this.cookingBonus.putAll(cookingBonus);
        this.cookingBonusPercent.putAll(cookingBonusPercent);
        this.potionApply = potionApply.toArray(new SimpleEffect[0]);
        this.potionRemove = potionRemove.toArray(new class_1291[0]);
    }

    public static FoodProperties fromPacket(class_2540 buffer) {
        int i;
        FoodProperties prop = new FoodProperties();
        prop.id = buffer.method_10810();
        prop.duration = buffer.readInt();
        int size = buffer.readInt();
        for (i = 0; i < size; ++i) {
            prop.effects.put((class_1320)class_2378.field_23781.method_10223(buffer.method_10810()), buffer.readDouble());
        }
        size = buffer.readInt();
        for (i = 0; i < size; ++i) {
            prop.effectsPercentage.put((class_1320)class_2378.field_23781.method_10223(buffer.method_10810()), buffer.readDouble());
        }
        size = buffer.readInt();
        prop.potionRemove = new class_1291[size];
        for (i = 0; i < size; ++i) {
            prop.potionRemove[i] = (class_1291)class_2378.field_11159.method_10223(buffer.method_10810());
        }
        size = buffer.readInt();
        prop.potionApply = new SimpleEffect[size];
        for (i = 0; i < size; ++i) {
            prop.potionApply[i] = new SimpleEffect((class_1291)class_2378.field_11159.method_10223(buffer.method_10810()), buffer.readInt(), buffer.readInt());
        }
        return prop;
    }

    public void setID(class_2960 id) {
        if (this.id == null) {
            this.id = id;
        }
    }

    public class_2960 getId() {
        return this.id;
    }

    public int getHPGain() {
        return this.effects.getOrDefault(ModAttributes.HEALTHGAIN.get(), 0.0).intValue();
    }

    public int getHpPercentGain() {
        return this.effects.getOrDefault(ModAttributes.HEALTHGAIN.get(), 0.0).intValue();
    }

    public int getRPRegen() {
        return this.effects.getOrDefault(ModAttributes.RPGAIN.get(), 0.0).intValue();
    }

    public int getRpPercentRegen() {
        return this.effectsPercentage.getOrDefault(ModAttributes.RPGAIN.get(), 0.0).intValue();
    }

    public int duration() {
        return this.duration;
    }

    public Map<class_1320, Double> effects() {
        return new LinkedHashMap<class_1320, Double>(this.effects);
    }

    public Map<class_1320, Double> effectsMultiplier() {
        return new LinkedHashMap<class_1320, Double>(this.effectsPercentage);
    }

    public Map<class_1320, Double> cookingBonus() {
        return new LinkedHashMap<class_1320, Double>(this.cookingBonus);
    }

    public Map<class_1320, Double> cookingBonusPercent() {
        return new LinkedHashMap<class_1320, Double>(this.cookingBonusPercent);
    }

    public List<class_1291> potionHeals() {
        return ImmutableList.copyOf((Object[])this.potionRemove);
    }

    public List<SimpleEffect> potionApply() {
        return ImmutableList.copyOf((Object[])this.potionApply);
    }

    public void toPacket(class_2540 buffer) {
        buffer.method_10812(this.id);
        buffer.writeInt(this.duration);
        buffer.writeInt(this.effects.size());
        this.effects.forEach((att, val) -> {
            buffer.method_10812(class_2378.field_23781.method_10221(att));
            buffer.writeDouble(val.doubleValue());
        });
        buffer.writeInt(this.effectsPercentage.size());
        this.effectsPercentage.forEach((att, val) -> {
            buffer.method_10812(class_2378.field_23781.method_10221(att));
            buffer.writeDouble(val.doubleValue());
        });
        buffer.writeInt(this.potionRemove.length);
        for (class_1291 class_12912 : this.potionRemove) {
            buffer.method_10812(class_2378.field_11159.method_10221((Object)class_12912));
        }
        buffer.writeInt(this.potionApply.length);
        for (SimpleEffect simpleEffect : this.potionApply) {
            buffer.method_10812(class_2378.field_11159.method_10221((Object)simpleEffect.getPotion()));
            buffer.writeInt(simpleEffect.getDuration());
            buffer.writeInt(simpleEffect.getAmplifier());
        }
    }

    public List<class_2561> texts(class_1799 stack) {
        class_5250 comp;
        ArrayList<class_2561> translationTexts = new ArrayList<class_2561>();
        translationTexts.add((class_2561)new class_2588("runecraftory.tooltip.item.eaten").method_27692(class_124.field_1080));
        class_2585 hprp = new class_2585("");
        Pair<Map<class_1320, Double>, Map<class_1320, Double>> foodStats = ItemNBT.foodStats(stack);
        Map effects = (Map)foodStats.getFirst();
        Map effectsPercent = (Map)foodStats.getSecond();
        class_2585 hpIncrease = new class_2585("");
        class_2585 rpIncrease = new class_2585("");
        ArrayList<class_5250> attributes = new ArrayList<class_5250>();
        for (Map.Entry entry : effects.entrySet()) {
            if ((Double)entry.getValue() == 0.0) continue;
            comp = new class_2585(" ").method_10852((class_2561)new class_2588(((class_1320)entry.getKey()).method_26830())).method_10852((class_2561)new class_2585(": " + this.format((Double)entry.getValue())));
            if (entry.getKey() == ModAttributes.HEALTHGAIN.get() || entry.getKey() == ModAttributes.RPGAIN.get()) {
                hprp.method_10852((class_2561)comp);
                continue;
            }
            if (entry.getKey() == ModAttributes.RPINCREASE.get()) {
                rpIncrease.method_10852((class_2561)comp);
                continue;
            }
            if (entry.getKey() == class_5134.field_23716) {
                hpIncrease.method_10852((class_2561)comp);
                continue;
            }
            attributes.add(comp.method_27692(class_124.field_1075));
        }
        for (Map.Entry entry : effectsPercent.entrySet()) {
            if ((Double)entry.getValue() == 0.0) continue;
            comp = new class_2585(" ").method_10852((class_2561)new class_2588(((class_1320)entry.getKey()).method_26830())).method_10852((class_2561)new class_2585(": " + this.format((Double)entry.getValue()) + "%"));
            if (entry.getKey() == ModAttributes.HEALTHGAIN.get() || entry.getKey() == ModAttributes.RPGAIN.get()) {
                hprp.method_10852((class_2561)comp);
                continue;
            }
            if (entry.getKey() == ModAttributes.RPINCREASE.get()) {
                rpIncrease.method_10852((class_2561)comp);
                continue;
            }
            if (entry.getKey() == class_5134.field_23716) {
                hpIncrease.method_10852((class_2561)comp);
                continue;
            }
            attributes.add(comp.method_27692(class_124.field_1075));
        }
        if (!hprp.method_10855().isEmpty()) {
            translationTexts.add((class_2561)hprp.method_27692(class_124.field_1075));
        }
        if (!hpIncrease.method_10855().isEmpty()) {
            translationTexts.add((class_2561)hpIncrease.method_27692(class_124.field_1075));
        }
        if (!rpIncrease.method_10855().isEmpty()) {
            translationTexts.add((class_2561)rpIncrease.method_27692(class_124.field_1075));
        }
        translationTexts.addAll(attributes);
        if (translationTexts.size() == 1) {
            return Collections.emptyList();
        }
        return translationTexts;
    }

    private String format(double n) {
        return n >= 0.0 ? "+" + (int)n : "" + (int)n;
    }

    public String toString() {
        String s = "[Duration:" + this.duration + "]{effects:[" + String.valueOf(this.effects) + "], potions:[" + ArrayUtils.arrayToString((Object[])this.potionRemove, null) + "]";
        if (this.id != null) {
            s = String.valueOf(this.id) + ":" + s;
        }
        return s;
    }

    public static class Builder {
        private final Map<class_1320, Double> effects = new HashMap<class_1320, Double>();
        private final Map<class_1320, Double> effectsPercentage = new HashMap<class_1320, Double>();
        private final Map<class_1320, Double> cookingBonus = new HashMap<class_1320, Double>();
        private final Map<class_1320, Double> cookingBonusPercent = new HashMap<class_1320, Double>();
        private final List<SimpleEffect> potionApply = new ArrayList<SimpleEffect>();
        private final List<class_1291> potionRemove = new ArrayList<class_1291>();
        private final int duration;

        public Builder(int duration) {
            this.duration = duration;
        }

        public Builder setHPRegen(int hpRegen, int hpRegenPercent) {
            if (hpRegen != 0) {
                this.effects.put((class_1320)ModAttributes.HEALTHGAIN.get(), Double.valueOf(hpRegen));
            }
            if (hpRegenPercent != 0) {
                this.effectsPercentage.put((class_1320)ModAttributes.HEALTHGAIN.get(), Double.valueOf(hpRegenPercent));
            }
            return this;
        }

        public Builder setRPRegen(int rpRegen, int rpRegenPercent) {
            if (rpRegen != 0) {
                this.effects.put((class_1320)ModAttributes.RPGAIN.get(), Double.valueOf(rpRegen));
            }
            if (rpRegenPercent != 0) {
                this.effectsPercentage.put((class_1320)ModAttributes.RPGAIN.get(), Double.valueOf(rpRegenPercent));
            }
            return this;
        }

        public Builder setRPIncrease(int increase, int percentIncrease) {
            if (increase != 0) {
                this.effects.put((class_1320)ModAttributes.RPINCREASE.get(), Double.valueOf(increase));
            }
            if (percentIncrease != 0) {
                this.effectsPercentage.put((class_1320)ModAttributes.RPINCREASE.get(), Double.valueOf(percentIncrease));
            }
            return this;
        }

        public Builder addEffect(class_1320 att, double value) {
            this.effects.put(att, value);
            return this;
        }

        public Builder addEffectPercentage(class_1320 att, double value) {
            this.effectsPercentage.put(att, value);
            return this;
        }

        public Builder addCookingBonus(class_1320 att, double value) {
            this.cookingBonus.put(att, value);
            return this;
        }

        public Builder addCookingBonusPercent(class_1320 att, double value) {
            this.cookingBonusPercent.put(att, value);
            return this;
        }

        public Builder addPotion(class_1291 effect, int duration, int amplifier) {
            this.potionApply.add(new SimpleEffect(effect, duration, amplifier));
            return this;
        }

        public Builder curePotion(class_1291 effect) {
            this.potionRemove.add(effect);
            return this;
        }

        public FoodProperties build() {
            return new FoodProperties(this.duration, this.effects, this.effectsPercentage, this.cookingBonus, this.cookingBonusPercent, this.potionApply, this.potionRemove);
        }
    }
}

