/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2048;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;

public record GateSpawnData(class_2960 entity, int minDistanceFromSpawn, int minGateLevel, boolean canSpawnInWater, Map<class_6862<class_1959>, Integer> biomes, Map<class_2960, Integer> structures, class_2048 gatePredicate, class_2048 playerPredicate) {
    public static final Codec<GateSpawnData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_6862.method_40090((class_5321)class_2378.field_25114), (Codec)class_5699.field_33442).fieldOf("biomes").forGetter(GateSpawnData::biomes), (App)Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)class_5699.field_33442).fieldOf("structures").forGetter(GateSpawnData::structures), (App)CodecHelper.ENTITY_PREDICATE_CODEC.optionalFieldOf("gate_predicate").forGetter(d -> Optional.ofNullable(d.gatePredicate == class_2048.field_9599 ? null : d.gatePredicate)), (App)CodecHelper.ENTITY_PREDICATE_CODEC.optionalFieldOf("player_predicate").forGetter(d -> Optional.ofNullable(d.playerPredicate == class_2048.field_9599 ? null : d.playerPredicate)), (App)class_2960.field_25139.fieldOf("entity").forGetter(GateSpawnData::entity), (App)class_5699.field_33441.fieldOf("min_distance_from_spawn").orElse((Object)0).forGetter(GateSpawnData::minDistanceFromSpawn), (App)class_5699.field_33441.fieldOf("min_gate_level").orElse((Object)0).forGetter(GateSpawnData::minGateLevel), (App)Codec.BOOL.fieldOf("allow_underwater").forGetter(GateSpawnData::canSpawnInWater)).apply((Applicative)instance, (biomes, structures, gatePredicate, playerPredicate, entity, dist, lvl, underwater) -> new GateSpawnData((class_2960)entity, (int)dist, (int)lvl, (boolean)underwater, (Map<class_6862<class_1959>, Integer>)biomes, (Map<class_2960, Integer>)structures, gatePredicate.orElse(class_2048.field_9599), playerPredicate.orElse(class_2048.field_9599))));

    public static class Builder {
        private final Map<class_6862<class_1959>, Integer> biomes = new LinkedHashMap<class_6862<class_1959>, Integer>();
        private final Map<class_2960, Integer> structures = new LinkedHashMap<class_2960, Integer>();
        private final int minDistanceFromSpawn;
        private final int minGateLevel;
        private boolean allowUnderwater;
        private class_2048 gatePredicate;
        private class_2048 playerPredicate;

        public Builder(int minDistanceFromSpawn, int minGateLevel) {
            this.minDistanceFromSpawn = minDistanceFromSpawn;
            this.minGateLevel = minGateLevel;
        }

        @SafeVarargs
        public final Builder addToBiomeTag(int weight, class_6862<class_1959> ... biomes) {
            for (class_6862<class_1959> tag : biomes) {
                this.biomes.put(tag, weight);
            }
            return this;
        }

        public Builder addToStructures(int weight, class_2960 ... structures) {
            for (class_2960 s : structures) {
                this.structures.put(s, weight);
            }
            return this;
        }

        public Builder canSpawnUnderwater() {
            this.allowUnderwater = true;
            return this;
        }

        public Builder withGatePredicate(class_2048.class_2049 builder) {
            this.gatePredicate = builder.method_8920();
            return this;
        }

        public Builder withPlayerPredicate(class_2048.class_2049 builder) {
            this.playerPredicate = builder.method_8920();
            return this;
        }

        public GateSpawnData build(class_2960 name) {
            return new GateSpawnData(name, this.minDistanceFromSpawn, this.minGateLevel, this.allowUnderwater, this.biomes, this.structures, this.gatePredicate, this.playerPredicate);
        }
    }
}

