/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.lib.LibAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModArmorEffects;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import io.github.flemmli97.tenshilib.common.utils.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.class_124;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;

public class ItemStat {
    public static boolean SHOW_STATS_CUSTOM = true;
    public static final Codec<ItemStat> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.registryCodec(ModSpells.SPELL_REGISTRY_KEY).optionalFieldOf("tier_3_Spell").forGetter(s -> Optional.ofNullable(s.getTier3Spell())), (App)CodecUtils.registryCodec(ModArmorEffects.ARMOR_EFFECT_KEY).optionalFieldOf("armor_effect").forGetter(s -> Optional.ofNullable(s.getArmorEffect())), (App)CodecUtils.stringEnumCodec(EnumElement.class, (Enum)EnumElement.NONE).orElse((Object)EnumElement.NONE).fieldOf("element").forGetter(ItemStat::element), (App)CodecUtils.registryCodec(ModSpells.SPELL_REGISTRY_KEY).optionalFieldOf("tier_1_Spell").forGetter(s -> Optional.ofNullable(s.getTier1Spell())), (App)CodecUtils.registryCodec(ModSpells.SPELL_REGISTRY_KEY).optionalFieldOf("tier_2_Spell").forGetter(s -> Optional.ofNullable(s.getTier2Spell())), (App)Codec.unboundedMap((Codec)class_2378.field_23781.method_39673(), (Codec)Codec.DOUBLE).fieldOf("item_stats").forGetter(ItemStat::itemStats), (App)Codec.unboundedMap((Codec)class_2378.field_23781.method_39673(), (Codec)Codec.DOUBLE).fieldOf("monster_bonus").forGetter(ItemStat::getMonsterGiftIncrease), (App)class_5699.field_33441.fieldOf("buy_price").forGetter(ItemStat::getBuy), (App)class_5699.field_33441.fieldOf("sell_price").forGetter(ItemStat::getSell), (App)class_5699.field_33441.fieldOf("upgrade_difficulty").forGetter(ItemStat::getDiff)).apply((Applicative)instance, (spell3, armorEffect, element, spell, spell2, atts, monster, buy, sell, upgrade) -> new ItemStat((int)buy, (int)sell, (int)upgrade, (EnumElement)((Object)((Object)element)), spell.orElse(null), spell2.orElse(null), spell3.orElse(null), armorEffect.orElse(null), (Map<class_1320, Double>)atts, (Map<class_1320, Double>)monster)));
    private static final Set<class_2960> PERCENT_ATTRIBUTES = Sets.newHashSet((Object[])new class_2960[]{LibAttributes.PARA, LibAttributes.POISON, LibAttributes.SEAL, LibAttributes.SLEEP, LibAttributes.FATIGUE, LibAttributes.COLD, LibAttributes.CRIT, LibAttributes.STUN, LibAttributes.FAINT, LibAttributes.DRAIN, LibAttributes.KNOCK, LibAttributes.RES_WATER, LibAttributes.RES_EARTH, LibAttributes.RES_WIND, LibAttributes.RES_FIRE, LibAttributes.RES_DARK, LibAttributes.RES_LIGHT, LibAttributes.RES_LOVE, LibAttributes.RES_PARA, LibAttributes.RES_POISON, LibAttributes.RES_SEAL, LibAttributes.RES_SLEEP, LibAttributes.RES_FATIGUE, LibAttributes.RES_COLD, LibAttributes.RES_CRIT, LibAttributes.RES_STUN, LibAttributes.RES_FAINT, LibAttributes.RES_DRAIN, LibAttributes.RES_KNOCK});
    private static final Set<class_2960> IGNORED = Sets.newHashSet((Object[])new class_2960[]{LibAttributes.ATTACK_SPEED, LibAttributes.ATTACK_RANGE, LibAttributes.HEALTH_GAIN, LibAttributes.RP_GAIN});
    private final Map<class_1320, Double> itemStats;
    private Map<class_1320, Double> monsterGiftIncrease = Map.of();
    private int buyPrice;
    private int sellPrice;
    private int upgradeDifficulty;
    private EnumElement element = EnumElement.NONE;
    private Spell tier1Spell;
    private Spell tier2Spell;
    private Spell tier3Spell;
    private ArmorEffect armorEffect;
    private transient class_2960 id;

    private ItemStat() {
        this.itemStats = new HashMap<class_1320, Double>();
    }

    private ItemStat(int buyPrice, int sellPrice, int upgradeDifficulty, EnumElement element, Spell tier1Spell, Spell tier2Spell, Spell tier3Spell, ArmorEffect effect, Map<class_1320, Double> itemStats, Map<class_1320, Double> monsterGiftIncrease) {
        this.itemStats = itemStats;
        this.buyPrice = buyPrice;
        this.sellPrice = sellPrice;
        this.upgradeDifficulty = upgradeDifficulty;
        this.element = element;
        this.tier1Spell = tier1Spell;
        this.tier2Spell = tier2Spell;
        this.tier3Spell = tier3Spell;
        this.armorEffect = effect;
        this.monsterGiftIncrease = ImmutableSortedMap.copyOf(monsterGiftIncrease, ModAttributes.SORTED);
    }

    public static ItemStat fromPacket(class_2540 buffer) {
        ItemStat stat = new ItemStat();
        stat.id = buffer.method_10810();
        stat.buyPrice = buffer.readInt();
        stat.sellPrice = buffer.readInt();
        stat.upgradeDifficulty = buffer.readInt();
        stat.element = (EnumElement)buffer.method_10818(EnumElement.class);
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            stat.itemStats.put((class_1320)class_2378.field_23781.method_10223(buffer.method_10810()), buffer.readDouble());
        }
        size = buffer.readInt();
        ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder(ModAttributes.SORTED);
        for (int i = 0; i < size; ++i) {
            builder.put((Object)((class_1320)class_2378.field_23781.method_10223(buffer.method_10810())), (Object)buffer.readDouble());
        }
        stat.monsterGiftIncrease = builder.build();
        if (buffer.readBoolean()) {
            stat.tier1Spell = (Spell)((Object)ModSpells.SPELL_REGISTRY.get().getFromId(buffer.method_10810()));
        }
        if (buffer.readBoolean()) {
            stat.tier2Spell = (Spell)((Object)ModSpells.SPELL_REGISTRY.get().getFromId(buffer.method_10810()));
        }
        if (buffer.readBoolean()) {
            stat.tier3Spell = (Spell)((Object)ModSpells.SPELL_REGISTRY.get().getFromId(buffer.method_10810()));
        }
        if (buffer.readBoolean()) {
            stat.armorEffect = (ArmorEffect)((Object)ModArmorEffects.ARMOR_EFFECT_REGISTRY.get().getFromId(buffer.method_10810()));
        }
        return stat;
    }

    public void setID(class_2960 id) {
        if (this.id == null) {
            this.id = id;
        }
    }

    public class_2960 getId() {
        return this.id;
    }

    public int getBuy() {
        return this.buyPrice;
    }

    public int getSell() {
        return this.sellPrice;
    }

    public int getDiff() {
        return this.upgradeDifficulty;
    }

    public EnumElement element() {
        return this.element;
    }

    public Map<class_1320, Double> itemStats() {
        TreeMap<class_1320, Double> map = new TreeMap<class_1320, Double>(ModAttributes.SORTED);
        map.putAll(this.itemStats);
        return map;
    }

    public Map<class_1320, Double> getMonsterGiftIncrease() {
        return this.monsterGiftIncrease;
    }

    @Nullable
    public Spell getTier1Spell() {
        return this.tier1Spell;
    }

    @Nullable
    public Spell getTier2Spell() {
        return this.tier2Spell;
    }

    @Nullable
    public Spell getTier3Spell() {
        return this.tier3Spell;
    }

    @Nullable
    public ArmorEffect getArmorEffect() {
        return this.armorEffect;
    }

    public void toPacket(class_2540 buffer) {
        buffer.method_10812(this.id);
        buffer.writeInt(this.buyPrice);
        buffer.writeInt(this.sellPrice);
        buffer.writeInt(this.upgradeDifficulty);
        buffer.method_10817((Enum)this.element);
        buffer.writeInt(this.itemStats.size());
        this.itemStats.forEach((att, val) -> {
            buffer.method_10812(class_2378.field_23781.method_10221(att));
            buffer.writeDouble(val.doubleValue());
        });
        buffer.writeInt(this.monsterGiftIncrease.size());
        this.monsterGiftIncrease.forEach((att, val) -> {
            buffer.method_10812(class_2378.field_23781.method_10221(att));
            buffer.writeDouble(val.doubleValue());
        });
        buffer.writeBoolean(this.tier1Spell != null);
        if (this.tier1Spell != null) {
            buffer.method_10812(this.tier1Spell.getRegistryName());
        }
        buffer.writeBoolean(this.tier2Spell != null);
        if (this.tier2Spell != null) {
            buffer.method_10812(this.tier2Spell.getRegistryName());
        }
        buffer.writeBoolean(this.tier3Spell != null);
        if (this.tier3Spell != null) {
            buffer.method_10812(this.tier3Spell.getRegistryName());
        }
        buffer.writeBoolean(this.armorEffect != null);
        if (this.armorEffect != null) {
            buffer.method_10812(this.armorEffect.getRegistryName());
        }
    }

    public List<class_2561> texts(class_1799 stack, boolean showStat) {
        AttributeMapDisplay stats;
        List<class_2561> statsTooltip;
        boolean shouldHaveStats;
        class_2588 price;
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        class_2588 class_25882 = price = ItemNBT.shouldHaveLevel(stack) ? new class_2588("runecraftory.tooltip.item.level", new Object[]{ItemNBT.itemLevel(stack)}) : null;
        if (ItemUtils.getBuyPrice(stack, this) > 0) {
            if (price == null) {
                price = new class_2588("runecraftory.tooltip.item.buy", new Object[]{ItemUtils.getBuyPrice(stack, this)});
            } else {
                price.method_27693(" ").method_10852((class_2561)new class_2588("runecraftory.tooltip.item.buy", new Object[]{ItemUtils.getBuyPrice(stack, this)})).method_27693(" ");
            }
        }
        if (ItemUtils.getSellPrice(stack, this) > 0) {
            if (price == null) {
                price = new class_2588("runecraftory.tooltip.item.sell", new Object[]{ItemUtils.getSellPrice(stack, this)});
            } else {
                price.method_27693(" ").method_10852((class_2561)new class_2588("runecraftory.tooltip.item.sell", new Object[]{ItemUtils.getSellPrice(stack, this)}));
            }
        }
        if (price != null) {
            list.add((class_2561)price.method_27692(class_124.field_1054));
        }
        if (!(shouldHaveStats = ItemNBT.shouldHaveStats(stack)) && this.getDiff() > 0) {
            list.add((class_2561)new class_2588("runecraftory.tooltip.item.difficulty", new Object[]{this.getDiff()}).method_27692(class_124.field_1054));
        }
        if (showStat && !(statsTooltip = (stats = ItemStat.getStatsAttributeMap(stack)).components()).isEmpty()) {
            String prefix = shouldHaveStats ? "runecraftory.tooltip.item.equipped" : "runecraftory.tooltip.item.upgrade";
            list.add((class_2561)new class_2588(prefix).method_27692(class_124.field_1080));
            list.addAll(statsTooltip);
        }
        return list;
    }

    private static AttributeMapDisplay getStatsAttributeMap(class_1799 stack) {
        if (!ItemNBT.shouldHaveStats(stack)) {
            return DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).map(s -> new AttributeMapDisplay(s.itemStats, null)).orElse(new AttributeMapDisplay(null, null));
        }
        if (!SHOW_STATS_CUSTOM) {
            return new AttributeMapDisplay(null, null);
        }
        TreeMap<class_1320, AttributeValues> map = new TreeMap<class_1320, AttributeValues>(ModAttributes.SORTED);
        Multimap multimap = stack.method_7926(ItemUtils.slotOf(stack));
        multimap.forEach((att, mod) -> map.compute((class_1320)att, (key, old) -> old == null ? AttributeValues.of(mod) : old.add((class_1322)mod)));
        return new AttributeMapDisplay(null, map);
    }

    public String toString() {
        String s = "[Buy:" + this.buyPrice + ";Sell:" + this.sellPrice + ";UpgradeDifficulty:" + this.upgradeDifficulty + ";DefaultElement:" + String.valueOf((Object)this.element) + "];{stats:[" + MapUtils.toString(this.itemStats, reg -> class_2378.field_23781.method_10221(reg).toString(), Object::toString) + "]}";
        if (this.id != null) {
            s = String.valueOf(this.id) + ":" + s;
        }
        return s;
    }

    record AttributeMapDisplay(Map<class_1320, Double> flat, Map<class_1320, AttributeValues> ext) {
        private List<class_2561> components() {
            ArrayList<class_2561> list;
            block5: {
                block4: {
                    list = new ArrayList<class_2561>();
                    if (this.flat == null) break block4;
                    for (Map.Entry<class_1320, Double> entry : this.flat.entrySet()) {
                        double d;
                        String num;
                        class_2960 key = class_2378.field_23781.method_10221((Object)entry.getKey());
                        if (IGNORED.contains(key) || (num = AttributeMapDisplay.format(key, d = entry.getKey().equals(class_5134.field_23718) ? entry.getValue() * 10.0 : entry.getValue(), false)) == null) continue;
                        class_5250 comp = new class_2585(" ").method_10852((class_2561)new class_2588(entry.getKey().method_26830())).method_10852((class_2561)new class_2585(": " + num));
                        list.add((class_2561)comp.method_27692(class_124.field_1078));
                    }
                    break block5;
                }
                if (this.ext == null) break block5;
                for (Map.Entry<class_1320, AttributeValues> entry : this.ext.entrySet()) {
                    String num;
                    class_5250 comp;
                    class_2960 key = class_2378.field_23781.method_10221((Object)entry.getKey());
                    if (IGNORED.contains(key)) continue;
                    if (entry.getValue().flat != 0.0) {
                        double d = entry.getKey().equals(class_5134.field_23718) ? entry.getValue().flat * 10.0 : entry.getValue().flat;
                        String num2 = AttributeMapDisplay.format(key, d, false);
                        if (num2 == null) continue;
                        class_5250 comp2 = new class_2585(" ").method_10852((class_2561)new class_2588(entry.getKey().method_26830())).method_10852((class_2561)new class_2585(": " + num2));
                        list.add((class_2561)comp2.method_27692(class_124.field_1078));
                    }
                    if (entry.getValue().multBase != 0.0) {
                        String num3 = AttributeMapDisplay.format(key, entry.getValue().multBase, true);
                        if (num3 == null) continue;
                        comp = new class_2585(" ").method_10852((class_2561)new class_2588(entry.getKey().method_26830())).method_10852((class_2561)new class_2585(": " + num3));
                        list.add((class_2561)comp.method_27692(class_124.field_1078));
                    }
                    if (entry.getValue().multTotal == 0.0 || (num = AttributeMapDisplay.format(key, entry.getValue().multTotal, true)) == null) continue;
                    comp = new class_2585(" ").method_10852((class_2561)new class_2588(entry.getKey().method_26830())).method_10852((class_2561)new class_2585(": " + num));
                    list.add((class_2561)comp.method_27692(class_124.field_1078));
                }
            }
            return list;
        }

        private static String format(class_2960 att, double n, boolean percentage) {
            double val;
            String sign;
            String string = n > 0.0 ? (percentage ? "x" : "+") : (sign = "");
            if (att.equals((Object)LibAttributes.MOVEMENT_SPEED)) {
                double val2;
                double d = val2 = percentage ? n : (double)((int)(n * 100.0)) / 100.0;
                if (val2 == 0.0) {
                    return null;
                }
                return sign + class_1799.field_8029.format(val2);
            }
            boolean percSign = PERCENT_ATTRIBUTES.contains(att);
            double d = val = percentage ? n : (double)((float)((int)(n * 2.0)) * 0.5f);
            if (val == 0.0) {
                return null;
            }
            return sign + class_1799.field_8029.format(val) + (percSign ? "%" : "");
        }
    }

    private static class AttributeValues {
        private double flat;
        private double multBase;
        private double multTotal;

        private AttributeValues(double flat, double multBase, double multTotal) {
            this.flat = flat;
            this.multBase = multBase;
            this.multTotal = multTotal;
        }

        private static AttributeValues of(class_1322 mod) {
            return switch (mod.method_6182()) {
                default -> throw new IncompatibleClassChangeError();
                case class_1322.class_1323.field_6328 -> new AttributeValues(mod.method_6186(), 0.0, 0.0);
                case class_1322.class_1323.field_6330 -> new AttributeValues(0.0, mod.method_6186(), 0.0);
                case class_1322.class_1323.field_6331 -> new AttributeValues(0.0, 0.0, mod.method_6186());
            };
        }

        private AttributeValues add(class_1322 mod) {
            switch (mod.method_6182()) {
                case field_6328: {
                    this.flat += mod.method_6186();
                    break;
                }
                case field_6330: {
                    this.multBase += mod.method_6186();
                    break;
                }
                case field_6331: {
                    this.multTotal += mod.method_6186();
                }
            }
            return this;
        }
    }

    public static class Builder {
        private final Map<class_1320, Double> itemStats = new HashMap<class_1320, Double>();
        private final Map<class_1320, Double> monsterGiftIncrease = new HashMap<class_1320, Double>();
        public final int buyPrice;
        public final int sellPrice;
        public final int upgradeDifficulty;
        private EnumElement element = EnumElement.NONE;
        private Spell tier1Spell;
        private Spell tier2Spell;
        private Spell tier3Spell;
        private ArmorEffect armorEffect;

        public Builder(int buy, int sell, int upgrade) {
            this.buyPrice = buy;
            this.sellPrice = sell;
            this.upgradeDifficulty = upgrade;
        }

        public Builder setElement(EnumElement element) {
            this.element = element;
            return this;
        }

        public Builder addAttribute(class_1320 att, double value) {
            this.itemStats.put(att, value);
            return this;
        }

        public Builder addMonsterStat(class_1320 att, double value) {
            this.monsterGiftIncrease.put(att, value);
            return this;
        }

        public Builder setSpell(Spell tier1, Spell tier2, Spell tier3) {
            this.tier1Spell = tier1;
            this.tier2Spell = tier2;
            this.tier3Spell = tier3;
            return this;
        }

        public Builder withArmorEffect(ArmorEffect effect) {
            this.armorEffect = effect;
            return this;
        }

        public ItemStat build() {
            return new ItemStat(this.buyPrice, this.sellPrice, this.upgradeDifficulty, this.element, this.tier1Spell, this.tier2Spell, this.tier3Spell, this.armorEffect, this.itemStats, this.monsterGiftIncrease);
        }
    }
}

