/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import io.github.flemmli97.runecraftory.common.utils.MiscUtils;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2048;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public record ShopItemProperties(class_1799 stack, UnlockType unlockType, class_2048 predicate) {
    public static final Codec<class_6862<class_1792>> TAG_CODEC = Codec.STRING.flatXmap(r -> {
        if (r.startsWith("#")) {
            return DataResult.success((Object)class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960(r.substring(1))));
        }
        return DataResult.error((String)("Not a tag value" + r));
    }, l -> DataResult.success((Object)("#" + String.valueOf(l.comp_327()))));
    public static final Codec<MultiItemValue> MULTI_ITEM_VALUE_CODEC = Codec.either(TAG_CODEC, CodecHelper.listOrSingle(CodecHelper.ITEM_OR_STACK)).xmap(MultiItemValue::new, v -> v.tag != null ? Either.left(v.tag) : Either.right(v.items));
    public static final Codec<IntermediaryShopItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MULTI_ITEM_VALUE_CODEC.fieldOf("item").forGetter(d -> d.items), (App)CodecUtils.stringEnumCodec(UnlockType.class, null).fieldOf("unlock_type").forGetter(d -> d.unlockType), (App)CodecHelper.ENTITY_PREDICATE_CODEC.optionalFieldOf("predicate").forGetter(d -> Optional.ofNullable(d.predicate == class_2048.field_9599 ? null : d.predicate))).apply((Applicative)instance, (stack, type, adv) -> new IntermediaryShopItem((MultiItemValue)stack, (UnlockType)((Object)((Object)type)), adv.orElse(class_2048.field_9599))));

    public static List<ShopItemProperties> from(IntermediaryShopItem item) {
        ArrayList<ShopItemProperties> list = new ArrayList<ShopItemProperties>();
        item.items().getContents().forEach(stack -> list.add(new ShopItemProperties((class_1799)stack, item.unlockType, item.predicate)));
        return list;
    }

    public static enum UnlockType {
        DEFAULT,
        ALWAYS,
        NEEDS_SHIPPING;

    }

    public record IntermediaryShopItem(MultiItemValue items, UnlockType unlockType, class_2048 predicate) {
        public IntermediaryShopItem(MultiItemValue items, UnlockType unlockType) {
            this(items, unlockType, class_2048.field_9599);
        }

        public boolean isTag() {
            return this.items.tag != null;
        }
    }

    public static class MultiItemValue {
        private final class_6862<class_1792> tag;
        private final List<class_1799> items;

        private MultiItemValue(Either<class_6862<class_1792>, List<class_1799>> either) {
            this.tag = either.left().orElse(null);
            this.items = either.right().orElse(null);
        }

        public MultiItemValue(class_6862<class_1792> tag) {
            this.tag = tag;
            this.items = null;
        }

        public MultiItemValue(List<class_1799> list) {
            this.tag = null;
            this.items = list;
        }

        public static MultiItemValue of(class_1792 ... item) {
            return new MultiItemValue(Arrays.stream(item).map(class_1799::new).toList());
        }

        public List<class_1799> getContents() {
            if (this.tag != null) {
                return MiscUtils.expandTag(class_2378.field_11142, this.tag, class_1799::new);
            }
            return this.items;
        }
    }
}

