/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_5699;

public class SpellProperties {
    public final Map<EnumSkills, Float> skillXP;
    public final int cooldown;
    public final int rpCost;
    public final float percentage;
    public final Set<EnumSkills> skills;
    public static final Codec<SpellProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("percentage").forGetter(d -> Float.valueOf(d.percentage)), (App)CodecUtils.stringEnumCodec(EnumSkills.class, null).listOf().optionalFieldOf("skills").forGetter(d -> d.skills.isEmpty() ? Optional.empty() : Optional.of(List.copyOf(d.skills))), (App)class_5699.field_33441.fieldOf("cooldown").forGetter(d -> d.cooldown), (App)Codec.INT.fieldOf("rp_cost").forGetter(d -> d.rpCost), (App)Codec.unboundedMap((Codec)CodecUtils.stringEnumCodec(EnumSkills.class, null), (Codec)Codec.FLOAT).fieldOf("skill_xp").forGetter(d -> d.skillXP)).apply((Applicative)instance, (percentage, skills, cooldown, rpCost, skillXp) -> new SpellProperties((Map<EnumSkills, Float>)skillXp, (int)cooldown, (int)rpCost, percentage.floatValue(), skills.orElse(List.of()))));
    public static final SpellProperties DEFAULT_PROP = new SpellProperties(new EnumMap<EnumSkills, Float>(EnumSkills.class), 20, 0, 0.0f, List.of());

    public SpellProperties(Map<EnumSkills, Float> skillXP, int cooldown, int rpCost, float percentage, List<EnumSkills> skills) {
        this.percentage = percentage;
        EnumSet<EnumSkills> reducingSkills = skills.isEmpty() ? EnumSet.noneOf(EnumSkills.class) : EnumSet.copyOf(skills);
        this.skills = Collections.unmodifiableSet(reducingSkills);
        EnumMap<EnumSkills, Float> xp = new EnumMap<EnumSkills, Float>(EnumSkills.class);
        xp.putAll(skillXP);
        this.skillXP = Collections.unmodifiableMap(xp);
        this.cooldown = cooldown;
        this.rpCost = rpCost;
    }

    public static class Builder {
        private final Map<EnumSkills, Float> xp = new EnumMap<EnumSkills, Float>(EnumSkills.class);
        private final int cooldown;
        private final int rpCost;
        private float percentage;
        private final List<EnumSkills> skills = new ArrayList<EnumSkills>();

        public Builder(int cooldown, int rpCost) {
            this.cooldown = cooldown;
            this.rpCost = rpCost;
        }

        public Builder withXPGain(EnumSkills skill, float gain) {
            this.xp.put(skill, Float.valueOf(gain));
            return this;
        }

        public Builder percentageCost(float cost) {
            this.percentage = cost;
            return this;
        }

        public Builder affectedSkill(EnumSkills skill) {
            this.skills.add(skill);
            return this;
        }

        public SpellProperties build() {
            return new SpellProperties(this.xp, this.cooldown, this.rpCost, this.percentage, this.skills);
        }
    }
}

