/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FoodProvider
implements class_2405 {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<class_2960, FoodProperties.Builder> data = new HashMap<class_2960, FoodProperties.Builder>();
    private final Map<class_2960, Consumer<JsonObject>> item = new HashMap<class_2960, Consumer<JsonObject>>();
    private final class_2403 gen;
    private final String modid;

    public FoodProvider(class_2403 gen, String modid) {
        this.gen = gen;
        this.modid = modid;
    }

    protected abstract void add();

    public void method_10319(class_2408 cache) {
        this.add();
        this.data.forEach((res, builder) -> {
            Path path = this.gen.method_10313().resolve("data/" + res.method_12836() + "/food_stats/" + res.method_12832() + ".json");
            try {
                JsonElement obj = (JsonElement)FoodProperties.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)builder.build()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                if (obj.isJsonObject()) {
                    this.item.get(res).accept(obj.getAsJsonObject());
                }
                class_2405.method_10320((Gson)GsonInstances.GSON, (class_2408)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save food properties {}", (Object)path, (Object)e);
            }
        });
    }

    public String method_10321() {
        return "FoodProps";
    }

    public void addStat(class_1935 item, int duration) {
        this.addStat(item, new FoodProperties.Builder(duration));
    }

    public void addStat(String id, class_1935 item, int duration) {
        this.addStat(id, item, new FoodProperties.Builder(duration));
    }

    public void addStat(class_1935 item, FoodProperties.Builder builder) {
        this.addStat(class_2378.field_11142.method_10221((Object)item.method_8389()).method_12832(), item, builder);
    }

    public void addStat(String id, class_1935 item, FoodProperties.Builder builder) {
        class_2960 res = new class_2960(this.modid, id);
        this.data.put(res, builder);
        this.item.put(res, obj -> obj.addProperty("item", class_2378.field_11142.method_10221((Object)item.method_8389()).toString()));
    }

    public void addStat(String id, class_6862<class_1792> tag, int duration) {
        this.addStat(id, tag, new FoodProperties.Builder(duration));
    }

    public void addStat(String id, class_6862<class_1792> tag, FoodProperties.Builder builder) {
        class_2960 res = new class_2960(this.modid, id);
        this.data.put(res, builder);
        this.item.put(res, obj -> obj.addProperty("item", "#" + String.valueOf(tag.comp_327())));
    }
}

