/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ItemStatProvider
implements class_2405 {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<class_2960, ItemStat.Builder> data = new HashMap<class_2960, ItemStat.Builder>();
    private final Map<class_2960, Consumer<JsonObject>> item = new HashMap<class_2960, Consumer<JsonObject>>();
    private final class_2403 gen;
    private final String modid;

    public ItemStatProvider(class_2403 gen, String modid) {
        this.gen = gen;
        this.modid = modid;
    }

    protected abstract void add();

    public void method_10319(class_2408 cache) {
        this.add();
        this.data.forEach((res, builder) -> {
            Path path = this.gen.method_10313().resolve("data/" + res.method_12836() + "/item_stats/" + res.method_12832() + ".json");
            try {
                JsonElement obj = (JsonElement)ItemStat.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)builder.build()).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                if (obj.isJsonObject()) {
                    this.item.get(res).accept(obj.getAsJsonObject());
                }
                class_2405.method_10320((Gson)GsonInstances.GSON, (class_2408)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save itemstat {}", (Object)path, (Object)e);
            }
        });
    }

    public String method_10321() {
        return "ItemStats";
    }

    public void addStat(class_1935 item, int buy, int sell, int upgrade) {
        this.addStat(item, new ItemStat.Builder(buy, sell, upgrade));
    }

    public void addStat(String id, class_1935 item, int buy, int sell, int upgrade) {
        this.addStat(id, item, new ItemStat.Builder(buy, sell, upgrade));
    }

    public void addStat(class_1935 item, ItemStat.Builder builder) {
        this.addStat(class_2378.field_11142.method_10221((Object)item.method_8389()).method_12832(), item, builder);
    }

    public void addStat(String id, class_1935 item, ItemStat.Builder builder) {
        class_2960 res = new class_2960(this.modid, id);
        this.data.put(res, builder);
        this.item.put(res, obj -> obj.addProperty("item", class_2378.field_11142.method_10221((Object)item.method_8389()).toString()));
    }

    public void addStat(String id, class_6862<class_1792> tag, int buy, int sell, int upgrade) {
        this.addStat(id, tag, new ItemStat.Builder(buy, sell, upgrade));
    }

    public void addStat(String id, class_6862<class_1792> tag, ItemStat.Builder builder) {
        class_2960 res = new class_2960(this.modid, id);
        this.data.put(res, builder);
        this.item.put(res, obj -> obj.addProperty("item", "#" + String.valueOf(tag.comp_327())));
    }

    protected int calcBuyOf(double multiplier, class_1935 ... others) {
        return this.calcValueOf(multiplier, b -> b.buyPrice, (class_2960[])Stream.of(others).map(other -> new class_2960(this.modid, class_2378.field_11142.method_10221((Object)other.method_8389()).method_12832())).toArray(class_2960[]::new));
    }

    protected int calcSellOf(double multiplier, class_1935 ... others) {
        return this.calcValueOf(multiplier, b -> b.sellPrice, (class_2960[])Stream.of(others).map(other -> new class_2960(this.modid, class_2378.field_11142.method_10221((Object)other.method_8389()).method_12832())).toArray(class_2960[]::new));
    }

    protected int calcValueOf(double multiplier, ToIntFunction<ItemStat.Builder> agg, class_2960 ... others) {
        int price = 0;
        for (class_2960 other : others) {
            ItemStat.Builder s = this.data.get(other);
            if (s == null) continue;
            price += agg.applyAsInt(s);
        }
        return (int)((double)price * multiplier);
    }

    public static int truncate(double value) {
        if (value < 10.0) {
            return (int)value;
        }
        return (int)(value / 10.0) * 10;
    }
}

