/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.api.datapack.ConversationContext;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.api.datapack.npc.ConversationSet;
import io.github.flemmli97.runecraftory.api.datapack.npc.GiftData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCLook;
import io.github.flemmli97.runecraftory.api.datapack.provider.AdditionalLanguages;
import io.github.flemmli97.runecraftory.api.datapack.provider.FileVerifier;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.actions.NPCAttackActions;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class NPCDataProvider
implements class_2405,
AdditionalLanguages {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<class_2960, NPCLook> looks = new HashMap<class_2960, NPCLook>();
    private final Map<class_2960, ConversationSet> conversations = new HashMap<class_2960, ConversationSet>();
    private final Map<class_2960, GiftData> giftData = new LinkedHashMap<class_2960, GiftData>();
    private final Map<class_2960, NPCAttackActions> actions = new HashMap<class_2960, NPCAttackActions>();
    private final Map<class_2960, NPCData> data = new HashMap<class_2960, NPCData>();
    public final Map<String, Map<String, String>> dialogueTranslations = new LinkedHashMap<String, Map<String, String>>();
    private final Map<String, String> translations = new LinkedHashMap<String, String>();
    private final class_2403 gen;
    private final FileVerifier verifier;
    protected final String modid;

    public NPCDataProvider(class_2403 gen, FileVerifier verifier, String modid) {
        this.gen = gen;
        this.verifier = verifier;
        this.modid = modid;
    }

    protected abstract void add();

    public void method_10319(class_2408 cache) {
        this.add();
        this.data.forEach((res, val) -> {
            Path path = this.gen.method_10313().resolve("data/" + res.method_12836() + "/npc_data/" + res.method_12832() + ".json");
            this.verifyData((NPCData)val);
            try {
                JsonElement obj = (JsonElement)NPCData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, val).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                class_2405.method_10320((Gson)GsonInstances.GSON, (class_2408)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save npc data {}", (Object)path, (Object)e);
            }
        });
        this.looks.forEach((res, val) -> {
            Path path = this.gen.method_10313().resolve("data/" + res.method_12836() + "/npc_looks/" + res.method_12832() + ".json");
            try {
                JsonElement obj = (JsonElement)NPCLook.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, val).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                class_2405.method_10320((Gson)GsonInstances.GSON, (class_2408)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save npc looks {}", (Object)path, (Object)e);
            }
        });
        this.conversations.forEach((res, val) -> {
            Path path = this.gen.method_10313().resolve("data/" + res.method_12836() + "/conversations/" + res.method_12832() + ".json");
            try {
                JsonElement obj = (JsonElement)ConversationSet.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, val).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                class_2405.method_10320((Gson)GsonInstances.GSON, (class_2408)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save npc conversations {}", (Object)path, (Object)e);
            }
        });
        this.giftData.forEach((res, val) -> {
            Path path = this.gen.method_10313().resolve("data/" + res.method_12836() + "/npc_gifts/" + res.method_12832() + ".json");
            try {
                JsonElement obj = (JsonElement)GiftData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, val).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                class_2405.method_10320((Gson)GsonInstances.GSON, (class_2408)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save gift data {}", (Object)path, (Object)e);
            }
        });
        this.actions.forEach((res, val) -> {
            Path path1 = this.gen.method_10313().resolve("data/" + res.method_12836() + "/npc_actions/" + res.method_12832() + ".json");
            try {
                JsonElement obj = (JsonElement)NPCAttackActions.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, val).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                class_2405.method_10320((Gson)GsonInstances.GSON, (class_2408)cache, (JsonElement)obj, (Path)path1);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't combat action {}", (Object)path1, (Object)e);
            }
        });
    }

    public String method_10321() {
        return "NPCData";
    }

    public void addNPCData(String id, NPCData.Builder data, Map<ConversationContext, ConversationSet.Builder> conversations, Map<class_2960, QuestResponseBuilder> questConversations) {
        conversations.forEach((key, value) -> {
            class_2960 conversationId = new class_2960(this.modid, id + "/" + key.key().method_12832());
            this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(value.getTranslations());
            this.conversations.put(conversationId, value.build());
            data.addInteractionIfAbsent((ConversationContext)key, conversationId);
        });
        questConversations.forEach((key, value) -> {
            class_2960 startId = new class_2960(this.modid, id + "/quest_start_" + key.method_12832());
            for (int i = 0; i < value.start.size(); ++i) {
                Object path = startId.method_12832();
                if (i != 0) {
                    path = (String)path + "_" + i;
                }
                class_2960 runIdI = new class_2960(this.modid, (String)path);
                this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(value.start.get(i).getTranslations());
                this.conversations.put(runIdI, value.start.get(i).build());
            }
            class_2960 runId = new class_2960(this.modid, id + "/quest_active_" + key.method_12832());
            for (int i = 0; i < value.active.size(); ++i) {
                Object path = runId.method_12832();
                if (i != 0) {
                    path = (String)path + "_" + i;
                }
                class_2960 runIdI = new class_2960(this.modid, (String)path);
                this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(value.active.get(i).getTranslations());
                this.conversations.put(runIdI, value.active.get(i).build());
            }
            class_2960 endId = new class_2960(this.modid, id + "/quest_end_" + key.method_12832());
            this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(value.end.getTranslations());
            this.conversations.put(endId, value.end.build());
            data.addQuestResponse((class_2960)key, startId, runId, endId);
        });
        this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(data.getTranslations());
        this.data.put(new class_2960(this.modid, id), data.build());
    }

    public class_2960 addLook(class_2960 id, NPCLook look) {
        if (this.looks.put(id, look) != null) {
            throw new IllegalStateException("Look already registered");
        }
        this.verifier.track(id, class_3264.field_14190, "npc_looks");
        return id;
    }

    public class_2960 addGiftData(class_2960 id, GiftData.Builder giftData) {
        if (this.giftData.put(id, giftData.build()) != null) {
            throw new IllegalStateException("GiftData already registered");
        }
        this.translations.putAll(giftData.translations);
        this.verifier.track(id, class_3264.field_14190, "npc_gifts");
        return id;
    }

    public class_2960 addAttackActions(class_2960 id, NPCAttackActions.Builder actions) {
        if (this.actions.put(id, actions.build()) != null) {
            throw new IllegalStateException("Attack action already registered");
        }
        this.verifier.track(id, class_3264.field_14190, "npc_actions");
        return id;
    }

    private void verifyData(NPCData data) {
        if (data.look() != null) {
            for (NPCData.NPCLookId look : data.look()) {
                if (this.verifier.exists(look.id(), class_3264.field_14190, "npc_looks")) continue;
                throw new IllegalStateException("No look registered for " + String.valueOf(look.id()));
            }
        }
        if (data.combatActions() != null) {
            for (class_2960 action : data.combatActions()) {
                if (this.verifier.exists(action, class_3264.field_14190, "npc_actions")) continue;
                throw new IllegalStateException("No npc action registered for " + String.valueOf(action));
            }
        }
        data.giftItems().forEach((s, g) -> {
            if (g.giftID() != null && !this.verifier.exists(g.giftID(), class_3264.field_14190, "npc_gifts")) {
                throw new IllegalStateException("No gift registered for " + String.valueOf(g.giftID()));
            }
        });
    }

    @Override
    public Map<String, String> translations() {
        return this.translations;
    }

    public record QuestResponseBuilder(List<ConversationSet.Builder> start, List<ConversationSet.Builder> active, ConversationSet.Builder end) {
        public QuestResponseBuilder(ConversationSet.Builder start, ConversationSet.Builder active, ConversationSet.Builder end) {
            this(List.of(start), List.of(active), end);
        }
    }
}

