/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.api.datapack.ShopItemProperties;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2048;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ShopItemProvider
implements class_2405 {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<class_2960, Collection<ShopItemProperties.IntermediaryShopItem>> props = new HashMap<class_2960, Collection<ShopItemProperties.IntermediaryShopItem>>();
    private final Map<class_2960, Boolean> overwrite = new HashMap<class_2960, Boolean>();
    private final class_2403 gen;

    public ShopItemProvider(class_2403 gen) {
        this.gen = gen;
    }

    protected abstract void add();

    public void method_10319(class_2408 cache) {
        this.add();
        this.props.forEach((res, builder) -> {
            Path path = this.gen.method_10313().resolve("data/" + res.method_12836() + "/shop_items/" + res.method_12832() + ".json");
            try {
                JsonObject obj = new JsonObject();
                if (this.overwrite.getOrDefault(res, false).booleanValue()) {
                    obj.addProperty("replace", Boolean.valueOf(true));
                }
                JsonArray arr = new JsonArray();
                builder.forEach(prop -> arr.add((JsonElement)ShopItemProperties.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, prop).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0))));
                obj.add("values", (JsonElement)arr);
                class_2405.method_10320((Gson)GsonInstances.GSON, (class_2408)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save itemstat {}", (Object)path, (Object)e);
            }
        });
    }

    public String method_10321() {
        return "ItemStats";
    }

    public void addItem(NPCJob shop, class_1935 item) {
        this.addItem(shop, item, ShopItemProperties.UnlockType.NEEDS_SHIPPING);
    }

    public void addItem(NPCJob shop, class_1935 item, ShopItemProperties.UnlockType unlockType) {
        this.addItem(shop, item, unlockType, class_2048.field_9599);
    }

    public void addItem(NPCJob shop, class_1935 item, ShopItemProperties.UnlockType unlockType, class_2048 predicate) {
        class_2960 res = ModNPCJobs.getIDFrom(shop);
        this.props.computeIfAbsent(new class_2960(res.method_12836(), res.method_12832()), r -> new ArrayList()).add(new ShopItemProperties.IntermediaryShopItem(ShopItemProperties.MultiItemValue.of(item.method_8389()), unlockType, predicate));
    }

    public void addItem(NPCJob shop, class_1799 item) {
        this.addItem(shop, item, ShopItemProperties.UnlockType.NEEDS_SHIPPING);
    }

    public void addItem(NPCJob shop, class_1799 item, ShopItemProperties.UnlockType unlockType) {
        this.addItem(shop, item, unlockType, class_2048.field_9599);
    }

    public void addItem(NPCJob shop, class_1799 item, ShopItemProperties.UnlockType unlockType, class_2048 predicate) {
        class_2960 res = ModNPCJobs.getIDFrom(shop);
        this.props.computeIfAbsent(new class_2960(res.method_12836(), res.method_12832()), r -> new ArrayList()).add(new ShopItemProperties.IntermediaryShopItem(new ShopItemProperties.MultiItemValue(List.of(item)), unlockType, predicate));
    }

    public void addItem(NPCJob shop, class_6862<class_1792> tag) {
        this.addItem(shop, tag, ShopItemProperties.UnlockType.NEEDS_SHIPPING);
    }

    public void addItem(NPCJob shop, class_6862<class_1792> tag, ShopItemProperties.UnlockType unlockType) {
        this.addItem(shop, tag, unlockType, class_2048.field_9599);
    }

    public void addItem(NPCJob shop, class_6862<class_1792> tag, ShopItemProperties.UnlockType unlockType, class_2048 predicate) {
        class_2960 res = ModNPCJobs.getIDFrom(shop);
        this.props.computeIfAbsent(new class_2960(res.method_12836(), res.method_12832()), r -> new ArrayList()).add(new ShopItemProperties.IntermediaryShopItem(new ShopItemProperties.MultiItemValue(tag), unlockType, predicate));
    }

    public void overwrite(NPCJob shop, boolean defaults) {
        class_2960 res = ModNPCJobs.getIDFrom(shop);
        this.overwrite.put(new class_2960(res.method_12836(), res.method_12832() + (defaults ? "_defaults" : "")), true);
    }
}

