/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.registry;

import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.platform.registry.CustomRegistryEntry;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public abstract class Spell
extends CustomRegistryEntry<Spell> {
    public static boolean tryUseWithCost(class_1309 entity, class_1799 stack, Spell spell) {
        return Spell.tryUseWithCost(entity, stack, spell, 1.0f);
    }

    public static boolean tryUseWithCost(class_1309 entity, class_1799 stack, Spell spell, float costMultiplier) {
        return Spell.tryUseWithCost(entity, stack, spell, costMultiplier, stack.method_7909() instanceof ItemStaffBase);
    }

    public static boolean tryUseWithCost(class_1309 entity, class_1799 stack, Spell spell, float costMultiplier, boolean hurt) {
        class_3222 player;
        return !(entity instanceof class_3222) || Platform.INSTANCE.getPlayerData((class_1657)(player = (class_3222)entity)).map(data -> {
            if (!LevelCalc.useRP((class_1657)player, data, (float)spell.rpCost() * costMultiplier, hurt, spell.percentageCost(), true, spell.costReductionSkills())) {
                if (!hurt) {
                    player.field_13987.method_14364((class_2596)new class_2767(class_3417.field_15008, class_3419.field_15248, player.method_19538().field_1352, player.method_19538().field_1351, player.method_19538().field_1350, 1.0f, 1.0f));
                }
                return false;
            }
            return true;
        }).orElse(false) != false;
    }

    public static void playSound(class_1309 entity, class_3414 sound, float volume, float pitch) {
        entity.field_6002.method_8465(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), sound, entity.method_5634(), volume, pitch);
    }

    public void update(class_1657 player, class_1799 stack) {
    }

    public void levelSkill(class_3222 player) {
        Map<EnumSkills, Float> skillXp = DataPackHandler.INSTANCE.spellPropertiesManager().getPropertiesFor((Spell)this).skillXP;
        if (!skillXp.isEmpty()) {
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> skillXp.forEach((skill, xp) -> LevelCalc.levelSkill(player, data, EnumSkills.DARK, xp.floatValue())));
        }
    }

    public int coolDown() {
        return DataPackHandler.INSTANCE.spellPropertiesManager().getPropertiesFor((Spell)this).cooldown;
    }

    public int rpCost() {
        return DataPackHandler.INSTANCE.spellPropertiesManager().getPropertiesFor((Spell)this).rpCost;
    }

    public float percentageCost() {
        return DataPackHandler.INSTANCE.spellPropertiesManager().getPropertiesFor((Spell)this).percentage;
    }

    public EnumSkills[] costReductionSkills() {
        return (EnumSkills[])DataPackHandler.INSTANCE.spellPropertiesManager().getPropertiesFor((Spell)this).skills.toArray(EnumSkills[]::new);
    }

    public boolean use(class_1309 entity) {
        class_1937 class_19372 = entity.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            return this.use(serverLevel, entity, class_1799.field_8037);
        }
        return false;
    }

    public boolean use(class_1309 entity, boolean ignoreSeal) {
        class_1937 class_19372 = entity.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            return this.use(serverLevel, entity, class_1799.field_8037, ignoreSeal);
        }
        return false;
    }

    public boolean use(class_3218 world, class_1309 entity, class_1799 stack) {
        return this.use(world, entity, stack, false);
    }

    public boolean use(class_3218 world, class_1309 entity, class_1799 stack, boolean ignoreSeal) {
        if (!ignoreSeal && EntityUtils.sealed(entity)) {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                player.field_13987.method_14364((class_2596)new class_2767(class_3417.field_15008, entity.method_5634(), entity.method_23317(), entity.method_23318(), entity.method_23321(), 1.0f, 0.7f));
            }
            return false;
        }
        return this.use(world, entity, stack, 1.0f, 1, CombatUtils.getSpellLevelFromStack(stack));
    }

    public abstract boolean use(class_3218 var1, class_1309 var2, class_1799 var3, float var4, int var5, int var6);

    public AttackAction useAction() {
        return (AttackAction)((Object)ModAttackActions.STAFF_USE.get());
    }

    public boolean canUse(class_3218 world, class_1309 entity, class_1799 stack) {
        return entity.method_5854() == null || this.usableOnMounts();
    }

    public boolean delayedUse() {
        return true;
    }

    public boolean usableOnMounts() {
        return this.useAction().usableOnMounts(0);
    }

    public String toString() {
        return this.getRegistryName().toString();
    }
}

