/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.client.model.ArmorSimpleItemModel;
import io.github.flemmli97.runecraftory.client.model.armor.PiyoSandals;
import io.github.flemmli97.runecraftory.client.model.armor.RingsArmorModel;
import io.github.flemmli97.runecraftory.common.items.equipment.ItemArmorBase;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_918;

public class ArmorModels {
    public static final Map<class_2960, ArmorModelGetter> ARMOR_GETTER = ArmorModels.getArmorRenderer();
    private static final Map<class_2960, FirstPersonArmorRenderer> FIRST_PERSON_GETTER = ArmorModels.getFirstPersonHandRenderer();
    private static final Map<String, class_2960> ARMOR_TEXT_CACHE = new HashMap<String, class_2960>();
    private static final ArmorSimpleItemModel ITEM_MODEL = new ArmorSimpleItemModel();
    private static PiyoSandals PIYO_SANDALS_MODEL;
    private static RingsArmorModel RINGS_MODEL;
    private static class_572<?> INNER;
    private static class_572<?> OUTER;

    private static Map<class_2960, ArmorModelGetter> getArmorRenderer() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ModItems.MAGIC_EARRINGS.getID(), (entityLiving, itemStack, slot, origin) -> {
            origin.method_2805(false);
            origin.field_3398.field_3665 = true;
            origin.field_3394.field_3665 = true;
            return null;
        });
        ArmorModelGetter bracelet = (entityLiving, itemStack, slot, origin) -> {
            class_742 clientPlayer;
            origin.method_2805(false);
            boolean right = entityLiving.method_6068() == class_1306.field_6183;
            class_630 model = right ? origin.field_3401 : origin.field_27433;
            model.field_3665 = true;
            if (entityLiving instanceof class_742 && (clientPlayer = (class_742)entityLiving).method_3121().equals("slim")) {
                model.field_3657 = (float)((double)model.field_3657 + (right ? 0.5 : -0.5));
            }
            return null;
        };
        for (RegistryEntrySupplier<class_1792> registryEntrySupplier : ArmorModels.bracelets()) {
            builder.put((Object)registryEntrySupplier.getID(), (Object)bracelet);
        }
        ArmorModelGetter normalItemModel = (entityLiving, itemStack, slot, origin) -> {
            ITEM_MODEL.setProperties(entityLiving, itemStack, origin.method_2838(), ArmorSimpleItemModel.TRANSLATE_TO_HEAD);
            return ITEM_MODEL;
        };
        for (RegistryEntrySupplier<class_1792> registryEntrySupplier : ModItems.ribbons()) {
            builder.put((Object)registryEntrySupplier.getID(), (Object)normalItemModel);
        }
        builder.put((Object)ModItems.PIYO_SANDALS.getID(), (entityLiving, itemStack, slot, origin) -> {
            origin.method_2818((class_572)PIYO_SANDALS_MODEL);
            PIYO_SANDALS_MODEL.method_2805(false);
            ArmorModels.PIYO_SANDALS_MODEL.field_3397.field_3665 = true;
            ArmorModels.PIYO_SANDALS_MODEL.field_3392.field_3665 = true;
            return PIYO_SANDALS_MODEL;
        });
        for (RegistryEntrySupplier<class_1792> registryEntrySupplier : ModItems.hatItems()) {
            builder.put((Object)registryEntrySupplier.getID(), (Object)normalItemModel);
        }
        ArmorModelGetter armorModelGetter = (entityLiving, itemStack, slot, origin) -> {
            class_742 clientPlayer;
            origin.method_2818((class_572)RINGS_MODEL);
            RINGS_MODEL.method_2805(false);
            boolean right = entityLiving.method_6068() == class_1306.field_6183;
            class_630 model = right ? ArmorModels.RINGS_MODEL.field_3401 : ArmorModels.RINGS_MODEL.field_27433;
            model.field_3665 = true;
            if (entityLiving instanceof class_742 && (clientPlayer = (class_742)entityLiving).method_3121().equals("slim")) {
                model.field_3657 = (float)((double)model.field_3657 + (right ? 0.5 : -0.5));
            }
            return RINGS_MODEL;
        };
        for (RegistryEntrySupplier<class_1792> sup : ArmorModels.rings()) {
            builder.put((Object)sup.getID(), (Object)armorModelGetter);
        }
        return builder.build();
    }

    private static Map<class_2960, FirstPersonArmorRenderer> getFirstPersonHandRenderer() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        FirstPersonArmorRenderer bracelet = (player, stack, right, origin, poseStack, buffer, light) -> {
            origin.method_2818(OUTER);
            OUTER.method_2805(false);
            class_630 model = right ? ArmorModels.OUTER.field_3401 : ArmorModels.OUTER.field_27433;
            model.field_3665 = true;
            if (player.method_3121().equals("slim")) {
                model.field_3657 = (float)((double)model.field_3657 + (right ? 0.5 : -0.5));
            }
            ArmorModels.renderModelPart(model, player, right, buffer, stack, poseStack, light);
        };
        for (RegistryEntrySupplier<class_1792> sup : ArmorModels.bracelets()) {
            builder.put((Object)sup.getID(), (Object)bracelet);
        }
        FirstPersonArmorRenderer rings = (player, stack, right, origin, poseStack, buffer, light) -> {
            origin.method_2818((class_572)RINGS_MODEL);
            RINGS_MODEL.method_2805(false);
            class_630 model = right ? ArmorModels.RINGS_MODEL.field_3401 : ArmorModels.RINGS_MODEL.field_27433;
            model.field_3665 = true;
            if (player.method_3121().equals("slim")) {
                model.field_3657 = (float)((double)model.field_3657 + (right ? 0.5 : -0.5));
            }
            ArmorModels.renderModelPart(model, player, right, buffer, stack, poseStack, light);
        };
        for (RegistryEntrySupplier<class_1792> sup : ArmorModels.rings()) {
            builder.put((Object)sup.getID(), (Object)rings);
        }
        return builder.build();
    }

    private static class_4588 forArmor(class_4597 buffer, class_1799 stack, class_1657 player) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ItemArmorBase) {
            ItemArmorBase armor = (ItemArmorBase)class_17922;
            return class_918.method_27952((class_4597)buffer, (class_1921)class_1921.method_25448((class_2960)ARMOR_TEXT_CACHE.computeIfAbsent(armor.getArmorTexture(stack, (class_1297)player, armor.method_7685(), null), class_2960::new)), (boolean)false, (boolean)stack.method_7958());
        }
        return null;
    }

    private static void renderModelPart(class_630 model, class_742 player, boolean right, class_4597 buffer, class_1799 stack, class_4587 poseStack, int light) {
        class_4588 cons = ArmorModels.forArmor(buffer, stack, (class_1657)player);
        if (cons != null) {
            model.method_22698(poseStack, cons, light, class_4608.field_21444);
        }
    }

    public static ArmorModelGetter fromItemStack(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ItemArmorBase) {
            ItemArmorBase armor = (ItemArmorBase)class_17922;
            return ARMOR_GETTER.get(armor.registryID);
        }
        return null;
    }

    public static FirstPersonArmorRenderer getFirstPersonRenderer(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ItemArmorBase) {
            ItemArmorBase armor = (ItemArmorBase)class_17922;
            return FIRST_PERSON_GETTER.get(armor.registryID);
        }
        return null;
    }

    public static class_572<?> getDefaultArmorModel(class_1304 slot) {
        return slot == class_1304.field_6172 ? INNER : OUTER;
    }

    public static void initArmorModels(class_5617.class_5618 ctx) {
        INNER = new class_572(ctx.method_32167(class_5602.field_27579));
        OUTER = new class_572(ctx.method_32167(class_5602.field_27580));
        PIYO_SANDALS_MODEL = new PiyoSandals(ctx.method_32167(PiyoSandals.LAYER_LOCATION));
        RINGS_MODEL = new RingsArmorModel(ctx.method_32167(RingsArmorModel.LAYER_LOCATION));
    }

    private static List<RegistryEntrySupplier<class_1792>> bracelets() {
        return List.of(ModItems.CHEAP_BRACELET, ModItems.BRONZE_BRACELET, ModItems.SILVER_BRACELET, ModItems.GOLD_BRACELET, ModItems.PLATINUM_BRACELET);
    }

    private static List<RegistryEntrySupplier<class_1792>> rings() {
        return List.of(ModItems.SILVER_RING, ModItems.GOLD_RING, ModItems.PLATINUM_RING, ModItems.ENGAGEMENT_RING, ModItems.SHIELD_RING, ModItems.CRITICAL_RING, ModItems.SILENT_RING, ModItems.PARALYSIS_RING, ModItems.POISON_RING, ModItems.MAGIC_RING, ModItems.THROWING_RING, ModItems.STAY_UP_RING, ModItems.AQUAMARINE_RING, ModItems.AMETHYST_RING, ModItems.EMERALD_RING, ModItems.SAPPHIRE_RING, ModItems.RUBY_RING, ModItems.CURSED_RING, ModItems.DIAMOND_RING, ModItems.FIRE_RING, ModItems.WIND_RING, ModItems.WATER_RING, ModItems.EARTH_RING, ModItems.HAPPY_RING);
    }

    public static interface ArmorModelGetter {
        public class_3879 getModel(class_1309 var1, class_1799 var2, class_1304 var3, class_572<?> var4);
    }

    public static interface FirstPersonArmorRenderer {
        public void render(class_742 var1, class_1799 var2, boolean var3, class_591<?> var4, class_4587 var5, class_4597 var6, int var7);
    }
}

