/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.mixin.SoundManagerAccessor;
import io.github.flemmli97.runecraftory.mixinhelper.SoundEngineUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4235;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class BossBarTracker {
    private static final Map<class_2960, ClientBossBarType> BOSS_BARS = new HashMap<class_2960, ClientBossBarType>();
    private static final Map<UUID, BossBarData> ACTIVE_BOSS_BARS = new HashMap<UUID, BossBarData>();
    private static final Map<UUID, BossSoundInstance> ACTIVE_BOSS_BGM = new HashMap<UUID, BossSoundInstance>();
    private static final Map<UUID, BossSoundInstance> FADING_CHANNEL = new HashMap<UUID, BossSoundInstance>();
    private static class_1113 activeMusic;
    private static int lastPlay;
    private static int tick;

    public static void registerCustomBossbarType(class_2960 id, ClientBossBarType type) {
        BOSS_BARS.put(id, type);
    }

    public static void register() {
    }

    public static void tickSounds() {
        ++tick;
        FADING_CHANNEL.values().removeIf(BossSoundInstance::done);
    }

    public static void addActiveBossbar(UUID id, UUID musicID, class_2960 type, class_3414 music) {
        BossBarData old = ACTIVE_BOSS_BARS.get(id);
        if (old != null) {
            BossSoundInstance sound;
            if (!(old.music == null || (sound = ACTIVE_BOSS_BGM.get(old.music)) == null || music != null && sound.method_4775().equals((Object)music.method_14833()))) {
                sound.instances.remove(id);
                if (sound.instances.isEmpty()) {
                    ACTIVE_BOSS_BGM.remove(old.music);
                }
                class_310.method_1551().method_1483().method_4870((class_1113)sound);
                BossSoundInstance bgm = BossBarTracker.createSound(musicID, music);
                old.music = musicID;
                ACTIVE_BOSS_BGM.put(musicID, bgm);
                BossBarTracker.playMusic(bgm);
            }
            return;
        }
        BossSoundInstance inst = FADING_CHANNEL.get(musicID);
        if (inst != null) {
            inst.reverse(true);
        } else {
            BossSoundInstance existing = ACTIVE_BOSS_BGM.get(musicID);
            if (existing == null) {
                inst = BossBarTracker.createSound(musicID, music);
                BossBarTracker.playMusic(inst);
                inst.instances.add(id);
                ACTIVE_BOSS_BGM.put(musicID, inst);
            } else {
                existing.instances.add(id);
            }
        }
        BossBarData data = new BossBarData(type, musicID);
        ACTIVE_BOSS_BARS.put(id, data);
    }

    public static void updateMusic(UUID id, UUID musicID, boolean stop) {
        BossSoundInstance bgm = ACTIVE_BOSS_BGM.get(musicID);
        if (bgm != null) {
            if (stop) {
                bgm.instances.remove(id);
                if (bgm.instances.isEmpty()) {
                    BossBarTracker.stopMusic(bgm);
                }
            } else {
                boolean empty = bgm.instances.isEmpty();
                bgm.instances.add(id);
                if (empty) {
                    BossBarTracker.playMusic(bgm);
                }
            }
        }
    }

    public static void removeActiveBossbar(UUID id, boolean immediate) {
        BossBarData data = ACTIVE_BOSS_BARS.remove(id);
        if (data != null && data.music != null) {
            BossSoundInstance sound = ACTIVE_BOSS_BGM.get(data.music);
            if (sound == null) {
                return;
            }
            sound.instances.remove(id);
            if (!sound.instances.isEmpty()) {
                return;
            }
            ACTIVE_BOSS_BGM.remove(data.music);
            if (immediate || ClientConfig.bossMusicFadeDelay == 0) {
                FADING_CHANNEL.remove(data.music);
                BossBarTracker.stopMusic(sound);
            } else {
                BossSoundInstance inst = FADING_CHANNEL.get(data.music);
                if (inst != null) {
                    inst.reverse(false);
                } else {
                    FADING_CHANNEL.put(data.music, sound.reverse(false));
                }
            }
        }
    }

    public static int tryRenderCustomBossbar(class_4587 poseStack, int x, int y, class_1259 bossEvent, boolean withName) {
        ClientBossBarType type;
        BossBarData data = ACTIVE_BOSS_BARS.get(bossEvent.method_5407());
        if (data != null && (type = BOSS_BARS.get(data.type)) != null) {
            return type.renderFrom(poseStack, x, y, bossEvent, withName);
        }
        return 0;
    }

    public static BossSoundInstance createSound(UUID id, class_3414 sound) {
        if (sound == null || !ClientConfig.bossMusic) {
            return null;
        }
        return new BossSoundInstance(id, sound, class_3419.field_15247, 1.0f, 1.0f, ClientConfig.bossMusicFadeDelay);
    }

    private static void playMusic(BossSoundInstance sound) {
        if (lastPlay == tick) {
            return;
        }
        lastPlay = tick;
        if (activeMusic != null) {
            class_310.method_1551().method_1483().method_4870(activeMusic);
        }
        class_310.method_1551().method_1483().method_4873((class_1113)sound);
        activeMusic = sound;
    }

    private static void stopMusic(BossSoundInstance sound) {
        if (activeMusic == sound && sound.instances.isEmpty()) {
            class_310.method_1551().method_1483().method_4870((class_1113)sound);
            ACTIVE_BOSS_BGM.values().stream().filter(bgm -> bgm != sound && !bgm.instances.isEmpty()).findFirst().ifPresent(bgm -> {
                class_310.method_1551().method_1483().method_4873((class_1113)bgm);
                activeMusic = bgm;
            });
        }
    }

    public static class BossBarData {
        public final class_2960 type;
        public UUID music;

        public BossBarData(class_2960 type, UUID music) {
            this.type = type;
            this.music = music;
        }
    }

    public static class BossSoundInstance
    extends class_1101 {
        public final UUID id;
        private final int fadeTime;
        private final float defaultVol;
        private final float volDecrease;
        private int tick = 1;
        private boolean reverse;
        private boolean fade;
        private final Set<UUID> instances = new HashSet<UUID>();

        public BossSoundInstance(UUID id, class_3414 soundEvent, class_3419 soundSource, float volume, float pitch, int fadeTime) {
            super(soundEvent, soundSource);
            this.id = id;
            this.field_5442 = volume;
            this.field_5441 = pitch;
            this.fadeTime = fadeTime;
            this.defaultVol = class_3532.method_15363((float)(volume * BossSoundInstance.getVolume(soundSource)), (float)0.0f, (float)1.0f);
            this.volDecrease = 1.0f / (float)this.fadeTime;
            this.field_5446 = true;
            this.field_18936 = true;
        }

        private static float getVolume(@Nullable class_3419 category) {
            if (category == null || category == class_3419.field_15250) {
                return 1.0f;
            }
            return class_310.method_1551().field_1690.method_1630(category);
        }

        public BossSoundInstance reverse(boolean reverse) {
            this.reverse = reverse;
            this.tick = class_3532.method_15340((int)this.tick, (int)0, (int)this.fadeTime);
            this.fade = true;
            return this;
        }

        public boolean done() {
            return this.tick > this.fadeTime || this.tick < 0 || this.instances.isEmpty();
        }

        public void method_16896() {
            if (!this.fade) {
                return;
            }
            if (this.instances.isEmpty()) {
                this.method_24876();
                return;
            }
            boolean done = this.done();
            this.tick = this.reverse ? --this.tick : ++this.tick;
            this.field_5442 = this.defaultVol * class_3532.method_15363((float)(1.0f - this.volDecrease * (float)this.tick), (float)0.0f, (float)1.0f);
            if (done) {
                if (!this.reverse) {
                    BossBarTracker.stopMusic(this);
                    this.field_5446 = false;
                }
                this.fade = false;
            }
        }
    }

    public record ClientBossBarType(BossbarTexture texture, BossbarTexture overlay) {
        public int renderFrom(class_4587 poseStack, int x, int y, class_1259 bossEvent, boolean withName) {
            class_310 mc = class_310.method_1551();
            if (withName) {
                int screenX = mc.method_22683().method_4486();
                class_2561 component = bossEvent.method_5414();
                int len = mc.field_1772.method_27525((class_5348)component);
                int txtX = screenX / 2 - len / 2;
                mc.field_1772.method_30881(poseStack, component, (float)txtX, (float)(y - 9), 0xFFFFFF);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.texture.texture);
            class_332.method_25291((class_4587)poseStack, (int)x, (int)y, (int)0, (float)this.texture.offsetX, (float)this.texture.offsetY, (int)this.texture.width, (int)this.texture.height, (int)256, (int)256);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.overlay.texture);
            int overlayWidth = (int)(bossEvent.method_5412() * (float)this.overlay.width);
            class_332.method_25291((class_4587)poseStack, (int)x, (int)y, (int)0, (float)this.overlay.offsetX, (float)this.overlay.offsetY, (int)overlayWidth, (int)this.overlay.height, (int)256, (int)256);
            Objects.requireNonNull(mc.field_1772);
            return y + 9 + Math.max(this.texture.height, this.overlay.height) + 5;
        }
    }

    public record BossbarTexture(class_2960 texture, int width, int height, int offsetX, int offsetY) {
    }

    public static class TickingSoundChannel {
        private final class_1113 inst;
        private final class_4235.class_4236 channel;
        private final int fadeTime;
        private final float defaultVol;
        private final float volDecrease;
        private int tick;
        private boolean reverse;

        public TickingSoundChannel(class_1113 inst, int fadeTime) {
            this.inst = inst;
            SoundEngineUtil engine = (SoundEngineUtil)((SoundManagerAccessor)class_310.method_1551().method_1483()).getSoundEngine();
            this.channel = engine.runecraftory$getHandle(inst);
            this.fadeTime = fadeTime;
            this.tick = 0;
            this.volDecrease = 1.0f / (float)this.fadeTime;
            this.defaultVol = TickingSoundChannel.calculateVolume(inst);
        }

        private static float calculateVolume(class_1113 sound) {
            return class_3532.method_15363((float)(sound.method_4781() * TickingSoundChannel.getVolume(sound.method_4774())), (float)0.0f, (float)1.0f);
        }

        private static float getVolume(@Nullable class_3419 category) {
            if (category == null || category == class_3419.field_15250) {
                return 1.0f;
            }
            return class_310.method_1551().field_1690.method_1630(category);
        }

        public boolean tick() {
            boolean done;
            if (this.channel == null) {
                return true;
            }
            boolean bl = done = this.tick > this.fadeTime || this.tick < 0;
            this.tick = this.reverse ? --this.tick : ++this.tick;
            float vol = this.defaultVol * class_3532.method_15363((float)(1.0f - this.volDecrease * (float)this.tick), (float)0.0f, (float)1.0f);
            this.channel.method_19735(ch -> ch.method_19647(vol));
            if (!done || !this.reverse) {
                // empty if block
            }
            return done;
        }

        public void reverse(boolean reverse) {
            this.reverse = reverse;
        }
    }
}

