/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.enums.EnumWeather;
import io.github.flemmli97.runecraftory.client.AttackAABBRender;
import io.github.flemmli97.runecraftory.client.BossBarTracker;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.ShakeHandler;
import io.github.flemmli97.runecraftory.client.gui.widgets.SkillButton;
import io.github.flemmli97.runecraftory.client.tooltips.UpgradeTooltipComponent;
import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.items.MultiBlockItem;
import io.github.flemmli97.runecraftory.common.items.tools.ItemFertilizer;
import io.github.flemmli97.runecraftory.common.network.C2SOpenInfo;
import io.github.flemmli97.runecraftory.common.network.C2SRideJump;
import io.github.flemmli97.runecraftory.common.network.C2SSpellKey;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.mixin.ContainerScreenAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4066;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5632;
import net.minecraft.class_744;
import net.minecraft.class_746;

public class ClientCalls {
    public static void clientTick() {
        BossBarTracker.tickSounds();
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && Platform.INSTANCE.getPlayerData((class_1657)player).map(d -> d.getWeaponHandler().isItemSwapBlocked()).orElse(false).booleanValue()) {
            class_315 options = class_310.method_1551().field_1690;
            for (int i = 0; i < 9; ++i) {
                while (options.field_1852[i].method_1436()) {
                }
            }
            while (options.field_1831.method_1436()) {
            }
        }
        if (class_310.method_1551().field_1755 != null) {
            return;
        }
        switch (ClientHandlers.SPELL_1.onPress()) {
            case PRESSING: {
                Platform.INSTANCE.sendToServer(new C2SSpellKey(0, false));
                break;
            }
            case RELEASE: {
                Platform.INSTANCE.sendToServer(new C2SSpellKey(0, true));
            }
        }
        switch (ClientHandlers.SPELL_2.onPress()) {
            case PRESSING: {
                Platform.INSTANCE.sendToServer(new C2SSpellKey(1, false));
                break;
            }
            case RELEASE: {
                Platform.INSTANCE.sendToServer(new C2SSpellKey(1, true));
            }
        }
        switch (ClientHandlers.SPELL_3.onPress()) {
            case PRESSING: {
                Platform.INSTANCE.sendToServer(new C2SSpellKey(2, false));
                break;
            }
            case RELEASE: {
                Platform.INSTANCE.sendToServer(new C2SSpellKey(2, true));
            }
        }
        switch (ClientHandlers.SPELL_4.onPress()) {
            case PRESSING: {
                Platform.INSTANCE.sendToServer(new C2SSpellKey(3, false));
                break;
            }
            case RELEASE: {
                Platform.INSTANCE.sendToServer(new C2SSpellKey(3, true));
            }
        }
    }

    public static void initSkillTab(class_437 screen, Consumer<class_339> cons) {
        if (ClientConfig.inventoryButton && (screen instanceof class_490 || screen instanceof class_481)) {
            int x = ((ContainerScreenAccessor)screen).getLeft();
            int y = ((ContainerScreenAccessor)screen).getTop();
            if (screen instanceof class_490) {
                x += ClientConfig.inventoryOffsetX;
                y += ClientConfig.inventoryOffsetY;
            } else {
                x += ClientConfig.creativeInventoryOffsetX;
                y += ClientConfig.creativeInventoryOffsetY;
            }
            cons.accept((class_339)new SkillButton(x, y, screen, b -> Platform.INSTANCE.sendToServer(new C2SOpenInfo(C2SOpenInfo.Type.MAIN))));
        }
    }

    public static void handleInputUpdate(class_1657 player, class_744 input) {
        float reduction;
        if (EntityUtils.isDisabled((class_1309)player)) {
            input.field_3907 = 0.0f;
            input.field_3905 = 0.0f;
            input.field_3910 = false;
            input.field_3909 = false;
            input.field_3908 = false;
            input.field_3906 = false;
            input.field_3904 = false;
            input.field_3903 = false;
        }
        if ((reduction = Platform.INSTANCE.getPlayerData(player).map(d -> Float.valueOf(d.getWeaponHandler().movementReduction())).orElse(Float.valueOf(1.0f)).floatValue()) != 1.0f) {
            input.field_3907 *= reduction;
            input.field_3905 *= reduction;
            input.field_3904 = false;
            if (reduction == 0.0f) {
                input.field_3910 = false;
                input.field_3909 = false;
                input.field_3908 = false;
                input.field_3906 = false;
                input.field_3903 = false;
            }
        }
    }

    public static void renderScreenOverlays(class_4587 stack, float partialTicks) {
        if (ClientHandlers.OVERLAY != null) {
            ClientHandlers.OVERLAY.renderBar(stack);
        }
        if (ClientHandlers.SPELL_DISPLAY != null && ClientConfig.inventoryButton) {
            ClientHandlers.SPELL_DISPLAY.render(stack, partialTicks);
        }
        if (ClientHandlers.FARM_DISPLAY != null) {
            ClientHandlers.FARM_DISPLAY.render(stack);
        }
    }

    public static void tooltipEvent(class_1799 stack, List<class_2561> tooltip, class_1836 flag) {
        if (!stack.method_7960()) {
            boolean showTooltip = true;
            if (stack.method_7985()) {
                class_2561 class_25612;
                class_2487 tag = stack.method_7969();
                if (tag.method_10573("HideFlags", 99)) {
                    boolean bl = showTooltip = (stack.method_7969().method_10550("HideFlags") & 0x20) == 0;
                }
                if (tag.method_10562("runecraftory").method_10545("CraftingBonus") && (class_25612 = tooltip.get(0)) instanceof class_5250) {
                    class_5250 mut = (class_5250)class_25612;
                    mut.method_27692(class_124.field_1075);
                }
            }
            if (showTooltip) {
                Pair<List<class_2561>, List<class_2561>> p = ClientCalls.injectAdditionalTooltip(stack, flag);
                tooltip.addAll(1, (Collection)p.getFirst());
                tooltip.addAll((Collection)p.getSecond());
            }
        }
    }

    private static Pair<List<class_2561>, List<class_2561>> injectAdditionalTooltip(class_1799 stack, class_1836 flag) {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        boolean shift = class_437.method_25442();
        ArrayList<class_5250> debug = new ArrayList<class_5250>();
        DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).ifPresent(stat -> {
            tooltip.addAll(stat.texts(stack, shift));
            if (flag.method_8035()) {
                debug.add(new class_2588("runecraftory.tooltip.debug.stat", new Object[]{stat.getId().toString()}).method_27692(class_124.field_1080));
            }
        });
        CropProperties props = DataPackHandler.INSTANCE.cropManager().get(stack.method_7909());
        if (props != null) {
            tooltip.addAll(props.texts());
            if (flag.method_8035()) {
                debug.add(new class_2588("runecraftory.tooltip.debug.crop", new Object[]{props.getId().toString()}).method_27692(class_124.field_1080));
            }
        }
        if (shift) {
            FoodProperties food = DataPackHandler.INSTANCE.foodManager().get(stack.method_7909());
            if (food != null) {
                tooltip.addAll(food.texts(stack));
                if (flag.method_8035()) {
                    debug.add(new class_2588("runecraftory.tooltip.debug.food", new Object[]{food.getId().toString()}).method_27692(class_124.field_1080));
                }
            } else if (stack.method_19267()) {
                tooltip.add(new class_2588("runecraftory.tooltip.item.eaten").method_27692(class_124.field_1080));
                class_5250 comp = new class_2585(" ").method_10852((class_2561)new class_2588(((class_1320)ModAttributes.RPGAIN.get()).method_26830())).method_10852((class_2561)new class_2585(": " + EntityUtils.getRPFromVanillaFood(stack)));
                tooltip.add(comp.method_27692(class_124.field_1075));
            }
        }
        return Pair.of(tooltip, debug);
    }

    public static void tooltipComponentEvent(class_1799 stack, Consumer<class_5632> elements, int screenWidth, int screenHeight) {
        if (UpgradeTooltipComponent.shouldAdd(stack)) {
            elements.accept(new UpgradeTooltipComponent.UpgradeComponent(stack));
        }
    }

    public static void worldRender(class_4587 stack) {
        class_3965 result;
        class_3965 hitResult;
        MultiBlockItem multiBlockItem;
        if (GeneralConfig.debugAttack) {
            AttackAABBRender.INST.render(stack, class_310.method_1551().method_22940().method_23001());
        }
        class_310 minecraft = class_310.method_1551();
        MultiBlockItem item = null;
        class_1799 main = minecraft.field_1724.method_6047();
        class_1799 off = minecraft.field_1724.method_6047();
        class_1799 toUse = main;
        class_1268 hand = class_1268.field_5808;
        class_1792 class_17922 = off.method_7909();
        if (class_17922 instanceof MultiBlockItem) {
            multiBlockItem = (MultiBlockItem)class_17922;
            if (!(main.method_7909() instanceof class_1747)) {
                item = multiBlockItem;
                toUse = off;
                hand = class_1268.field_5810;
            }
        }
        if ((class_17922 = main.method_7909()) instanceof MultiBlockItem) {
            item = multiBlockItem = (MultiBlockItem)class_17922;
            toUse = main;
            hand = class_1268.field_5810;
        }
        if (item == null) {
            return;
        }
        class_239 class_2392 = minecraft.field_1765;
        class_3965 class_39652 = hitResult = class_2392 instanceof class_3965 && (result = (class_3965)class_2392).method_17783() != class_239.class_240.field_1333 ? result : null;
        if (hitResult != null) {
            class_1750 ctx = new class_1750((class_1657)minecraft.field_1724, hand, toUse, hitResult);
            class_2338 pos = ctx.method_8037();
            class_243 camPos = minecraft.field_1773.method_19418().method_19326();
            double x = camPos.method_10216();
            double y = camPos.method_10214();
            double z = camPos.method_10215();
            class_4597.class_4598 buffer = minecraft.method_22940().method_23000();
            class_4588 consumer = buffer.getBuffer(class_1921.method_23594());
            boolean invalid = false;
            ArrayList<Pair> list = new ArrayList<Pair>();
            class_2470 rot = EntityUtils.fromDirection(minecraft.field_1724.method_5735());
            for (Pair<class_2338, class_2680> p : item.getBlocks()) {
                class_2338 offset = ((class_2338)p.getFirst()).method_10070(rot).method_10081((class_2382)pos);
                class_2680 current = minecraft.field_1687.method_8320(offset);
                if (!current.method_26166(ctx)) {
                    invalid = true;
                    list.add(Pair.of((Object)offset, (Object)class_259.method_1073()));
                    continue;
                }
                list.add(Pair.of((Object)offset, (Object)((class_2680)p.getSecond()).method_26186(rot).method_26218((class_1922)minecraft.field_1687, offset).method_1096((double)offset.method_10263(), (double)offset.method_10264(), (double)offset.method_10260())));
            }
            float gb = invalid ? 0.3f : 1.0f;
            for (Pair p : list) {
                if (p.getSecond() == class_259.method_1073()) continue;
                ClientCalls.renderBlockAt(stack, consumer, (class_265)p.getSecond(), x, y, z, 1.0f, gb, gb, 1.0f, invalid);
            }
            buffer.method_22994(class_1921.method_23594());
        }
    }

    private static void renderBlockAt(class_4587 stack, class_4588 consumer, class_265 shape, double camX, double camY, double camZ, float r, float g, float b, float alpha, boolean invalid) {
        class_4587.class_4665 pose = stack.method_23760();
        shape.method_1104((k, l, m, n, o, p) -> {
            float dX = (float)(n - k);
            float dY = (float)(o - l);
            float dZ = (float)(p - m);
            float len = class_3532.method_15355((float)(dX * dX + dY * dY + dZ * dZ));
            consumer.method_22918(pose.method_23761(), (float)(k - camX), (float)(l - camY), (float)(m - camZ)).method_22915(r, g, b, alpha).method_23763(pose.method_23762(), dX /= len, dY /= len, dZ /= len).method_1344();
            consumer.method_22918(pose.method_23761(), (float)(n - camX), (float)(o - camY), (float)(p - camZ)).method_22915(r, g, b, alpha).method_23763(pose.method_23762(), dX, dY, dZ).method_1344();
        });
    }

    public static void tick(class_1309 entity) {
        Platform.INSTANCE.getEntityData(entity).ifPresent(data -> {
            int mod = entity.field_6012 % 20;
            if (mod == 0 && data.isSleeping()) {
                entity.field_6002.method_8406((class_2394)ModParticles.SLEEP.get(), entity.method_23317(), entity.method_23318() + (double)entity.method_17682() + 0.5, entity.method_23321(), 0.0, 0.0, 0.0);
            }
            if (mod == 5 && data.isPoisoned()) {
                entity.field_6002.method_8406((class_2394)ModParticles.POISON.get(), entity.method_23317(), entity.method_23318() + (double)entity.method_17682() + 0.1, entity.method_23321(), 0.0, 0.0, 0.0);
            }
            if (data.isParalysed()) {
                boolean bl2;
                boolean bl = entity.method_5767() ? entity.method_6051().nextInt(25) == 0 : (bl2 = entity.method_6051().nextInt(5) == 0);
                if (bl2) {
                    entity.field_6002.method_8406((class_2394)ModParticles.PARALYSIS.get(), entity.method_23322(0.5), entity.method_23319(), entity.method_23325(0.5), 0.05, 0.05, 0.05);
                }
            }
        });
        if (entity == class_310.method_1551().field_1724) {
            --ShakeHandler.shakeTick;
            if (entity.method_5854() instanceof BaseMonster && class_310.method_1551().field_1724.field_3913.field_3904) {
                Platform.INSTANCE.sendToServer(new C2SRideJump());
            }
        }
        if (entity == class_310.method_1551().field_1719 && ClientHandlers.CLIENT_CALENDAR.currentWeather() == EnumWeather.RUNEY) {
            int tries = class_310.method_1551().field_1690.field_1882 != class_4066.field_18197 ? 1 : 2;
            for (int i = 0; i < tries; ++i) {
                entity.field_6002.method_8406((class_2394)ModParticles.RUNEY.get(), entity.method_23317() + (entity.method_6051().nextDouble() - 0.5) * 24.0, entity.method_23318() + (entity.method_6051().nextDouble() - 0.5) * 12.0, entity.method_23321() + (entity.method_6051().nextDouble() - 0.5) * 24.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static boolean invis(class_1309 entity) {
        return Platform.INSTANCE.getEntityData(entity).map(EntityData::isInvis).orElse(false);
    }

    public static void renderShaking(class_4184 camera, float yaw, float pitch, float roll, float partialTicks, Consumer<Float> setYaw, Consumer<Float> setPitch, Consumer<Float> setRoll) {
        int t;
        boolean stunned = class_310.method_1551().field_1724.method_6059((class_1291)ModEffects.STUNNED.get());
        if (stunned) {
            float pT = (float)(class_310.method_1551().field_1724.field_6012 * 10) - partialTicks;
            setYaw.accept(Float.valueOf(yaw + class_3532.method_15374((float)pT) * 0.5f));
            setPitch.accept(Float.valueOf(pitch + class_3532.method_15374((float)(pT * 2.0f)) * 1.0f));
        }
        if ((t = ShakeHandler.shakeTick) <= 0) {
            return;
        }
        float strengthPitch = ShakeHandler.shakeStrength;
        float strengthRoll = ShakeHandler.shakeStrength;
        float pT = (float)(t * 24) - partialTicks;
        setPitch.accept(Float.valueOf(pitch + class_3532.method_15374((float)(pT * 2.0f)) * strengthPitch));
        setRoll.accept(Float.valueOf(roll + class_3532.method_15374((float)pT) * strengthRoll));
    }

    public static void renderEntityShake(class_1309 entity, class_4587 stack, float partialTicks) {
        boolean stunned = Platform.INSTANCE.getEntityData(entity).map(EntityData::isStunned).orElse(false);
        if (!stunned) {
            return;
        }
        class_243 dir = class_243.method_1030((float)0.0f, (float)(entity.method_5705(partialTicks) + 90.0f)).method_1021(0.1);
        float pT = (float)(class_310.method_1551().field_1724.field_6012 * 10) - partialTicks;
        stack.method_22904((double)class_3532.method_15374((float)pT) * dir.method_10216(), 0.0, (double)class_3532.method_15374((float)pT) * dir.method_10215());
    }

    public static boolean onBlockHighlightRender(class_1937 level, class_4587 poseStack, class_4588 consumer, class_1297 entity, double camX, double camY, double camZ, class_2338 pos, class_2680 state) {
        class_1309 living;
        if (entity instanceof class_1309 && (living = (class_1309)entity).method_6047().method_7909() instanceof ItemFertilizer) {
            boolean targetingCrop = level.method_8320(pos).method_26204() instanceof class_2261;
            ItemFertilizer.getOtherForTargeted(entity.method_5735(), pos).forEach(p -> {
                class_2680 state1 = level.method_8320(p);
                if (targetingCrop && state1.method_26215()) {
                    p = p.method_10074();
                    state1 = level.method_8320(p);
                }
                if (!state1.method_26215() && level.method_8621().method_11952(p)) {
                    ClientCalls.renderShape(poseStack, consumer, state1.method_26172((class_1922)level, p, class_3726.method_16195((class_1297)entity)), (double)p.method_10263() - camX, (double)p.method_10264() - camY, (double)p.method_10260() - camZ, 0.0f, 0.0f, 0.0f, 0.4f);
                }
            });
        }
        return false;
    }

    private static void renderShape(class_4587 poseStack, class_4588 consumer, class_265 shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        class_4587.class_4665 pose = poseStack.method_23760();
        shape.method_1104((k, l, m, n, o, p) -> {
            float q = (float)(n - k);
            float r = (float)(o - l);
            float s = (float)(p - m);
            float t = class_3532.method_15355((float)(q * q + r * r + s * s));
            consumer.method_22918(pose.method_23761(), (float)(k + x), (float)(l + y), (float)(m + z)).method_22915(red, green, blue, alpha).method_23763(pose.method_23762(), q /= t, r /= t, s /= t).method_1344();
            consumer.method_22918(pose.method_23761(), (float)(n + x), (float)(o + y), (float)(p + z)).method_22915(red, green, blue, alpha).method_23763(pose.method_23762(), q, r, s).method_1344();
        });
    }
}

