/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1077;
import net.minecraft.class_2477;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class NPCDialogueLanguageManager {
    public static final NPCDialogueLanguageManager INSTANCE = new NPCDialogueLanguageManager();
    public static final String DIRECTORY = "lang/npc_conversations";
    private Map<String, String> translations = new HashMap<String, String>();

    private NPCDialogueLanguageManager() {
    }

    private static Map<String, String> loadFrom(class_3300 resourceManager, List<class_1077> languageInfo) {
        HashMap translations = new HashMap();
        HashMap result = new HashMap();
        List<String> codes = languageInfo.stream().map(class_1077::getCode).toList();
        for (class_2960 res : resourceManager.method_14488(DIRECTORY, p -> p.endsWith(".json"))) {
            String[] dirs = res.method_12832().split("/");
            String lang = dirs[dirs.length - 1].replace(".json", "");
            if (!codes.contains(lang)) continue;
            HashMap map = new HashMap();
            try {
                for (class_3298 resource : resourceManager.method_14489(res)) {
                    InputStream inputStream = resource.method_14482();
                    try {
                        class_2477.method_29425((InputStream)inputStream, map::put);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
            }
            catch (IOException iOException) {
                RuneCraftory.LOGGER.warn("Failed to load dialog translations for language {}", (Object)lang, (Object)iOException);
            }
            translations.computeIfAbsent(lang, k -> new HashMap()).putAll(map);
        }
        for (String code : codes) {
            result.putAll(translations.getOrDefault(code, Map.of()));
        }
        return ImmutableMap.copyOf(result);
    }

    public void onResourceManagerReload(class_3300 resourceManager, List<class_1077> infos) {
        this.translations = NPCDialogueLanguageManager.loadFrom(resourceManager, infos);
    }

    public String getOrDefault(String key) {
        return this.translations.getOrDefault(key, key);
    }
}

