/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerCrafting;
import io.github.flemmli97.runecraftory.common.network.C2SSelectRecipeCrafting;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5348;

public class CraftingGui
extends class_465<ContainerCrafting> {
    private static final class_2960 BARS = new class_2960("runecraftory", "textures/gui/bars.png");
    private static final class_2960 FORGING = new class_2960("runecraftory", "textures/gui/forging.png");
    private static final class_2960 CRAFTING = new class_2960("runecraftory", "textures/gui/crafting.png");
    private static final class_2960 COOKING = new class_2960("runecraftory", "textures/gui/cooking.png");
    private static final class_2960 CHEMISTRY = new class_2960("runecraftory", "textures/gui/chemistry.png");
    private Rect scrollBar = new Rect(195, 12, 8, 142);
    private Rect scrollArea = new Rect(172, 12, 31, 142);
    private final RecipeSelectButton[] selectButtons = new RecipeSelectButton[7];
    private int scrollValue;
    private boolean isDragging;
    private final EnumSkills skill;

    public CraftingGui(ContainerCrafting container, class_1661 inv, class_2561 name) {
        super((class_1703)container, inv, name);
        this.field_2792 = 209;
        this.field_2779 = 166;
        this.skill = switch (((ContainerCrafting)this.field_2797).craftingType()) {
            default -> throw new IncompatibleClassChangeError();
            case EnumCrafting.FORGE -> EnumSkills.FORGING;
            case EnumCrafting.ARMOR -> EnumSkills.CRAFTING;
            case EnumCrafting.CHEM -> EnumSkills.CHEMISTRY;
            case EnumCrafting.COOKING -> EnumSkills.COOKING;
        };
    }

    protected void method_25426() {
        super.method_25426();
        for (int i = 0; i < 7; ++i) {
            this.selectButtons[i] = new RecipeSelectButton(this.field_2776 + 173, this.field_2800 + 13 + i * 20, i, b -> {
                if (b instanceof RecipeSelectButton) {
                    RecipeSelectButton but = (RecipeSelectButton)b;
                    Platform.INSTANCE.sendToServer(new C2SSelectRecipeCrafting(but.getActualIndex()));
                }
            });
            this.method_37063((class_364)this.selectButtons[i]);
        }
        this.scrollBar = new Rect(this.field_2776 + this.scrollBar.x, this.field_2800 + this.scrollBar.y, this.scrollBar.width, this.scrollBar.height);
        this.scrollArea = new Rect(this.field_2776 + this.scrollArea.x, this.field_2800 + this.scrollArea.y, this.scrollArea.width, this.scrollArea.height);
    }

    protected void method_2389(class_4587 stack, float partialTicks, int mouseX, int mouseY) {
        class_2960 texture = switch (((ContainerCrafting)this.field_2797).craftingType()) {
            default -> throw new IncompatibleClassChangeError();
            case EnumCrafting.ARMOR -> CRAFTING;
            case EnumCrafting.COOKING -> COOKING;
            case EnumCrafting.FORGE -> FORGING;
            case EnumCrafting.CHEM -> CHEMISTRY;
        };
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        this.method_25302(stack, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)this.field_22787.field_1724).orElse(null);
        if (((ContainerCrafting)this.field_2797).rpCost() >= 0) {
            int rpMax = data != null ? data.getMaxRunePoints() : 0;
            class_2585 cost = new class_2585("" + ((ContainerCrafting)this.field_2797).rpCost());
            if (rpMax < ((ContainerCrafting)this.field_2797).rpCost() && !this.field_22787.field_1724.method_7337()) {
                cost = new class_2588("runecraftory.gui.crafting.rpMax.missing").method_27692(class_124.field_1079);
            }
            ClientHandlers.drawCenteredScaledString(stack, this.field_22793, (class_2561)cost, (float)(this.field_2776 + 123), (float)(this.field_2800 + 20), 1.0f, 0);
        }
        if (data != null) {
            stack.method_22903();
            float scale = 0.8f;
            int xPos = this.field_2776;
            int yPos = this.field_2800 - 12;
            stack.method_22904((double)xPos, (double)yPos, 0.0);
            stack.method_22905(scale, scale, scale);
            RenderSystem.setShaderTexture((int)0, (class_2960)BARS);
            this.method_25302(stack, 0, 0, 131, 74, 96, 29);
            int runePointsWidth = Math.min(76, (int)((float)data.getRunePoints() / (float)data.getMaxRunePoints() * 76.0f));
            this.method_25302(stack, 17, 3, 18, 40, runePointsWidth, 9);
            ClientHandlers.drawCenteredScaledString(stack, this.field_22793, data.getRunePoints() + "/" + data.getMaxRunePoints(), 55.5f, 5.0f, 0.7f, 0xFFFFFF);
            stack.method_22909();
            this.field_22793.method_30883(stack, (class_2561)new class_2588("runecraftory.gui.display.level", new Object[]{data.getSkillLevel(this.skill).getLevel()}), (float)(this.field_2776 + this.field_25267 + this.field_22793.method_27525((class_5348)this.field_22785) + 6), (float)(this.field_2800 + this.field_25268), 0x404040);
        }
    }

    public void method_25394(class_4587 stack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(stack);
        super.method_25394(stack, mouseX, mouseY, partialTicks);
        this.method_2380(stack, mouseX, mouseY);
        List<Pair<Integer, class_1799>> recipes = ((ContainerCrafting)this.field_2797).getMatchingRecipesClient();
        for (int i = this.scrollValue; i < this.scrollValue + 7; ++i) {
            if (i >= recipes.size()) continue;
            this.field_22788.field_4730 = 100.0f;
            this.field_22788.method_27953((class_1799)recipes.get(i).getSecond(), this.field_2776 + 176, this.field_2800 + 15 + 20 * (i - this.scrollValue));
        }
        for (RecipeSelectButton button : this.selectButtons) {
            button.field_22764 = button.index < ((ContainerCrafting)this.field_2797).getMatchingRecipesClient().size();
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)BARS);
        this.renderScroller(stack, this.scrollBar.x + 1, this.scrollBar.y + 1);
    }

    private void renderScroller(class_4587 poseStack, int posX, int posY) {
        int steps = ((ContainerCrafting)this.field_2797).getMatchingRecipesClient().size() - 7;
        int widgetHeight = 27;
        if (steps > 0) {
            int barHeight = this.scrollBar.height - 2;
            int moveableHeight = barHeight - widgetHeight;
            int k = moveableHeight / steps;
            int yOffset = class_3532.method_15340((int)(this.scrollValue * k), (int)0, (int)moveableHeight);
            this.method_25302(poseStack, posX, posY + yOffset, 185, 0, 6, widgetHeight);
        } else {
            this.method_25302(poseStack, posX, posY, 191, 0, 6, widgetHeight);
        }
    }

    private boolean canScroll() {
        return ((ContainerCrafting)this.field_2797).getMatchingRecipesClient().size() > 7;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.canScroll() && this.scrollArea.isMouseOver(mouseX, mouseY)) {
            this.setScrollValue((int)((double)this.scrollValue - delta));
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging) {
            int maxY = this.scrollBar.y + this.scrollBar.height - 3;
            int max = ((ContainerCrafting)this.field_2797).getMatchingRecipesClient().size() - 7;
            float amount = ((float)mouseY - (float)this.scrollBar.y - 13.5f) / ((float)(maxY - this.scrollBar.y) - 27.0f);
            amount = amount * (float)max + 0.5f;
            this.scrollValue = class_3532.method_15340((int)((int)amount), (int)0, (int)max);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.isDragging = this.canScroll() && this.scrollBar.isMouseOver(mouseX, mouseY);
        return super.method_25402(mouseX, mouseY, button);
    }

    public EnumCrafting type() {
        return ((ContainerCrafting)this.field_2797).craftingType();
    }

    public int getLeft() {
        return this.field_2776;
    }

    public int getTop() {
        return this.field_2800;
    }

    public void setScrollValue(int val) {
        this.scrollValue = class_3532.method_15340((int)val, (int)0, (int)Math.max(0, ((ContainerCrafting)this.field_2797).getMatchingRecipesClient().size() - 7));
    }

    record Rect(int x, int y, int width, int height) {
        public boolean isMouseOver(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
        }
    }

    private class RecipeSelectButton
    extends class_4185 {
        private final int index;

        public RecipeSelectButton(int i, int j, int k, class_4185.class_4241 onPress) {
            super(i, j, 22, 20, class_2585.field_24366, onPress);
            this.index = k;
            this.field_22764 = false;
        }

        public int getActualIndex() {
            return this.index + CraftingGui.this.scrollValue;
        }

        public void method_25352(class_4587 poseStack, int relativeMouseX, int relativeMouseY) {
            if (this.field_22762 && this.getActualIndex() < ((ContainerCrafting)CraftingGui.this.field_2797).getMatchingRecipesClient().size()) {
                class_1799 itemStack = (class_1799)((ContainerCrafting)CraftingGui.this.field_2797).getMatchingRecipesClient().get(this.getActualIndex()).getSecond();
                CraftingGui.this.method_25409(poseStack, itemStack, relativeMouseX, relativeMouseY);
            }
        }
    }
}

