/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.flemmli97.runecraftory.api.datapack.ConversationContext;
import io.github.flemmli97.runecraftory.client.gui.widgets.DialogueOptionButton;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.PlaceHolderComponent;
import io.github.flemmli97.runecraftory.common.network.C2SDialogueAction;
import io.github.flemmli97.runecraftory.common.network.C2SNPCInteraction;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class NPCDialogueGui<T extends EntityNPCBase>
extends class_437 {
    private static final class_2960 TEXTURE = new class_2960("runecraftory", "textures/gui/npc_dialogue.png");
    public static final int MAX_WIDTH = 200;
    public static final int MAX_HEIGHT = 73;
    public static final int BORDER_SIZE = 7;
    public static final int LINE_WIDTH = 186;
    public static final int ACTION_WIDTH = 90;
    public static final int LINES_PER_PAGE = 5;
    private final int offSetX = 100;
    private final int offSetY = 30;
    protected int leftPos;
    protected int topPos;
    private int pageIndex;
    private int lineProgress;
    private int textProgress;
    protected final T entity;
    private ConversationContext convCtx;
    private String conversationID;
    private List<ConversationLine> conversation;
    private Map<String, class_2561> replacements = Map.of();
    private List<class_2561> actions;
    private final List<DialogueOptionButton> buttons = new ArrayList<DialogueOptionButton>();
    private boolean reset;
    private boolean calculateButtonVisiblity;
    private boolean removed;

    public NPCDialogueGui(T entity) {
        super(entity.method_5476());
        this.entity = entity;
    }

    protected void method_25426() {
        super.method_25426();
        this.leftPos = this.field_22789 / 2 - this.offSetX;
        this.topPos = this.field_22790 / 2 + this.offSetY;
        this.buttons();
    }

    public void method_25394(class_4587 stack, int mouseX, int mouseY, float partialTick) {
        if (this.removed) {
            this.method_25419();
            return;
        }
        if (this.reset) {
            this.buttons();
            this.reset = false;
        }
        if (this.calculateButtonVisiblity) {
            if (this.buttonsVisible()) {
                this.showAllButtons();
            }
            this.calculateButtonVisiblity = false;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
        this.method_25302(stack, this.leftPos, this.topPos, 5, 5, 200, 73);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int lines = Math.min(this.conversation.size(), (this.pageIndex + 1) * 5);
        for (int i = this.pageIndex * 5; i < lines; ++i) {
            if (i > this.lineProgress) continue;
            ConversationLine txt = this.conversation.get(i);
            class_5481 txtRender = this.lineProgress == i ? class_2477.method_10517().method_30934(this.field_22793.method_1714(txt.raw(), this.textProgress)) : txt.txt();
            this.field_22793.method_27528(stack, txtRender, (float)(this.leftPos + 7), (float)(this.topPos + 7 + 13 * (i % 5)), 0xFFFFFF);
        }
        super.method_25394(stack, mouseX, mouseY, partialTick);
    }

    protected void buttons() {
        this.buttons.forEach(x$0 -> this.method_37066((class_364)x$0));
        this.buttons.clear();
        boolean visible = this.buttonsVisible();
        int y = 0;
        for (int i = this.actions.size() - 1; i >= 0; --i) {
            int actionIdx = i;
            DialogueOptionButton btn = new DialogueOptionButton(this.field_22789 / 2, this.topPos - 20 + y, this.field_22793, PlaceHolderComponent.parseDialogueComponent(this.actions.get(i), this.replacements), b -> {
                if (this.convCtx != null && this.conversationID != null) {
                    Platform.INSTANCE.sendToServer(new C2SDialogueAction(this.entity.method_5628(), this.convCtx, this.conversationID, actionIdx));
                }
            });
            btn.field_22761 -= btn.method_25364();
            btn.field_22764 = visible;
            this.buttons.add(btn);
            this.method_37063((class_364)btn);
            y -= btn.method_25364() + 8;
        }
    }

    public void method_25393() {
        super.method_25393();
        int max = this.maxCurrentLineIndex();
        if (this.lineProgress <= max) {
            this.textProgress += 4;
            ConversationLine txt = this.conversation.get(this.lineProgress);
            if (this.textProgress > txt.width()) {
                ++this.lineProgress;
                if (this.lineProgress > this.conversation.size() - 1) {
                    this.showAllButtons();
                }
                this.textProgress = 0;
            }
        }
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int id = this.maxCurrentLineIndex();
        if (this.lineProgress < id || this.lineProgress / 5 == this.pageIndex && this.lineProgress < this.conversation.size() && this.textProgress < this.conversation.get(this.lineProgress).width()) {
            this.lineProgress = id + 1;
            this.calculateButtonVisiblity = true;
        } else if (this.pageIndex + 1 <= (this.conversation.size() - 1) / 5) {
            ++this.pageIndex;
            this.textProgress = 0;
            this.calculateButtonVisiblity = true;
        } else if (this.buttons.isEmpty()) {
            this.removed = true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void showAllButtons() {
        this.buttons.forEach(b -> {
            b.field_22764 = true;
        });
    }

    private int maxCurrentLineIndex() {
        return Math.min(4 + this.pageIndex * 5, this.conversation.size() - 1);
    }

    private boolean buttonsVisible() {
        return this.lineProgress >= this.conversation.size() - 1;
    }

    public void method_25432() {
        super.method_25432();
        class_310.method_1551().field_1690.field_1904.method_1436();
        class_310.method_1551().field_1690.field_1904.method_23481(false);
        Platform.INSTANCE.sendToServer(new C2SNPCInteraction(this.entity.method_5628(), this.convCtx == null ? C2SNPCInteraction.Type.CLOSE_QUEST : C2SNPCInteraction.Type.CLOSE, this.conversationID));
        if (this.convCtx == ConversationContext.GREETING) {
            Platform.INSTANCE.sendToServer(new C2SNPCInteraction(this.entity.method_5628(), C2SNPCInteraction.Type.TALK));
        }
    }

    public void updateConversation(class_310 mc, ConversationContext convCtx, String conversationID, class_2561 conversation, Map<String, class_2561> data, List<class_2561> actions) {
        conversation = PlaceHolderComponent.parseDialogueComponent(conversation, data);
        this.conversation = mc.field_1772.method_27527().method_27495((class_5348)conversation, 186, conversation.method_10866()).stream().map(txt -> new ConversationLine(mc.field_1772.method_27525(txt), (class_5348)txt, class_2477.method_10517().method_30934(txt))).toList();
        this.actions = actions;
        this.convCtx = convCtx;
        this.conversationID = conversationID;
        this.replacements = data;
        this.lineProgress = 0;
        this.textProgress = 0;
        this.pageIndex = 0;
        this.reset = true;
    }

    record ConversationLine(int width, class_5348 raw, class_5481 txt) {
    }
}

