/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.job.ShopState;
import io.github.flemmli97.runecraftory.common.network.C2SNPCInteraction;
import io.github.flemmli97.runecraftory.common.network.C2SProcreationRequest;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import io.github.flemmli97.runecraftory.common.registry.ModPoiTypes;
import io.github.flemmli97.runecraftory.common.world.family.SyncedFamilyData;
import io.github.flemmli97.runecraftory.mixin.PoiTypeAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_364;
import net.minecraft.class_4158;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class NPCGui<T extends EntityNPCBase>
extends class_437 {
    private static final class_2960 TEXTURE_PATH = new class_2960("runecraftory", "textures/gui/view.png");
    private final int offSetX = 140;
    private final int offSetY = 50;
    protected int leftPos;
    protected int topPos;
    private int lines;
    protected final T entity;
    private final ShopState isShopOpen;
    private final boolean canFollow;
    private List<class_5481> components;
    private final Map<String, List<class_2561>> actions;
    private final class_2960 quest;
    private final SyncedFamilyData family;
    private final List<ToolTipRenderer> tooltipComponents = new ArrayList<ToolTipRenderer>();

    public NPCGui(T entity, ShopState isShopOpen, boolean canFollow, SyncedFamilyData family, Map<String, List<class_2561>> actions, class_2960 quest) {
        super(entity.method_5476());
        this.entity = entity;
        this.isShopOpen = isShopOpen;
        this.canFollow = canFollow;
        this.actions = actions;
        this.quest = quest;
        this.family = family;
    }

    protected void method_25426() {
        super.method_25426();
        this.leftPos = this.field_22789 - this.offSetX;
        this.topPos = this.offSetY;
        this.buttons();
    }

    public void method_25394(class_4587 stack, int mouseX, int mouseY, float partialTick) {
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE_PATH);
        int posX = 25;
        int posY = 25;
        int texY = this.lines * 13 + 10;
        boolean renderParents = this.family.father() != null || this.family.mother() != null;
        this.method_25302(stack, posX, posY, 0, 0, 150, texY - 5);
        this.method_25302(stack, posX, posY + texY - 5, 0, 251, 160, 5);
        int txtOffX = posX + 5;
        int txtOffY = posY + 5;
        ClientHandlers.drawCenteredScaledString(stack, this.field_22793, this.entity.method_5477(), (float)(posX + 75), (float)txtOffY, 1.0f, 0);
        int y = 1;
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE_PATH);
        this.method_25302(stack, posX + 65, txtOffY + 13 * y, 152, 2, 8, 8);
        this.field_22793.method_1729(stack, "" + this.entity.friendPoints((class_1657)this.field_22787.field_1724), (float)(posX + 65 + 10), (float)(txtOffY + 13 * y), 0);
        ++y;
        if (renderParents) {
            if (this.family.father() == null) {
                this.field_22793.method_30883(stack, (class_2561)new class_2588("runecraftory.gui.npc.parent"), (float)txtOffX, (float)(txtOffY + 13 * y), 0);
                ++y;
                for (class_5481 ch : this.field_22793.method_1728((class_5348)this.family.mother(), 140)) {
                    this.field_22793.method_27528(stack, ch, (float)txtOffX, (float)(txtOffY + 13 * y), 0);
                    ++y;
                }
            } else if (this.family.mother() == null) {
                this.field_22793.method_30883(stack, (class_2561)new class_2588("runecraftory.gui.npc.parent"), (float)txtOffX, (float)(txtOffY + 13 * y), 0);
                ++y;
                for (class_5481 ch : this.field_22793.method_1728((class_5348)this.family.father(), 140)) {
                    this.field_22793.method_27528(stack, ch, (float)txtOffX, (float)(txtOffY + 13 * y), 0);
                    ++y;
                }
            } else {
                this.field_22793.method_30883(stack, (class_2561)new class_2588("runecraftory.gui.npc.parents"), (float)txtOffX, (float)(txtOffY + 13 * y), 0);
                ++y;
                for (class_5481 ch : this.field_22793.method_1728((class_5348)this.family.father(), 140)) {
                    this.field_22793.method_27528(stack, ch, (float)txtOffX, (float)(txtOffY + 13 * y), 0);
                    ++y;
                }
                for (class_5481 ch : this.field_22793.method_1728((class_5348)this.family.mother(), 140)) {
                    this.field_22793.method_27528(stack, ch, (float)txtOffX, (float)(txtOffY + 13 * y), 0);
                    ++y;
                }
            }
        }
        if (!this.entity.method_6109()) {
            switch (this.family.relationship()) {
                case NONE: {
                    break;
                }
                case DATING: {
                    RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE_PATH);
                    this.method_25302(stack, txtOffX, txtOffY + 13 * y, 152, 41, 10, 8);
                    this.field_22793.method_30883(stack, this.family.partner(), (float)(txtOffX + 12), (float)(txtOffY + 13 * y), 0);
                    ++y;
                    break;
                }
                case MARRIED: {
                    RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE_PATH);
                    this.method_25302(stack, txtOffX, txtOffY + 13 * y, 152, 54, 10, 8);
                    this.field_22793.method_30883(stack, this.family.partner(), (float)(txtOffX + 12), (float)(txtOffY + 13 * y), 0);
                    ++y;
                }
            }
            ++y;
        }
        int shopY = txtOffY + 13 * y;
        int shopSizeY = -5;
        if (!this.entity.method_6109()) {
            class_2588 shopComp = null;
            if (((EntityNPCBase)this.entity).getShop() == ModNPCJobs.GENERAL.getSecond()) {
                shopComp = new class_2588("runecraftory.gui.npc.shop.owner", new Object[]{new class_2588(((EntityNPCBase)this.entity).getShop().getTranslationKey())});
            } else if (((EntityNPCBase)this.entity).getShop().hasWorkSchedule) {
                shopComp = new class_2588(((EntityNPCBase)this.entity).getShop().getTranslationKey());
            }
            if (shopComp != null) {
                if (this.isShopOpen == ShopState.NOBED || this.isShopOpen == ShopState.NOWORKPLACE) {
                    shopComp.method_27692(class_124.field_1079);
                }
                for (class_2561 comp : this.field_22793.method_1728((class_5348)shopComp, 140)) {
                    float xCenter = (float)(posX + 75) - (float)this.field_22787.field_1772.method_30880((class_5481)comp) * 0.5f;
                    this.field_22793.method_27528(stack, (class_5481)comp, xCenter, (float)(txtOffY + 13 * y), 0);
                    ++y;
                    shopSizeY += 13;
                }
            }
            if (((EntityNPCBase)this.entity).getShop().hasWorkSchedule) {
                for (class_2561 comp : ((EntityNPCBase)this.entity).getSchedule().viewSchedule()) {
                    for (class_5481 formatted : this.field_22793.method_1728((class_5348)comp, 140)) {
                        this.field_22793.method_27528(stack, formatted, (float)txtOffX, (float)(txtOffY + 13 * y), 0);
                        ++y;
                    }
                }
            }
        }
        if (this.components != null && this.isHovering(txtOffX, shopY, 145, shopSizeY, mouseX, mouseY)) {
            this.method_25417(stack, this.components, mouseX, mouseY);
        }
        this.tooltipComponents.forEach(r -> r.render(stack, mouseX, mouseY));
        this.lines = y;
        super.method_25394(stack, mouseX, mouseY, partialTick);
    }

    protected void buttons() {
        int x = -52;
        int xSize = 150;
        int y = 0;
        this.method_37063((class_364)new class_4185(this.leftPos + x, this.topPos + y, xSize, 20, (class_2561)new class_2588(C2SNPCInteraction.Type.TALK.translation), b -> {
            Platform.INSTANCE.sendToServer(new C2SNPCInteraction(this.entity.method_5628(), C2SNPCInteraction.Type.TALK));
            this.field_22787.method_1507(null);
        }));
        if (this.canFollow) {
            this.method_37063((class_364)new class_4185(this.leftPos + x, this.topPos + (y += 30), xSize, 20, (class_2561)new class_2588(C2SNPCInteraction.Type.FOLLOW.translation), b -> {
                Platform.INSTANCE.sendToServer(new C2SNPCInteraction(this.entity.method_5628(), C2SNPCInteraction.Type.FOLLOW));
                this.field_22787.method_1507(null);
            }));
        }
        if (!this.entity.method_6109() && this.isShopOpen == ShopState.OPEN) {
            if (((EntityNPCBase)this.entity).getShop().hasShop) {
                this.method_37063((class_364)new class_4185(this.leftPos + x, this.topPos + (y += 30), xSize, 20, (class_2561)new class_2588(C2SNPCInteraction.Type.SHOP.translation), b -> {
                    Platform.INSTANCE.sendToServer(new C2SNPCInteraction(this.entity.method_5628(), C2SNPCInteraction.Type.SHOP));
                    this.field_22787.method_1507(null);
                }));
            }
            for (Map.Entry<String, List<class_2561>> action : this.actions.entrySet()) {
                this.method_37063((class_364)new class_4185(this.leftPos + x, this.topPos + (y += 30), xSize, 20, (class_2561)new class_2588(action.getKey()), b -> {
                    Platform.INSTANCE.sendToServer(new C2SNPCInteraction(this.entity.method_5628(), (String)action.getKey()));
                    this.field_22787.method_1507(null);
                }));
                int tooltipX = this.leftPos + x;
                int tooltipY = this.topPos + y;
                this.tooltipComponents.add((stack, mouseX, mouseY) -> {
                    if (this.isHovering(tooltipX, tooltipY, xSize, 20, mouseX, mouseY)) {
                        this.method_32634(stack, (List)action.getValue(), Optional.empty(), mouseX, mouseY);
                    }
                });
            }
        }
        if (this.quest != null) {
            this.method_37063((class_364)new class_4185(this.leftPos + x, this.topPos + (y += 30), xSize, 20, (class_2561)new class_2588(C2SNPCInteraction.Type.QUEST.translation), b -> {
                Platform.INSTANCE.sendToServer(new C2SNPCInteraction(this.entity.method_5628(), C2SNPCInteraction.Type.QUEST, this.quest.toString()));
                this.field_22787.method_1507(null);
            }));
        }
        if (!this.entity.method_6109() && this.family.canProcreate()) {
            this.method_37063((class_364)new class_4185(this.leftPos + x, this.topPos + (y += 30), xSize, 20, (class_2561)new class_2588("runecraftory.gui.npc.procreate"), b -> {
                Platform.INSTANCE.sendToServer(new C2SProcreationRequest(this.entity.method_5628()));
                this.field_22787.method_1507(null);
            }));
        }
        if (this.isShopOpen == ShopState.NOBED) {
            this.components = new ArrayList<class_5481>();
            this.components.addAll(this.field_22793.method_1728((class_5348)new class_2588("runecraftory.gui.npc.bed.no"), 150));
        }
        if (!this.entity.method_6109() && this.isShopOpen == ShopState.NOWORKPLACE && ((EntityNPCBase)this.entity).getShop().poiType != null && ((EntityNPCBase)this.entity).getShop().poiType.get() != null) {
            this.components = new ArrayList<class_5481>();
            this.components.addAll(this.field_22793.method_1728((class_5348)new class_2588("runecraftory.gui.npc.workplace.no", new Object[]{this.formatShopPoi(((EntityNPCBase)this.entity).getShop().poiType.get())}), 150));
        }
    }

    private class_2561 formatShopPoi(class_4158 poiType) {
        HashSet<class_2680> set = new HashSet<class_2680>(((PoiTypeAccessor)poiType).matches());
        if (((EntityNPCBase)this.entity).getShop().predicate != null && ((EntityNPCBase)this.entity).getShop().predicate.test((class_4158)ModPoiTypes.CASH_REGISTER.get())) {
            set.addAll(((PoiTypeAccessor)ModPoiTypes.CASH_REGISTER.get()).matches());
        }
        class_2585 comp = new class_2585("");
        set.stream().map(class_4970.class_4971::method_26204).distinct().map(class_2248::method_9518).forEach(arg_0 -> NPCGui.lambda$formatShopPoi$8((class_5250)comp, arg_0));
        return comp.method_27692(class_124.field_1075);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return true;
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)(x - 1) && mouseX < (double)(x + width + 1) && mouseY >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public void method_25432() {
        super.method_25432();
        Platform.INSTANCE.sendToServer(new C2SNPCInteraction(this.entity.method_5628(), C2SNPCInteraction.Type.CLOSE));
    }

    private static /* synthetic */ void lambda$formatShopPoi$8(class_5250 comp, class_5250 c) {
        if (comp.method_10855().isEmpty()) {
            comp.method_10852((class_2561)c);
        } else {
            comp.method_10852((class_2561)new class_2585(", ").method_10852((class_2561)c));
        }
    }

    static interface ToolTipRenderer {
        public void render(class_4587 var1, int var2, int var3);
    }
}

