/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.npc.NPCTextureLayer;
import io.github.flemmli97.runecraftory.client.npc.RenderNPC;
import io.github.flemmli97.runecraftory.common.network.C2SQuestSelect;
import io.github.flemmli97.runecraftory.common.network.C2SSubmitQuestBoard;
import io.github.flemmli97.runecraftory.common.quests.ClientSideQuestDisplay;
import io.github.flemmli97.runecraftory.common.registry.ModNPCLooks;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class QuestGui
extends class_437 {
    protected static final class_2960 TEXTUREPATH = new class_2960("runecraftory", "textures/gui/quest_gui.png");
    protected static final class_2960 TEXTUREPATH_WIDGETS = new class_2960("runecraftory", "textures/gui/quest_gui_widgets.png");
    private final int textureX = 238;
    private final int textureY = 175;
    protected int leftPos;
    protected int topPos;
    protected final List<ClientSideQuestDisplay> quests;
    protected final List<Pair<String, List<Pair<Integer, class_2960>>>> heads;
    private Rect scrollBar = new Rect(212, 14, 12, 147);
    private Rect scrollArea = new Rect(14, 14, 210, 147);
    private final QuestButton[] questButtons = new QuestButton[7];
    private QuestSelectButton yesButton;
    private QuestSelectButton noButton;
    private int scrollValue;
    private boolean isDragging;
    private ClientSideQuestDisplay selectedQuest;
    private final boolean hasActive;

    public QuestGui(boolean hasActive, List<ClientSideQuestDisplay> quests) {
        super((class_2561)new class_2585(""));
        this.hasActive = hasActive;
        this.quests = quests;
        this.heads = this.quests.stream().map(display -> {
            ArrayList<Pair> textures = new ArrayList<Pair>();
            if (display.features() != null) {
                for (NPCTextureLayer.LayerType layerType : NPCTextureLayer.LayerType.values()) {
                    class_2960 text = RenderNPC.getTextureFromLook(display.features(), display.features().view.containsKey(ModNPCLooks.SLIM.get()), layerType, null);
                    if (text.equals((Object)RenderNPC.EMPTY)) continue;
                    textures.add(Pair.of((Object)NPCTextureLayer.color(display.features(), layerType), (Object)text));
                }
            }
            return Pair.of((Object)display.npcSkin(), textures);
        }).toList();
    }

    protected void method_25426() {
        super.method_25426();
        this.leftPos = (this.field_22789 - this.textureX) / 2;
        this.topPos = (this.field_22790 - this.textureY) / 2;
        this.yesButton = new QuestSelectButton(this.leftPos + 57, this.topPos + 92, false, b -> {
            Platform.INSTANCE.sendToServer(new C2SQuestSelect(this.selectedQuest.id(), this.selectedQuest.active()));
            class_310.method_1551().method_1507(null);
        });
        this.method_37063((class_364)this.yesButton);
        this.noButton = new QuestSelectButton(this.leftPos + 137, this.topPos + 92, true, b -> {
            this.selectedQuest = null;
            this.yesButton.field_22764 = false;
            this.noButton.field_22764 = false;
        });
        this.method_37063((class_364)this.noButton);
        ((SubmitButton)this.method_37063((class_364)(QuestGui)this.new SubmitButton((int)(this.leftPos + 238), (int)(this.topPos + 153), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$init$3(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)()))).field_22763 = this.hasActive;
        for (int i = 0; i < 7; ++i) {
            this.questButtons[i] = new QuestButton(this.leftPos + 14, this.topPos + 14 + i * 21, i, b -> {
                if (b instanceof QuestButton) {
                    QuestButton but = (QuestButton)b;
                    this.selectedQuest = this.quests.get(but.getActualIndex());
                    this.yesButton.field_22764 = true;
                    this.noButton.field_22764 = true;
                }
            });
            this.method_37063((class_364)this.questButtons[i]);
        }
        this.scrollBar = new Rect(this.leftPos + this.scrollBar.x, this.topPos + this.scrollBar.y, this.scrollBar.width, this.scrollBar.height);
        this.scrollArea = new Rect(this.leftPos + this.scrollArea.x, this.topPos + this.scrollArea.y, this.scrollArea.width, this.scrollArea.height);
    }

    public void method_25420(class_4587 stack) {
        super.method_25420(stack);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTUREPATH);
        this.method_25302(stack, this.leftPos, this.topPos, 0, 0, this.textureX, this.textureY);
    }

    public void method_25394(class_4587 stack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(stack);
        for (QuestButton button : this.questButtons) {
            button.field_22764 = button.index < this.quests.size();
            button.field_22763 = this.selectedQuest == null;
        }
        super.method_25394(stack, mouseX, mouseY, partialTicks);
        if (this.selectedQuest != null) {
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTUREPATH_WIDGETS);
            this.method_25302(stack, this.leftPos + 52, this.topPos + 56, 13, 25, 134, 63);
            ClientHandlers.drawCenteredScaledString(stack, this.field_22793, (class_2561)(this.selectedQuest.active() ? new class_2588("runecraftory.gui.quests.reset").method_27692(class_124.field_1061) : new class_2588("runecraftory.gui.quests.accept")), (float)(this.leftPos + 52 + 67), (float)(this.topPos + 61), 1.0f, 0);
        }
        this.yesButton.renderButtonSelect(stack);
        this.noButton.renderButtonSelect(stack);
        this.renderScroller(stack, this.scrollBar.x, this.scrollBar.y);
    }

    public boolean method_25421() {
        return false;
    }

    private void renderScroller(class_4587 poseStack, int posX, int posY) {
        int steps = this.quests.size() - 7;
        int widgetHeight = 21;
        if (steps > 0) {
            int barHeight = this.scrollBar.height - 2;
            int moveableHeight = barHeight - widgetHeight;
            int k = moveableHeight / steps;
            int yOffset = class_3532.method_15340((int)(this.scrollValue * k), (int)0, (int)moveableHeight);
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTUREPATH_WIDGETS);
            this.method_25302(poseStack, posX, posY + yOffset, 0, 51, 12, widgetHeight);
        }
    }

    private boolean canScroll() {
        return this.quests.size() > 7;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.canScroll() && this.scrollArea.isMouseOver(mouseX, mouseY)) {
            this.setScrollValue((int)((double)this.scrollValue - delta));
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging) {
            int maxY = this.scrollBar.y + this.scrollBar.height - 3;
            int max = this.quests.size() - 7;
            float amount = ((float)mouseY - (float)this.scrollBar.y - 13.5f) / ((float)(maxY - this.scrollBar.y) - 27.0f);
            amount = amount * (float)max + 0.5f;
            this.scrollValue = class_3532.method_15340((int)((int)amount), (int)0, (int)max);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.isDragging = this.canScroll() && this.scrollBar.isMouseOver(mouseX, mouseY);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return true;
    }

    public void method_25432() {
        super.method_25432();
        Platform.INSTANCE.sendToServer(new C2SQuestSelect());
    }

    public void setScrollValue(int val) {
        this.scrollValue = class_3532.method_15340((int)val, (int)0, (int)Math.max(0, this.quests.size() - 7));
    }

    private static /* synthetic */ void lambda$init$3(class_4185 b) {
        Platform.INSTANCE.sendToServer(new C2SSubmitQuestBoard());
        class_310.method_1551().method_1507(null);
    }

    record Rect(int x, int y, int width, int height) {
        public boolean isMouseOver(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
        }
    }

    private class QuestButton
    extends class_4185 {
        private final int index;

        public QuestButton(int i, int j, int k, class_4185.class_4241 onPress) {
            super(i, j, 198, 21, class_2585.field_24366, onPress);
            this.index = k;
            this.field_22764 = false;
        }

        public int getActualIndex() {
            return this.index + QuestGui.this.scrollValue;
        }

        public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
            if (this.getActualIndex() >= QuestGui.this.quests.size()) {
                return;
            }
            if (this.method_25367() && QuestGui.this.selectedQuest == null) {
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderTexture((int)0, (class_2960)TEXTUREPATH_WIDGETS);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableDepthTest();
                this.method_25302(poseStack, this.field_22760, this.field_22761, 0, 0, this.field_22758, this.field_22759);
            }
            ClientSideQuestDisplay display = QuestGui.this.quests.get(this.getActualIndex());
            Pair<String, List<Pair<Integer, class_2960>>> head = QuestGui.this.heads.get(this.getActualIndex());
            int offset = RenderNPC.renderForTooltip(poseStack, this.field_22760 + 2, this.field_22761 + 2, (String)head.getFirst(), (List)head.getSecond()) ? 18 : 0;
            class_310.method_1551().field_1772.method_30883(poseStack, display.task(), (float)(this.field_22760 + 2 + offset), (float)(this.field_22761 + 6), display.active() ? 5341699 : 0);
            this.method_25352(poseStack, mouseX, mouseY);
        }

        public void method_25352(class_4587 poseStack, int relativeMouseX, int relativeMouseY) {
            List<? extends class_2561> description;
            if (this.field_22762 && this.getActualIndex() < QuestGui.this.quests.size() && QuestGui.this.selectedQuest == null && !(description = QuestGui.this.quests.get(this.getActualIndex()).description()).isEmpty()) {
                QuestGui.this.method_32634(poseStack, description, Optional.empty(), relativeMouseX, relativeMouseY + 24);
            }
        }
    }

    private static class QuestSelectButton
    extends class_4185 {
        private final boolean red;

        public QuestSelectButton(int i, int j, boolean red, class_4185.class_4241 onPress) {
            super(i, j, 44, 22, (class_2561)(red ? new class_2588("runecraftory.generic.no") : new class_2588("runecraftory.generic.yes")), onPress);
            this.field_22764 = false;
            this.red = red;
        }

        public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        }

        public void renderButtonSelect(class_4587 poseStack) {
            if (!this.field_22764) {
                return;
            }
            class_310 minecraft = class_310.method_1551();
            class_327 font = minecraft.field_1772;
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTUREPATH_WIDGETS);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
            int i = this.method_25367() ? 1 : 0;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            this.method_25302(poseStack, this.field_22760, this.field_22761, 150 + i * 47, 26 + (this.red ? 24 : 0), this.field_22758, this.field_22759);
            ClientHandlers.drawCenteredScaledString(poseStack, font, this.method_25369(), (float)this.field_22760 + (float)this.field_22758 / 2.0f, (float)this.field_22761 + (float)(this.field_22759 - 8) / 2.0f, 1.0f, 0);
        }
    }

    private class SubmitButton
    extends class_4185 {
        public SubmitButton(int i, int j, class_4185.class_4241 onPress) {
            super(i, j, 20, 22, class_2585.field_24366, onPress);
        }

        public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
            class_310 minecraft = class_310.method_1551();
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTUREPATH_WIDGETS);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
            int i = this.method_25356(this.method_25367());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            this.method_25302(poseStack, this.field_22760, this.field_22761, i * 22, 98, this.field_22758, this.field_22759);
            this.method_25353(poseStack, minecraft, mouseX, mouseY);
            this.method_25352(poseStack, mouseX, mouseY);
        }

        public void method_25352(class_4587 poseStack, int relativeMouseX, int relativeMouseY) {
            if (this.field_22762 && this.field_22763) {
                QuestGui.this.method_25424(poseStack, (class_2561)new class_2588("runecraftory.gui.quest.submit.button"), relativeMouseX, relativeMouseY + 24);
            }
        }
    }
}

