/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.npc;

import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.client.npc.NPCFeatureRenderer;
import io.github.flemmli97.runecraftory.client.npc.SizeRenderer;
import io.github.flemmli97.runecraftory.common.registry.ModNPCLooks;
import java.util.HashMap;
import java.util.Map;

public class NPCFeatureRenderers {
    private static final Map<NPCFeatureType<?>, NPCFeatureRenderer<?>> RENDERERS = new HashMap();

    public static void init() {
        NPCFeatureRenderers.empty((NPCFeatureType)((Object)ModNPCLooks.SLIM.get()));
        NPCFeatureRenderers.register((NPCFeatureType)((Object)ModNPCLooks.SIZE.get()), new SizeRenderer());
        NPCFeatureRenderers.empty((NPCFeatureType)((Object)ModNPCLooks.SKIN.get()));
        NPCFeatureRenderers.empty((NPCFeatureType)((Object)ModNPCLooks.FACE.get()));
        NPCFeatureRenderers.empty((NPCFeatureType)((Object)ModNPCLooks.BLUSH.get()));
        NPCFeatureRenderers.empty((NPCFeatureType)((Object)ModNPCLooks.HAIR.get()));
        NPCFeatureRenderers.empty((NPCFeatureType)((Object)ModNPCLooks.OUTFIT.get()));
        NPCFeatureRenderers.empty((NPCFeatureType)((Object)ModNPCLooks.HAT.get()));
    }

    public static synchronized <F extends NPCFeature> void empty(NPCFeatureType<F> type) {
        RENDERERS.put(type, NPCFeatureRenderer.EMPTY);
    }

    public static synchronized <F extends NPCFeature> void register(NPCFeatureType<F> type, NPCFeatureRenderer<F> renderer) {
        RENDERERS.put(type, renderer);
    }

    public static <T extends NPCFeature> NPCFeatureRenderer<T> get(NPCFeature feature) {
        NPCFeatureRenderer<?> renderer = RENDERERS.get(feature.getType());
        if (renderer == null) {
            throw new IllegalStateException("No npc feature renderer registered for " + String.valueOf(feature));
        }
        return renderer;
    }
}

