/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.npc;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCLook;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.client.npc.NPCArmorLayer;
import io.github.flemmli97.runecraftory.client.npc.NPCFaceLayer;
import io.github.flemmli97.runecraftory.client.npc.NPCFeatureRenderers;
import io.github.flemmli97.runecraftory.client.npc.NPCTextureLayer;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.features.BlushFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.FaceFeaturesType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.HairFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.IndexedColorSettingType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import io.github.flemmli97.runecraftory.common.entities.npc.features.OutfitFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.SimpleHatFeatureType;
import io.github.flemmli97.runecraftory.common.registry.ModNPCLooks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1068;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1921;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_927;
import net.minecraft.class_989;
import org.jetbrains.annotations.Nullable;

public class RenderNPC<T extends EntityNPCBase>
extends class_927<T, class_591<T>> {
    private static final Map<String, PlayerSkin> PLAYER_SKIN_TEXTURE_LOCATIONS = new HashMap<String, PlayerSkin>();
    private static final Map<String, class_2960> TEXTURE_LAYERS_LOCATIONS = new HashMap<String, class_2960>();
    public static final class_2960 EMPTY = new class_2960("runecraftory", "textures/entity/npc/empty.png");
    public final NPCArmorLayer<T, class_591<T>, class_572<T>> armorLayer;
    public final NPCArmorLayer<T, class_591<T>, class_572<T>> armorLayerSlim;
    public final List<NPCTextureLayer<T, class_591<T>, class_591<T>>> textureLayers = new ArrayList<NPCTextureLayer<T, class_591<T>, class_591<T>>>();

    public RenderNPC(class_5617.class_5618 ctx) {
        super(ctx, (class_583)new class_591(ctx.method_32167(class_5602.field_27577), false), 0.5f);
        this.armorLayer = new NPCArmorLayer(this, new class_572(ctx.method_32167(class_5602.field_27579)), new class_572(ctx.method_32167(class_5602.field_27580)));
        this.method_4046((class_3887)this.armorLayer);
        this.armorLayerSlim = new NPCArmorLayer(this, new class_572(ctx.method_32167(class_5602.field_27582)), new class_572(ctx.method_32167(class_5602.field_27583)));
        this.method_4046((class_3887)this.armorLayerSlim);
        this.method_4046((class_3887)new class_989((class_3883)this));
        for (NPCTextureLayer.LayerType layerType : NPCTextureLayer.LayerType.values()) {
            if (layerType.location == null) continue;
            if (layerType == NPCTextureLayer.LayerType.SKIN_LAYER) {
                this.textureLayers.add(new NPCTextureLayer(this, (class_591)this.field_4737, new class_591(ctx.method_32167(class_5602.field_27581), true), layerType));
                continue;
            }
            if (layerType == NPCTextureLayer.LayerType.IRIS_LAYER) {
                this.textureLayers.add(new NPCFaceLayer(this, new class_591(ctx.method_32167(layerType.location), false), new class_591(ctx.method_32167(layerType.slimLocation), true)));
                continue;
            }
            this.textureLayers.add(new NPCTextureLayer(this, new class_591(ctx.method_32167(layerType.location), false), new class_591(ctx.method_32167(layerType.slimLocation), true), layerType));
        }
        this.textureLayers.forEach(x$0 -> this.method_4046((class_3887)x$0));
    }

    public static boolean isSlim(EntityNPCBase npc) {
        String skin = npc.getLook().playerSkin();
        if (skin != null) {
            String skinMeta = PLAYER_SKIN_TEXTURE_LOCATIONS.computeIfAbsent(skin, s -> new PlayerSkin(skin)).getSkinMeta();
            return skinMeta.equals("slim");
        }
        return npc.lookFeatures.view.containsKey(ModNPCLooks.SLIM.get());
    }

    public static class_2960 getTextureFromLook(EntityNPCBase npc, NPCTextureLayer.LayerType type, @Nullable String subType) {
        NPCLook look = npc.getLook();
        if (type == NPCTextureLayer.LayerType.SKIN_LAYER) {
            if (look == NPCLook.DEFAULT_LOOK) {
                return class_1068.method_4648((UUID)npc.method_5667());
            }
            String skin = look.playerSkin();
            if (skin != null) {
                return PLAYER_SKIN_TEXTURE_LOCATIONS.computeIfAbsent(skin, s -> new PlayerSkin(skin)).getLocation();
            }
        } else if (look.playerSkin() != null || look == NPCLook.DEFAULT_LOOK) {
            return EMPTY;
        }
        boolean slim = RenderNPC.isSlim(npc);
        if (type == NPCTextureLayer.LayerType.HAT_LAYER && npc.method_6084(class_1304.field_6169)) {
            return EMPTY;
        }
        return RenderNPC.getTextureFromLook(npc.lookFeatures, slim, type, subType);
    }

    public static class_2960 getTextureFromLook(NPCFeatureContainer features, boolean slim, NPCTextureLayer.LayerType type, @Nullable String subType) {
        class_2960 texture = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NPCTextureLayer.LayerType.SKIN_LAYER -> {
                NPCFeature feat = (IndexedColorSettingType.IndexedColorFeature)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.SKIN.get()));
                int num = 0;
                if (feat != null) {
                    num = ((IndexedColorSettingType.IndexedColorFeature)feat).index;
                }
                String location = String.format("textures/entity/npc/skin/%s%s.png", slim ? "slim_" : "", num);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RenderNPC::modLoc);
            }
            case NPCTextureLayer.LayerType.IRIS_LAYER -> {
                NPCFeature feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.FACE.get()));
                int num = 0;
                if (feat != null) {
                    num = ((FaceFeaturesType.FaceFeatures)feat).iris.index();
                    if (subType != null) {
                        subType = ((FaceFeaturesType.FaceFeatures)feat).expressionTexture(features, subType, FaceFeaturesType.ExpressionType.IRIS);
                    }
                }
                String location = String.format("textures/entity/npc/eye/iris_%s%s.png", num, subType != null ? "_" + subType : "");
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RenderNPC::modLoc);
            }
            case NPCTextureLayer.LayerType.SCLERA_LAYER -> {
                NPCFeature feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.FACE.get()));
                int num = 0;
                if (feat != null) {
                    num = ((FaceFeaturesType.FaceFeatures)feat).sclera.index();
                    if (subType != null) {
                        subType = ((FaceFeaturesType.FaceFeatures)feat).expressionTexture(features, subType, FaceFeaturesType.ExpressionType.SCLERA);
                    }
                }
                String location = String.format("textures/entity/npc/eye/sclera_%s%s.png", num, subType != null ? "_" + subType : "");
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RenderNPC::modLoc);
            }
            case NPCTextureLayer.LayerType.EYEBROWS_LAYER -> {
                NPCFeature feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.FACE.get()));
                int num = 0;
                if (feat != null) {
                    num = ((FaceFeaturesType.FaceFeatures)feat).eyebrow.index();
                    if (subType != null) {
                        subType = ((FaceFeaturesType.FaceFeatures)feat).expressionTexture(features, subType, FaceFeaturesType.ExpressionType.EYEBROWS);
                    }
                }
                String location = String.format("textures/entity/npc/eye/eyebrows_%s%s.png", num, subType != null ? "_" + subType : "");
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RenderNPC::modLoc);
            }
            case NPCTextureLayer.LayerType.BLUSH_LAYER -> {
                NPCFeature feat = (BlushFeatureType.BlushFeature)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.BLUSH.get()));
                if (feat == null || !((BlushFeatureType.BlushFeature)feat).blush) {
                    yield null;
                }
                String location = "textures/entity/npc/misc/blush.png";
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RenderNPC::modLoc);
            }
            case NPCTextureLayer.LayerType.OUTFIT_LAYER -> {
                NPCFeature feat = (OutfitFeatureType.OutfitFeature)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.OUTFIT.get()));
                String location = String.format("textures/entity/npc/outfit/generic%s_0.png", slim ? "_slim" : "");
                if (feat != null) {
                    location = String.format("textures/entity/npc/outfit/%s%s_%s.png", ((OutfitFeatureType.OutfitFeature)feat).type, slim ? "_slim" : "", ((OutfitFeatureType.OutfitFeature)feat).index);
                }
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RenderNPC::modLoc);
            }
            case NPCTextureLayer.LayerType.HAIR_LAYER -> {
                NPCFeature feat = (HairFeatureType.HairFeature)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.HAIR.get()));
                if (feat == null) {
                    yield null;
                }
                String location = String.format("textures/entity/npc/hair/%s_%s.png", ((HairFeatureType.HairFeature)feat).type, ((HairFeatureType.HairFeature)feat).index);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RenderNPC::modLoc);
            }
            case NPCTextureLayer.LayerType.HAT_LAYER -> {
                NPCFeature feat = (SimpleHatFeatureType.SimpleHatFeature)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.HAT.get()));
                if (feat == null || ((SimpleHatFeatureType.SimpleHatFeature)feat).hat.isEmpty()) {
                    yield null;
                }
                String location = String.format("textures/entity/npc/misc/%s.png", ((SimpleHatFeatureType.SimpleHatFeature)feat).hat);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RenderNPC::modLoc);
            }
        };
        return texture == null ? EMPTY : texture;
    }

    private static class_2960 modLoc(String s) {
        return new class_2960("runecraftory", s);
    }

    public static boolean renderForTooltip(class_4587 stack, int x, int y, @Nullable String skin, List<Pair<Integer, class_2960>> textures) {
        if (skin == null && textures == null) {
            return false;
        }
        int sizeX = 16;
        int sizeY = 16;
        if (skin != null) {
            class_2960 res = PLAYER_SKIN_TEXTURE_LOCATIONS.computeIfAbsent(skin, s -> new PlayerSkin(skin)).getLocation();
            RenderSystem.setShaderTexture((int)0, (class_2960)res);
            class_332.method_25293((class_4587)stack, (int)x, (int)y, (int)sizeX, (int)sizeY, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.enableBlend();
            class_332.method_25293((class_4587)stack, (int)x, (int)y, (int)sizeX, (int)sizeY, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.disableBlend();
        } else {
            for (Pair<Integer, class_2960> layer : textures) {
                int color = (Integer)layer.getFirst();
                float a = (float)(color >> 24 & 0xFF) / 255.0f;
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
                RenderSystem.setShaderTexture((int)0, (class_2960)((class_2960)layer.getSecond()));
                class_332.method_25293((class_4587)stack, (int)x, (int)y, (int)sizeX, (int)sizeY, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
                RenderSystem.enableBlend();
                class_332.method_25293((class_4587)stack, (int)x, (int)y, (int)sizeX, (int)sizeY, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
                RenderSystem.disableBlend();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return true;
    }

    protected boolean shouldShowName(T entity) {
        return false;
    }

    public void render(T entity, float entityYaw, float partialTicks, class_4587 stack, class_4597 buffer, int packedLight) {
        boolean slim = RenderNPC.isSlim(entity);
        this.armorLayer.setRender(!slim);
        this.armorLayerSlim.setRender(slim);
        for (NPCFeature feature : ((EntityNPCBase)entity).lookFeatures.view.values()) {
            NPCFeatureRenderers.get(feature).onSetup(feature, this, entity, stack);
        }
        this.setModelProperties((EntityNPCBase)entity);
        super.method_4072(entity, entityYaw, partialTicks, stack, buffer, packedLight);
        for (NPCFeature feature : ((EntityNPCBase)entity).lookFeatures.view.values()) {
            NPCFeatureRenderers.get(feature).render(feature, (EntityNPCBase)entity, entityYaw, partialTicks, stack, buffer, packedLight);
        }
    }

    private void setModelProperties(EntityNPCBase npc) {
        class_591 playerModel = (class_591)this.method_4038();
        playerModel.method_2805(true);
        playerModel.field_3400 = npc.method_18276();
        class_572.class_573 main = RenderNPC.getArmPose(npc, class_1268.field_5808);
        class_572.class_573 off = RenderNPC.getArmPose(npc, class_1268.field_5810);
        if (npc.method_6068() == class_1306.field_6183) {
            playerModel.field_3395 = main;
            playerModel.field_3399 = off;
        } else {
            playerModel.field_3395 = off;
            playerModel.field_3399 = main;
        }
    }

    private static class_572.class_573 getArmPose(EntityNPCBase npc, class_1268 hand) {
        class_1799 itemStack = npc.method_5998(hand);
        if (itemStack.method_7960()) {
            return class_572.class_573.field_3409;
        }
        if (npc.method_6058() == hand && npc.method_6014() > 0) {
            class_1839 useAnim = itemStack.method_7976();
            if (useAnim == class_1839.field_8949) {
                return class_572.class_573.field_3406;
            }
            if (useAnim == class_1839.field_8953) {
                return class_572.class_573.field_3403;
            }
            if (useAnim == class_1839.field_8951) {
                return class_572.class_573.field_3407;
            }
            if (useAnim == class_1839.field_8947 && hand == npc.method_6058()) {
                return class_572.class_573.field_3405;
            }
            if (useAnim == class_1839.field_27079) {
                return class_572.class_573.field_27434;
            }
        } else if (!npc.field_6252 && itemStack.method_31574(class_1802.field_8399) && class_1764.method_7781((class_1799)itemStack)) {
            return class_572.class_573.field_3408;
        }
        return class_572.class_573.field_3410;
    }

    public class_2960 getTextureLocation(T entity) {
        return RenderNPC.getTextureFromLook(entity, NPCTextureLayer.LayerType.SKIN_LAYER, null);
    }

    protected void setupRotations(T entity, class_4587 stack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.method_4058(entity, stack, ageInTicks, rotationYaw, partialTicks);
        if (((EntityNPCBase)entity).getPlayDeathTick() > 0) {
            float f;
            float partial = partialTicks - 1.0f;
            float f2 = ((float)((EntityNPCBase)entity).getPlayDeathTick() + (((EntityNPCBase)entity).playDeath() ? partial : -partial)) / 20.0f * 1.6f;
            f2 = class_3532.method_15355((float)f2);
            if (f > 1.0f) {
                f2 = 1.0f;
            }
            stack.method_22904(0.0, (double)f2 * 0.1, (double)(-f2 * entity.method_17682()) * 0.5);
            stack.method_22907(class_1160.field_20703.method_23214(f2 * this.method_4039((class_1309)entity)));
        }
        for (NPCFeature feature : ((EntityNPCBase)entity).lookFeatures.view.values()) {
            NPCFeatureRenderers.get(feature).transformStack(feature, this, entity, stack, partialTicks);
        }
    }

    protected void scale(T livingEntity, class_4587 matrixStack, float partialTickTime) {
        matrixStack.method_22905(0.9375f, 0.9375f, 0.9375f);
    }

    @Nullable
    protected class_1921 getRenderType(T entity, boolean invis, boolean translucent, boolean glowing) {
        return null;
    }

    static class PlayerSkin {
        private GameProfile gameProfile;
        private class_2960 location = class_1068.method_4649();
        private String skinMeta = "";
        private boolean pendingTextures;

        public PlayerSkin(String name) {
            class_2631.method_11335((GameProfile)new GameProfile(null, name), prof -> {
                this.gameProfile = prof;
            });
        }

        public class_2960 getLocation() {
            this.registerTextures();
            return this.location;
        }

        public String getSkinMeta() {
            this.registerTextures();
            return this.skinMeta;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void registerTextures() {
            PlayerSkin playerSkin = this;
            synchronized (playerSkin) {
                if (!this.pendingTextures && this.gameProfile != null) {
                    this.pendingTextures = true;
                    class_310.method_1551().method_1582().method_4652(this.gameProfile, (type, resourceLocation, minecraftProfileTexture) -> {
                        if (type == MinecraftProfileTexture.Type.SKIN) {
                            String metadata = minecraftProfileTexture.getMetadata("model");
                            if (metadata == null) {
                                metadata = "default";
                            }
                            this.location = resourceLocation;
                            this.skinMeta = metadata;
                        }
                    }, true);
                }
            }
        }
    }
}

