/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.particles;

import com.google.common.base.Suppliers;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.model.monster.ModelSkelefang;
import io.github.flemmli97.runecraftory.client.particles.CustomParticleRenderTypes;
import io.github.flemmli97.runecraftory.client.render.monster.RenderSkelefang;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.EntitySkelefang;
import io.github.flemmli97.runecraftory.common.particles.SkelefangParticleData;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.PoseExtended;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import java.util.function.Supplier;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_765;

public class SkelefangParticle
extends class_703 {
    private static final Supplier<ModelSkelefang<EntitySkelefang>> MODEL = Suppliers.memoize(() -> {
        ModelSkelefang model = new ModelSkelefang(class_310.method_1551().method_31974().method_32072(ModelSkelefang.LAYER_LOCATION), class_1921::method_23689);
        model.body.loadPoseRecursive(PoseExtended.ZERO);
        return model;
    });
    private static final Supplier<class_1921> RENDER_TYPE = Suppliers.memoize(() -> MODEL.get().method_23500(RenderSkelefang.TEXTURE));
    private final SkelefangParticleData.SkelefangBoneType boneType;
    private final float initialRotX;
    private final float initialRotY;
    private final float pitchSpin;
    private final float yawSpin;
    private int groundTick;
    private float cameraLastPitch;
    private float cameraLastYaw;
    private boolean first = true;

    public SkelefangParticle(class_638 world, double x, double y, double z, double dirX, double dirY, double dirZ, SkelefangParticleData data) {
        super(world, x, y, z);
        ModelPartHandler.ModelPartExtended[] parts;
        this.method_34753(dirX, dirY, dirZ);
        if (data.hasGravity()) {
            this.field_3844 = 1.0f;
        }
        this.field_28787 = false;
        this.boneType = data.getBoneType();
        this.initialRotX = data.getInitialRotX();
        this.initialRotY = data.getInitialRotY();
        this.pitchSpin = data.getPitchSpin();
        this.yawSpin = data.getYawSpin();
        this.field_3847 = data.getMaxTime();
        switch (this.boneType) {
            case TAIL: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[4];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineBack;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.get().tailBase;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[3] = SkelefangParticle.MODEL.get().tail;
                break;
            }
            case TAIL_BASE: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineBack;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.get().tailBase;
                break;
            }
            case LEFT_LEG: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineBack;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.get().leftLegBase;
                break;
            }
            case RIGHT_LEG: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineBack;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.get().rightLegBase;
                break;
            }
            case HEAD: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[4];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineFront;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.get().neck;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[3] = SkelefangParticle.MODEL.get().head;
                break;
            }
            case NECK: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineFront;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.get().neck;
                break;
            }
            case BACK: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[2];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineBack;
                break;
            }
            case BACK_RIBS: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineBack;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.get().ribsSpine;
                break;
            }
            case FRONT: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[2];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineFront;
                break;
            }
            case FRONT_RIBS: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineFront;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.get().ribsBody;
                break;
            }
            default: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = parts = null;
            }
        }
        if (parts != null) {
            double mX = 0.0;
            double mY = 0.0;
            double mZ = 0.0;
            for (ModelPartHandler.ModelPartExtended part : parts) {
                mX += (double)part.x;
                mY += (double)part.y;
                mZ += (double)part.z;
            }
            double[] offset = MathUtils.rotate((double)0.0, (double)1.0, (double)0.0, (double)mX, (double)(mY - 22.75), (double)mZ, (float)((float)Math.PI / 180 * class_3532.method_15393((float)this.initialRotY)));
            this.method_3063(this.field_3874 + offset[0] * 1.0 / 16.0, this.field_3854 - offset[1] * 1.0 / 16.0, this.field_3871 - offset[2] * 1.0 / 16.0);
            this.field_3858 = this.field_3874;
            this.field_3838 = this.field_3854;
            this.field_3856 = this.field_3871;
        }
    }

    public void method_3070() {
        super.method_3070();
        if (this.field_3845 && this.groundTick == 0) {
            this.groundTick = this.field_3866;
        }
    }

    public void method_3074(class_4588 buffer, class_4184 renderInfo, float partialTicks) {
        int spinAge;
        int next;
        if (this.first) {
            this.cameraLastPitch = renderInfo.method_19329();
            this.cameraLastYaw = renderInfo.method_19330() - 180.0f;
            this.first = false;
        }
        class_243 vec3 = renderInfo.method_19326();
        float x = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874) - vec3.method_10216());
        float y = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854) - vec3.method_10214());
        float z = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871) - vec3.method_10215());
        class_4587 stack = new class_4587();
        this.irisFix(stack, renderInfo, partialTicks);
        stack.method_22904((double)x, (double)y, (double)z);
        if (this.groundTick > 0 && this.field_3866 > this.groundTick) {
            next = this.groundTick;
            spinAge = this.groundTick;
        } else {
            next = this.field_3866 + 1;
            spinAge = this.field_3866;
        }
        float yaw = class_3532.method_16439((float)partialTicks, (float)(this.initialRotY + this.yawSpin * (float)spinAge), (float)(this.initialRotY + this.yawSpin * (float)next));
        float pitch = class_3532.method_16439((float)partialTicks, (float)(this.initialRotX + this.pitchSpin * (float)spinAge), (float)(this.initialRotX + this.pitchSpin * (float)next));
        stack.method_22907(class_1160.field_20705.method_23214(180.0f - yaw));
        stack.method_22907(class_1160.field_20703.method_23214(pitch));
        stack.method_22905(-1.0f, -1.0f, 1.0f);
        stack.method_22904(0.0, -1.5, 0.0);
        class_1921 type = RENDER_TYPE.get();
        CustomParticleRenderTypes.batchType(type);
        class_4588 consumer = class_310.method_1551().method_22940().method_23000().getBuffer(type);
        float alpha = 0.9f - (float)this.field_3866 * 7.0f / (float)this.field_3847;
        class_2338 pos = new class_2338(this.field_3874, this.field_3854, this.field_3871);
        int block = this.field_3851.method_8314(class_1944.field_9282, pos);
        int light = this.field_3851.method_8314(class_1944.field_9284, pos);
        MODEL.get().renderAsParticle(stack, consumer, this.boneType, class_765.method_23687((int)block, (int)light), class_4608.field_21444, 1.0f, 1.0f, 1.0f, alpha);
    }

    private void irisFix(class_4587 stack, class_4184 renderInfo, float partialTicks) {
        if (!RuneCraftory.iris) {
            return;
        }
        stack.method_22907(class_1160.field_20703.method_23214(class_3532.method_16439((float)partialTicks, (float)this.cameraLastPitch, (float)renderInfo.method_19329())));
        stack.method_22907(class_1160.field_20705.method_23214(class_3532.method_16439((float)partialTicks, (float)this.cameraLastYaw, (float)(renderInfo.method_19330() - 180.0f))));
        this.cameraLastPitch = renderInfo.method_19329();
        this.cameraLastYaw = renderInfo.method_19330() - 180.0f;
    }

    public class_3999 method_18122() {
        return CustomParticleRenderTypes.ENTITY_MODEL_TYPE;
    }

    public record SkelefangParticleFactoryBase(class_4002 sprite) implements class_707<SkelefangParticleData>
    {
        public class_703 createParticle(SkelefangParticleData data, class_638 level, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new SkelefangParticle(level, x, y, z, motionX, motionY, motionZ, data);
        }
    }
}

