/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.tooltips;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_918;

public class UpgradeTooltipComponent
implements class_5684 {
    private static final Supplier<class_1799> MAGNIFYING_GLASS = Suppliers.memoize(() -> new class_1799((class_1935)ModItems.GLASS.get()));
    private static final Supplier<class_1799> SCRAP_PLUS = Suppliers.memoize(() -> new class_1799((class_1935)ModItems.SCRAP_PLUS.get()));
    private static final Supplier<class_1799> QUESTION = Suppliers.memoize(() -> new class_1799((class_1935)ModItems.UNKNOWN.get()));
    private final List<class_1799> stacks = new ArrayList<class_1799>();

    public UpgradeTooltipComponent(UpgradeComponent comp) {
        class_1799 originItem;
        EnumElement element;
        class_1799 stack = comp.stack;
        if (ItemNBT.isWeapon(stack) && (element = ItemNBT.getElement(stack)) != EnumElement.NONE) {
            this.stacks.add(element.icon.get());
        }
        if (ItemNBT.doesFixedOneDamage(stack)) {
            this.stacks.add(SCRAP_PLUS.get());
        }
        if (ItemNBT.isInvis(stack)) {
            this.stacks.add(QUESTION.get());
        }
        if (ItemNBT.canBeUsedAsMagnifyingGlass(stack) && stack.method_7909() != ModItems.GLASS.get()) {
            this.stacks.add(MAGNIFYING_GLASS.get());
        }
        if (!this.stacks.isEmpty()) {
            this.stacks.add(class_1799.field_8037);
        }
        if (!(originItem = ItemNBT.getOriginItem(stack)).method_7960()) {
            this.stacks.add(originItem);
        }
    }

    public static boolean shouldAdd(class_1799 stack) {
        return ItemNBT.canBeUsedAsMagnifyingGlass(stack) && stack.method_7909() != ModItems.GLASS.get() || ItemNBT.isWeapon(stack) && ItemNBT.getElement(stack) != EnumElement.NONE || ItemNBT.doesFixedOneDamage(stack) || ItemNBT.isInvis(stack) || !ItemNBT.getOriginItem(stack).method_7960();
    }

    public int method_32661() {
        return 16;
    }

    public int method_32664(class_327 font) {
        return this.stacks.size() * 16 + 2;
    }

    public void method_32666(class_327 font, int mouseX, int mouseY, class_4587 poseStack, class_918 itemRenderer, int blitOffset) {
        if (this.stacks.isEmpty()) {
            return;
        }
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        float scale = 0.8f;
        modelViewStack.method_22905(scale, scale, 1.0f);
        int x = (int)((float)mouseX / scale);
        int y = (int)((float)mouseY / scale);
        for (class_1799 stack : this.stacks) {
            if (!stack.method_7960()) {
                this.renderItem(stack, itemRenderer, x, y);
            }
            x += 16;
        }
        modelViewStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    private void renderItem(class_1799 stack, class_918 renderer, int x, int y) {
        renderer.method_4023(stack, x, y);
    }

    public record UpgradeComponent(class_1799 stack) implements class_5632
    {
    }
}

