/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.advancements;

import com.google.gson.JsonObject;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.class_1657;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5267;

public class SkillLevelTrigger
extends class_4558<TriggerInstance> {
    public static final class_2960 ID = new class_2960("runecraftory", "skill_level_trigger");

    protected TriggerInstance createInstance(JsonObject json, class_2048.class_5258 player, class_5257 context) {
        String s = class_3518.method_15253((JsonObject)json, (String)"skill", (String)"*");
        EnumSkills skill = null;
        if (!s.equals("*")) {
            try {
                skill = EnumSkills.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                RuneCraftory.LOGGER.error("Error with skill level trigger. No such skill {}", (Object)s);
            }
        }
        return new TriggerInstance(player, class_3518.method_15282((JsonObject)json, (String)"level", (int)1), skill);
    }

    public void trigger(class_3222 player, EnumSkills skill) {
        this.method_22510(player, inst -> inst.matches(player, skill));
    }

    public class_2960 method_794() {
        return ID;
    }

    public static class TriggerInstance
    extends class_195 {
        private final int level;
        private final EnumSkills skill;

        public TriggerInstance(class_2048.class_5258 composite, int amount, EnumSkills skill) {
            super(ID, composite);
            this.level = Math.max(1, amount);
            this.skill = skill;
        }

        public static TriggerInstance of(int amount) {
            return new TriggerInstance(class_2048.class_5258.field_24388, amount, null);
        }

        public static TriggerInstance of(int amount, EnumSkills skill) {
            return new TriggerInstance(class_2048.class_5258.field_24388, amount, skill);
        }

        public boolean matches(class_3222 player, EnumSkills skill) {
            return Platform.INSTANCE.getPlayerData((class_1657)player).map(d -> (this.skill == null || skill == this.skill) && d.getSkillLevel(skill).getLevel() >= this.level).orElse(false);
        }

        public JsonObject method_807(class_5267 context) {
            JsonObject obj = super.method_807(context);
            obj.addProperty("level", (Number)this.level);
            obj.addProperty("skill", this.skill == null ? "*" : this.skill.name());
            return obj;
        }
    }
}

