/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.flemmli97.runecraftory.common.attachment.player.EntityStatsTracker;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import net.minecraft.class_1297;
import net.minecraft.class_161;
import net.minecraft.class_184;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5267;

public class TameMonsterTrigger
extends class_4558<TriggerInstance> {
    public static final class_2960 ID = new class_2960("runecraftory", "tame_monster");

    protected TriggerInstance createInstance(JsonObject json, class_2048.class_5258 player, class_5257 context) {
        return new TriggerInstance(player, class_2048.method_8913((JsonElement)json.get("entity")), class_3518.method_15282((JsonObject)json, (String)"amount", (int)1), class_3518.method_15258((JsonObject)json, (String)"bosses", (boolean)false));
    }

    public void trigger(class_3222 player, BaseMonster monster, EntityStatsTracker tracker) {
        this.method_22510(player, inst -> inst.matches(player, monster, tracker));
    }

    public class_2960 method_794() {
        return ID;
    }

    public static class TriggerInstance
    extends class_195 {
        private final int amount;
        private final boolean bossOnly;
        private final class_2048 entityPredicate;

        public TriggerInstance(class_2048.class_5258 playerPredicate, class_2048 entityPredicate, int amount, boolean bossOnly) {
            super(ID, playerPredicate);
            this.amount = amount;
            this.bossOnly = bossOnly;
            this.entityPredicate = entityPredicate;
        }

        public static TriggerInstance of(int amount) {
            return new TriggerInstance(class_2048.class_5258.field_24388, class_2048.field_9599, amount, false);
        }

        public static class_161.class_162 amountOfSteps(class_161.class_162 builder, String key, int amount, boolean boss) {
            for (int i = 0; i < amount; ++i) {
                builder.method_709(key + "_" + i, (class_184)(boss ? TriggerInstance.bossOf(i + 1) : TriggerInstance.of(i + 1)));
            }
            return builder;
        }

        public static TriggerInstance bossOf(int amount) {
            return new TriggerInstance(class_2048.class_5258.field_24388, class_2048.field_9599, amount, true);
        }

        public boolean matches(class_3222 player, BaseMonster monster, EntityStatsTracker tracker) {
            if (this.entityPredicate != null && this.entityPredicate != class_2048.field_9599) {
                if (!this.entityPredicate.method_8914(player, (class_1297)monster)) {
                    return false;
                }
                return tracker.getTameCount(monster.method_5864()) >= this.amount;
            }
            if (this.bossOnly) {
                if (!monster.method_5864().method_20210(RunecraftoryTags.BOSS_MONSTERS)) {
                    return false;
                }
                return tracker.getTotalTameCount(true) >= this.amount;
            }
            return tracker.getTotalTameCount(false) >= this.amount;
        }

        public JsonObject method_807(class_5267 context) {
            JsonObject obj = super.method_807(context);
            obj.addProperty("amount", (Number)this.amount);
            obj.addProperty("bosses", Boolean.valueOf(this.bossOnly));
            obj.add("entity", this.entityPredicate.method_8912());
            return obj;
        }
    }
}

